/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.query;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Statistics
implements Comparable<Statistics>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final Statistics EMPTY_STATISTICS = new Statistics();
    private final long planningNanos;
    private final long optimizationNanos;
    private final long resultFormulationNanos;
    private final long executionNanos;
    static ThreadLocal<DecimalFormat> FORMATTER = new ThreadLocal<DecimalFormat>(){

        @Override
        protected synchronized DecimalFormat initialValue() {
            return new DecimalFormat("###,###,##0.0##");
        }
    };

    public Statistics() {
        this(0L, 0L, 0L, 0L);
    }

    public Statistics(long planningNanos) {
        this(planningNanos, 0L, 0L, 0L);
    }

    public Statistics(long planningNanos, long optimizationNanos, long resultFormulationNanos, long executionNanos) {
        this.planningNanos = planningNanos;
        this.optimizationNanos = optimizationNanos;
        this.resultFormulationNanos = resultFormulationNanos;
        this.executionNanos = executionNanos;
    }

    public long getPlanningTime(TimeUnit unit) {
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        return unit.convert(this.planningNanos, TimeUnit.NANOSECONDS);
    }

    public long getOptimizationTime(TimeUnit unit) {
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        return unit.convert(this.optimizationNanos, TimeUnit.NANOSECONDS);
    }

    public long getResultFormulationTime(TimeUnit unit) {
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        return unit.convert(this.resultFormulationNanos, TimeUnit.NANOSECONDS);
    }

    public long getExecutionTime(TimeUnit unit) {
        return unit.convert(this.executionNanos, TimeUnit.NANOSECONDS);
    }

    public long getTotalTime(TimeUnit unit) {
        return unit.convert(this.totalTime(), TimeUnit.NANOSECONDS);
    }

    protected long totalTime() {
        return this.planningNanos + this.optimizationNanos + this.resultFormulationNanos + this.executionNanos;
    }

    public Statistics withPlanningTime(long planningNanos) {
        Validate.isTrue((planningNanos >= 0L ? 1 : 0) != 0, (String)"planningNanos should not >=0");
        return new Statistics(planningNanos, this.optimizationNanos, this.resultFormulationNanos, this.executionNanos);
    }

    public Statistics withOptimizationTime(long optimizationNanos) {
        Validate.isTrue((optimizationNanos >= 0L ? 1 : 0) != 0, (String)"optimizationNanos should not >=0");
        return new Statistics(this.planningNanos, optimizationNanos, this.resultFormulationNanos, this.executionNanos);
    }

    public Statistics withResultsFormulationTime(long resultFormulationNanos) {
        Validate.isTrue((resultFormulationNanos >= 0L ? 1 : 0) != 0, (String)"resultFormulationNanos should not >=0");
        return new Statistics(this.planningNanos, this.optimizationNanos, resultFormulationNanos, this.executionNanos);
    }

    public Statistics withExecutionTime(long executionNanos) {
        Validate.isTrue((executionNanos >= 0L ? 1 : 0) != 0, (String)"executionNanos should not >=0");
        return new Statistics(this.planningNanos, this.optimizationNanos, this.resultFormulationNanos, executionNanos);
    }

    public Statistics withPlanningTime(long planning, TimeUnit unit) {
        Validate.isTrue((planning >= 0L ? 1 : 0) != 0, (String)"planning should not >=0");
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        long planningNanos = TimeUnit.NANOSECONDS.convert(planning, unit);
        return new Statistics(planningNanos, this.optimizationNanos, this.resultFormulationNanos, this.executionNanos);
    }

    public Statistics withOptimizationTime(long optimization, TimeUnit unit) {
        Validate.isTrue((optimization >= 0L ? 1 : 0) != 0, (String)"optimization should not >=0");
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        long optimizationNanos = TimeUnit.NANOSECONDS.convert(optimization, unit);
        return new Statistics(this.planningNanos, optimizationNanos, this.resultFormulationNanos, this.executionNanos);
    }

    public Statistics withResultsFormulationTime(long resultFormulation, TimeUnit unit) {
        Validate.isTrue((resultFormulation >= 0L ? 1 : 0) != 0, (String)"resultFormulation should not >=0");
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        long resultFormulationNanos = TimeUnit.NANOSECONDS.convert(resultFormulation, unit);
        return new Statistics(this.planningNanos, this.optimizationNanos, resultFormulationNanos, this.executionNanos);
    }

    public Statistics withExecutionTime(long execution, TimeUnit unit) {
        Validate.isTrue((execution >= 0L ? 1 : 0) != 0, (String)"execution should not >=0");
        Validate.notNull((Object)((Object)unit), (String)"Unit should not be null");
        long executionNanos = TimeUnit.NANOSECONDS.convert(execution, unit);
        return new Statistics(this.planningNanos, this.optimizationNanos, this.resultFormulationNanos, executionNanos);
    }

    @Override
    public int compareTo(Statistics that) {
        if (that == this) {
            return 0;
        }
        long diff = this.totalTime() - that.totalTime();
        if (diff < 0L) {
            return -1;
        }
        if (diff > 0L) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.readable(this.totalTime(), sb);
        boolean first = false;
        if (this.planningNanos != 0L) {
            sb.append(" (plan=");
            this.readable(this.planningNanos, sb);
            first = false;
        }
        if (this.optimizationNanos != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("opt=");
            this.readable(this.optimizationNanos, sb);
        }
        if (this.resultFormulationNanos != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("res=");
            this.readable(this.resultFormulationNanos, sb);
        }
        if (this.executionNanos != 0L) {
            if (first) {
                first = false;
                sb.append(" (");
            } else {
                sb.append(" ,");
            }
            sb.append("exec=");
            this.readable(this.executionNanos, sb);
        }
        if (!first) {
            sb.append(')');
        }
        return sb.toString();
    }

    protected void readable(long nanos, StringBuilder sb) {
        if (nanos < 1000L) {
            sb.append(nanos).append(" ns");
        } else if (nanos < 1000000L) {
            double value = (double)nanos / 1000.0;
            sb.append(FORMATTER.get().format(value)).append(" usec");
        } else if (nanos < 1000000000L) {
            double value = (double)nanos / 1000000.0;
            sb.append(FORMATTER.get().format(value)).append(" ms");
        } else {
            double value = (double)nanos / 1.0E9;
            sb.append(FORMATTER.get().format(value)).append(" sec");
        }
    }
}

