/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.shindig.oauth;

import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.ide.shindig.oauth.SecurityTokenGenerator;
import org.exoplatform.ide.shindig.oauth.TokenRequest;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.rest.resource.ResourceContainer;

@Path(value="/services/shindig/securitytoken")
public class RestSecurityTokenGenerator
implements ResourceContainer {
    private final Log log = ExoLogger.getLogger((String)"rest.RestSecurityTokenGenerator");
    private String keyFile;
    private static final String DEFAULT_KEY_FILE = "key.txt";

    public RestSecurityTokenGenerator(InitParams initParams) {
        ValueParam param;
        this.keyFile = initParams != null ? ((param = initParams.getValueParam("keyFile")) != null ? param.getValue() : DEFAULT_KEY_FILE) : DEFAULT_KEY_FILE;
    }

    @POST
    @Path(value="/createToken")
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public Response createToken(TokenRequest tokenRequest) {
        try {
            return Response.ok((Object)SecurityTokenGenerator.createToken(tokenRequest, this.keyFile)).build();
        }
        catch (IOException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new WebApplicationException((Throwable)e);
        }
        catch (BlobCrypterException e) {
            if (this.log.isDebugEnabled()) {
                e.printStackTrace();
            }
            throw new WebApplicationException((Throwable)e);
        }
    }
}

