/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.plugin.link;

import java.util.List;
import java.util.regex.Pattern;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.service.rest.LinkShare;
import org.exoplatform.social.webui.activity.UIActivitiesContainer;
import org.exoplatform.social.webui.composer.UIActivityComposer;
import org.exoplatform.social.webui.composer.UIComposer;
import org.exoplatform.social.webui.profile.UIUserActivitiesDisplay;
import org.exoplatform.social.webui.space.UISpaceActivitiesDisplay;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormStringInput;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/plugin/link/UILinkActivityComposer.gtmpl", events={@EventConfig(listeners={AttachActionListener.class}), @EventConfig(listeners={ChangeLinkContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.CloseActionListener.class}), @EventConfig(listeners={UIActivityComposer.SubmitContentActionListener.class}), @EventConfig(listeners={UIActivityComposer.ActivateActionListener.class})})
public class UILinkActivityComposer
extends UIActivityComposer {
    public static final String LINK_PARAM = "link";
    public static final String IMAGE_PARAM = "image";
    public static final String TITLE_PARAM = "title";
    public static final String DESCRIPTION_PARAM = "description";
    public static final String COMMENT_PARAM = "comment";
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private LinkShare linkShare_;
    private boolean linkInfoDisplayed_ = false;
    private JSONObject dataLink_;

    public UILinkActivityComposer() {
        this.setReadyForPostingActivity(false);
        this.addChild((UIComponent)new UIFormStringInput("InputLink", "InputLink", null));
    }

    public void setLinkInfoDisplayed(boolean displayed) {
        this.linkInfoDisplayed_ = displayed;
    }

    public boolean isLinkInfoDisplayed() {
        return this.linkInfoDisplayed_;
    }

    public void setDataLink(JSONObject dataLink) {
        this.dataLink_ = dataLink;
    }

    public JSONObject getDataLink() {
        return this.dataLink_;
    }

    public void clearLinkShare() {
        this.linkShare_ = null;
    }

    public LinkShare getLinkShare() {
        return this.linkShare_;
    }

    private void setLink(String url) throws Exception {
        if (!url.contains(HTTP) && !url.contains(HTTPS)) {
            url = HTTP + url;
        }
        this.linkShare_ = LinkShare.getInstance((String)url);
        this.dataLink_ = new JSONObject();
        this.dataLink_.put(LINK_PARAM, (Object)this.linkShare_.getLink());
        String image = "";
        List images = this.linkShare_.getImages();
        if (images != null && images.size() > 0) {
            image = (String)images.get(0);
        }
        this.dataLink_.put(IMAGE_PARAM, (Object)image);
        this.dataLink_.put(TITLE_PARAM, (Object)this.linkShare_.getTitle());
        this.dataLink_.put(DESCRIPTION_PARAM, (Object)this.linkShare_.getDescription());
        this.setLinkInfoDisplayed(true);
    }

    private boolean isImageLink(String link) {
        Pattern pattern = Pattern.compile("(?-i)(\\.jpg|\\.gif|\\.jpeg|\\.bmp|\\.png|\\.tif)$");
        return pattern.matcher(link).find();
    }

    protected void onActivate(Event<UIActivityComposer> arg0) {
    }

    protected void onClose(Event<UIActivityComposer> arg0) {
        this.setReadyForPostingActivity(false);
    }

    protected void onSubmit(Event<UIActivityComposer> arg0) {
    }

    public void onPostActivity(UIComposer.PostContext postContext, UIComponent source, WebuiRequestContext requestContext, String postedMessage) throws Exception {
        UIComposer uiComposer = (UIComposer)source;
        ActivityManager activityManager = (ActivityManager)uiComposer.getApplicationComponent(ActivityManager.class);
        IdentityManager identityManager = (IdentityManager)uiComposer.getApplicationComponent(IdentityManager.class);
        String remoteUser = requestContext.getRemoteUser();
        Identity userIdentity = identityManager.getOrCreateIdentity("organization", remoteUser);
        UIApplication uiApplication = requestContext.getUIApplication();
        JSONObject dataLink = this.getDataLink();
        dataLink.put(COMMENT_PARAM, (Object)postedMessage);
        this.setDataLink(dataLink);
        String titleData = dataLink.toString();
        if (titleData.equals("")) {
            uiApplication.addMessage(new ApplicationMessage("UIComposer.msg.error.Empty_Message", null, 1));
            return;
        }
        if (postContext == UIComposer.PostContext.SPACE) {
            UISpaceActivitiesDisplay uiDisplaySpaceActivities = (UISpaceActivitiesDisplay)this.getActivityDisplay();
            Space space = uiDisplaySpaceActivities.getSpace();
            Identity spaceIdentity = identityManager.getOrCreateIdentity("space", space.getId(), false);
            Activity activity = new Activity(userIdentity.getId(), "exosocial:spaces", titleData, null);
            activity.setType("LINK_ACTIVITY");
            activityManager.saveActivity(spaceIdentity, activity);
            UIActivitiesContainer activitiesContainer = uiDisplaySpaceActivities.getActivitiesLoader().getActivitiesContainer();
            activitiesContainer.addActivity(activity);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)activitiesContainer);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposer);
        } else if (postContext == UIComposer.PostContext.USER) {
            UIUserActivitiesDisplay uiUserActivitiesDisplay = (UIUserActivitiesDisplay)this.getActivityDisplay();
            String ownerName = uiUserActivitiesDisplay.getOwnerName();
            Identity ownerIdentity = identityManager.getOrCreateIdentity("organization", ownerName);
            Activity activity = new Activity(userIdentity.getId(), "exosocial:people", titleData, null);
            activity.setType("LINK_ACTIVITY");
            activityManager.saveActivity(ownerIdentity, activity);
            if (uiUserActivitiesDisplay.getSelectedDisplayMode() == UIUserActivitiesDisplay.DisplayMode.MY_STATUS) {
                UIActivitiesContainer activitiesContainer = uiUserActivitiesDisplay.getActivitiesLoader().getActivitiesContainer();
                if (activitiesContainer.getChildren().size() == 1) {
                    uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.MY_STATUS);
                } else {
                    activitiesContainer.addActivity(activity);
                    requestContext.addUIComponentToUpdateByAjax((UIComponent)activitiesContainer);
                    requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposer);
                }
            } else {
                uiUserActivitiesDisplay.setSelectedDisplayMode(UIUserActivitiesDisplay.DisplayMode.MY_STATUS);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeLinkContentActionListener
    extends EventListener<UILinkActivityComposer> {
        public void execute(Event<UILinkActivityComposer> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            UILinkActivityComposer uiComposerLinkExtension = (UILinkActivityComposer)((Object)event.getSource());
            JSONObject dataLink = new JSONObject();
            dataLink.put(UILinkActivityComposer.LINK_PARAM, (Object)requestContext.getRequestParameter(UILinkActivityComposer.LINK_PARAM));
            dataLink.put(UILinkActivityComposer.IMAGE_PARAM, (Object)requestContext.getRequestParameter(UILinkActivityComposer.IMAGE_PARAM));
            dataLink.put(UILinkActivityComposer.TITLE_PARAM, (Object)requestContext.getRequestParameter(UILinkActivityComposer.TITLE_PARAM));
            dataLink.put(UILinkActivityComposer.DESCRIPTION_PARAM, (Object)requestContext.getRequestParameter(UILinkActivityComposer.DESCRIPTION_PARAM));
            uiComposerLinkExtension.setDataLink(dataLink);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
            UIComponent uiParent = uiComposerLinkExtension.getParent();
            if (uiParent != null) {
                uiParent.broadcast(event, event.getExecutionPhase());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AttachActionListener
    extends EventListener<UILinkActivityComposer> {
        public void execute(Event<UILinkActivityComposer> event) throws Exception {
            WebuiRequestContext requestContext = event.getRequestContext();
            UILinkActivityComposer uiComposerLinkExtension = (UILinkActivityComposer)((Object)event.getSource());
            String url = requestContext.getRequestParameter("objectId");
            try {
                uiComposerLinkExtension.setLink(url.trim());
            }
            catch (Exception e) {
                uiComposerLinkExtension.setReadyForPostingActivity(false);
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComposerLinkExtension);
            ((UILinkActivityComposer)((Object)event.getSource())).setReadyForPostingActivity(true);
        }
    }
}

