/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.ecm.publication.actions;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import javax.jcr.observation.EventIterator;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.cms.actions.ActionServiceContainer;
import org.exoplatform.services.cms.actions.impl.ECMEventListener;
import org.exoplatform.services.cms.templates.TemplateService;
import org.exoplatform.services.ecm.publication.PublicationService;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.SystemIdentity;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;

public abstract class WorkflowActionLauncherListener
implements ECMEventListener {
    protected String actionName_;
    protected String repository_;
    protected String srcWorkspace_;
    protected String srcPath_;
    protected String executable_;
    protected Map actionVariables_;
    private static final String MIXIN_MOVE = "exo:move";
    private static final String WORKFLOW = "Workflow";
    private static final String VALIDATION_REQUEST = "validation request";
    private static final String CURRENT_STATE = "publication:currentState".intern();
    private static final String DEST_WORKSPACE = "exo:destWorkspace".intern();
    private static final String DESTPATH = "exo:destPath".intern();
    private static final String BACUP_PATH = "publication:backupPath".intern();
    private static final String DOCUMENT_BACUPUP = "documentsBackupPath";
    private static final Log LOG = ExoLogger.getLogger(WorkflowActionLauncherListener.class);

    public WorkflowActionLauncherListener(String actionName, String executable, String repository, String srcWorkspace, String srcPath, Map actionVariables) throws Exception {
        this.actionName_ = actionName;
        this.executable_ = executable;
        this.repository_ = repository;
        this.srcWorkspace_ = srcWorkspace;
        this.srcPath_ = srcPath;
        this.actionVariables_ = actionVariables;
    }

    public String getSrcWorkspace() {
        return this.srcWorkspace_;
    }

    public String getRepository() {
        return this.repository_;
    }

    public void onEvent(EventIterator events) {
        ExoContainer exoContainer = ExoContainerContext.getCurrentContainer();
        RepositoryService repositoryService = (RepositoryService)exoContainer.getComponentInstanceOfType(RepositoryService.class);
        ActionServiceContainer actionServiceContainer = (ActionServiceContainer)exoContainer.getComponentInstanceOfType(ActionServiceContainer.class);
        IdentityRegistry identityRegistry = (IdentityRegistry)exoContainer.getComponentInstanceOfType(IdentityRegistry.class);
        TemplateService templateService = (TemplateService)exoContainer.getComponentInstanceOfType(TemplateService.class);
        if (events.hasNext()) {
            Event event = events.nextEvent();
            Node node = null;
            Session jcrSession = null;
            try {
                jcrSession = repositoryService.getRepository(this.repository_).getSystemSession(this.srcWorkspace_);
                node = (Node)jcrSession.getItem(this.srcPath_);
                String userId = event.getUserID();
                Node actionNode = actionServiceContainer.getAction(node, this.actionName_);
                Property rolesProp = actionNode.getProperty("exo:roles");
                Value[] roles = rolesProp.getValues();
                boolean hasPermission = this.checkExcetuteable(userId, roles, identityRegistry);
                if (!hasPermission) {
                    jcrSession.logout();
                    return;
                }
                String path = event.getPath();
                HashMap<String, String> variables = new HashMap<String, String>();
                variables.put("initiator", userId);
                variables.put("actionName", this.actionName_);
                variables.put("nodePath", path);
                variables.put("repository", this.repository_);
                variables.put("srcWorkspace", this.srcWorkspace_);
                variables.put("srcPath", this.srcPath_);
                variables.putAll(this.actionVariables_);
                if (event.getType() == 1) {
                    node = (Node)jcrSession.getItem(path);
                    String nodeType = node.getPrimaryNodeType().getName();
                    if (templateService.getDocumentTemplates(this.repository_).contains(nodeType)) {
                        variables.put("document-type", nodeType);
                        this.triggerAction(userId, variables, this.repository_);
                    }
                } else {
                    this.triggerAction(userId, variables, this.repository_);
                }
                jcrSession.logout();
                if (node.canAddMixin(MIXIN_MOVE)) {
                    node.addMixin(MIXIN_MOVE);
                    node.getSession().save();
                }
                ExoContainer container = ExoContainerContext.getCurrentContainer();
                PublicationService publicationService = (PublicationService)container.getComponentInstanceOfType(PublicationService.class);
                publicationService.enrollNodeInLifecycle(node, WORKFLOW);
                node.getSession().save();
                node.setProperty(CURRENT_STATE, VALIDATION_REQUEST);
                String date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(new Date());
                String[] logs = new String[]{date, VALIDATION_REQUEST, node.getSession().getUserID(), "PublicationService.WorkflowPublicationPlugin.nodeValidationRequest"};
                publicationService.addLog(node, logs);
                NodeHierarchyCreator hierarchyCreator = (NodeHierarchyCreator)container.getComponentInstanceOfType(NodeHierarchyCreator.class);
                String documentBackup = hierarchyCreator.getJcrPath(DOCUMENT_BACUPUP);
                node.setProperty(DEST_WORKSPACE, actionNode.getProperty(DEST_WORKSPACE).getString());
                node.setProperty(DESTPATH, actionNode.getProperty(DESTPATH).getString());
                node.setProperty(BACUP_PATH, documentBackup);
                node.getSession().save();
            }
            catch (Exception e) {
                if (jcrSession != null) {
                    jcrSession.logout();
                }
                LOG.error((Object)"Unexpected error", (Throwable)e);
            }
        }
    }

    public abstract void triggerAction(String var1, Map var2, String var3) throws Exception;

    private boolean checkExcetuteable(String userId, Value[] roles, IdentityRegistry identityRegistry) throws Exception {
        if (SystemIdentity.SYSTEM.equalsIgnoreCase(userId)) {
            return true;
        }
        Identity identity = identityRegistry.getIdentity(userId);
        if (identity == null) {
            return false;
        }
        for (int i = 0; i < roles.length; ++i) {
            String role = roles[i].getString();
            if ("*".equalsIgnoreCase(role)) {
                return true;
            }
            MembershipEntry membershipEntry = MembershipEntry.parse((String)role);
            if (!identity.isMemberOf(membershipEntry)) continue;
            return true;
        }
        return false;
    }
}

