/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.taxonomy;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Session;
import javax.portlet.PortletPreferences;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyForm;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyTree;
import org.exoplatform.ecm.webui.component.admin.taxonomy.UITaxonomyWorkingArea;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.portal.webui.util.SessionProviderFactory;
import org.exoplatform.services.cms.impl.DMSConfiguration;
import org.exoplatform.services.cms.impl.DMSRepositoryConfiguration;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.hierarchy.NodeHierarchyCreator;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.application.portlet.PortletRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIBreadcumbs;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIContainerLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.ext.manager.UIAbstractManager;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIContainerLifecycle.class), @ComponentConfig(type=UIBreadcumbs.class, id="BreadcumbTaxonomyECMAdmin", template="system:/groovy/webui/core/UIBreadcumbs.gtmpl", events={@EventConfig(listeners={SelectPathActionListener.class})})})
public class UITaxonomyManager
extends UIAbstractManager {
    private static String TAXONOMIES_ALIAS = "exoTaxonomiesPath";
    private static String EXO_ECM_ALIAS = "exoECMSystemPath";
    public static final String PERMISSION_ID_POPUP = "TaxonomyViewPermissionPopup";
    private String selectedPath_ = null;

    public UITaxonomyManager() throws Exception {
        this.addChild(UIBreadcumbs.class, "BreadcumbTaxonomyECMAdmin", "BreadcumbTaxonomyECMAdmin");
        this.addChild(UITaxonomyTree.class, null, null);
        this.addChild(UITaxonomyWorkingArea.class, null, null);
    }

    public void init() throws Exception {
    }

    public void refresh() throws Exception {
        this.update();
    }

    public void update() throws Exception {
        UITaxonomyTree uiTree = (UITaxonomyTree)this.getChild(UITaxonomyTree.class);
        uiTree.update();
        UITaxonomyWorkingArea uiTaxonomyWorkingArea = (UITaxonomyWorkingArea)this.getChild(UITaxonomyWorkingArea.class);
        uiTaxonomyWorkingArea.update();
    }

    public void update(String parentPath) throws Exception {
        UITaxonomyTree uiTree = (UITaxonomyTree)this.getChild(UITaxonomyTree.class);
        uiTree.setNodeSelect(parentPath);
        UITaxonomyWorkingArea uiWorkingArea = (UITaxonomyWorkingArea)this.getChild(UITaxonomyWorkingArea.class);
        uiWorkingArea.setSelectedPath(parentPath);
        uiWorkingArea.update();
    }

    public Node getRootNode() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return (Node)this.getSession().getItem(nodeHierarchyCreator.getJcrPath(EXO_ECM_ALIAS));
    }

    public Node getTaxonomyNode() throws Exception {
        NodeHierarchyCreator nodeHierarchyCreator = (NodeHierarchyCreator)this.getApplicationComponent(NodeHierarchyCreator.class);
        return (Node)this.getSession().getItem(nodeHierarchyCreator.getJcrPath(TAXONOMIES_ALIAS));
    }

    public void setSelectedPath(String selectedPath) {
        this.selectedPath_ = selectedPath;
    }

    public String getSelectedPath() {
        return this.selectedPath_;
    }

    public Node getNodeByPath(String path) throws Exception {
        return (Node)this.getSession().getItem(path);
    }

    public String getRepository() throws Exception {
        PortletRequestContext pcontext = (PortletRequestContext)WebuiRequestContext.getCurrentInstance();
        PortletPreferences pref = pcontext.getRequest().getPreferences();
        String repository = pref.getValue(Utils.REPOSITORY, "");
        return repository;
    }

    private String getDmsSystemWorkspaceName(String repository) {
        DMSConfiguration dmsConfiguration = (DMSConfiguration)this.getApplicationComponent(DMSConfiguration.class);
        DMSRepositoryConfiguration dmsRepoConfig = dmsConfiguration.getConfig(repository);
        return dmsRepoConfig.getSystemWorkspace();
    }

    public Session getSession() throws Exception {
        String repositoryName = ((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).getPreferenceRepository();
        String workspace = this.getDmsSystemWorkspaceName(repositoryName);
        return SessionProviderFactory.createSystemProvider().getSession(workspace, this.getRepository(repositoryName));
    }

    public ManageableRepository getRepository(String repositoryName) throws Exception {
        RepositoryService repositoryService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return repositoryService.getRepository(repositoryName);
    }

    public void initPopup(String path) throws Exception {
        this.removeChildById("TaxonomyPopup");
        UIPopupWindow uiPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, null, "TaxonomyPopup");
        uiPopup.setWindowSize(600, 250);
        UITaxonomyForm uiTaxoForm = (UITaxonomyForm)this.createUIComponent(UITaxonomyForm.class, null, null);
        uiPopup.setUIComponent((UIComponent)uiTaxoForm);
        uiTaxoForm.setParent(path);
        uiPopup.setRendered(true);
        uiPopup.setShow(true);
    }

    public UIPopupContainer initPopupPermission(String id) throws Exception {
        this.removeChildById(id);
        return (UIPopupContainer)this.addChild(UIPopupContainer.class, null, id);
    }

    public void onChange(Node currentNode) throws Exception {
        String subTaxonomy;
        String[] arrayPath;
        String taxonomyPath;
        UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        ArrayList<UIBreadcumbs.LocalPath> listLocalPath = new ArrayList<UIBreadcumbs.LocalPath>();
        String path = currentNode.getPath().trim();
        if (path.startsWith(taxonomyPath = this.getTaxonomyNode().getPath()) && (arrayPath = (subTaxonomy = path.substring(taxonomyPath.length(), path.length())).split("/")).length > 0) {
            for (int i = 0; i < arrayPath.length; ++i) {
                if (arrayPath[i].trim().equals("")) continue;
                UIBreadcumbs.LocalPath localPath1 = new UIBreadcumbs.LocalPath(arrayPath[i].trim(), arrayPath[i].trim());
                listLocalPath.add(localPath1);
            }
        }
        uiBreadcumbs.setPath(listLocalPath);
    }

    public void changeGroup(String groupId, Object context) throws Exception {
        List listLocalPath;
        String stringPath = this.getTaxonomyNode().getPath() + "/";
        UIBreadcumbs uiBreadcumb = (UIBreadcumbs)this.getChild(UIBreadcumbs.class);
        if (groupId == null) {
            groupId = "";
        }
        if ((listLocalPath = uiBreadcumb.getPath()) == null || listLocalPath.size() == 0) {
            return;
        }
        ArrayList<String> listLocalPathString = new ArrayList<String>();
        for (UIBreadcumbs.LocalPath localPath : listLocalPath) {
            listLocalPathString.add(localPath.getId().trim());
        }
        if (listLocalPathString.contains(groupId)) {
            int i;
            int index = listLocalPathString.indexOf(groupId);
            if (index == listLocalPathString.size() - 1) {
                return;
            }
            for (i = listLocalPathString.size() - 1; i > index; --i) {
                listLocalPathString.remove(i);
                listLocalPath.remove(i);
            }
            uiBreadcumb.setPath(listLocalPath);
            for (i = 0; i < listLocalPathString.size(); ++i) {
                String pathName = (String)listLocalPathString.get(i);
                if (pathName == null || pathName.length() <= 0) continue;
                stringPath = stringPath + pathName.trim();
                if (i >= listLocalPathString.size() - 1) continue;
                stringPath = stringPath + "/";
            }
            UITaxonomyTree uiTaxonomyTree = (UITaxonomyTree)this.getChild(UITaxonomyTree.class);
            uiTaxonomyTree.setNodeSelect(stringPath);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectPathActionListener
    extends EventListener<UIBreadcumbs> {
        public void execute(Event<UIBreadcumbs> event) throws Exception {
            UIBreadcumbs uiBreadcumbs = (UIBreadcumbs)event.getSource();
            UITaxonomyManager uiTaxonomyManager = (UITaxonomyManager)uiBreadcumbs.getParent();
            String objectId = event.getRequestContext().getRequestParameter("objectId");
            uiBreadcumbs.setSelectPath(objectId);
            String selectGroupId = uiBreadcumbs.getSelectLocalPath().getId();
            uiTaxonomyManager.changeGroup(selectGroupId, event.getRequestContext());
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiTaxonomyManager);
        }
    }
}

