/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.arjuna.objectstore.LogStore;
import java.util.Collection;
import java.util.HashMap;

class LogPurger
extends Thread {
    public static final long DEFAULT_PURGE_TIME = 100000L;
    private HashMap<Uid, LogElement> _entries = new HashMap();
    private long _purgeTime;
    private LogStore _objStore;
    private Status _status;
    private Object _lock = new Object();

    public LogPurger(LogStore instance) {
        this(instance, 100000L);
    }

    public LogPurger(LogStore instance, long purgeTime) {
        this._objStore = instance;
        this._purgeTime = purgeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovedState(Uid u, String tn, int state) {
        HashMap<Uid, LogElement> hashMap = this._entries;
        synchronized (hashMap) {
            this._entries.put(u, new LogElement(tn, u, state));
        }
    }

    public void purge() {
        try {
            this._objStore.truncateLogs(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRemovalEntries() {
        HashMap<Uid, LogElement> hashMap = this._entries;
        synchronized (hashMap) {
            if (this._entries.size() > 0) {
                Collection<LogElement> entries = this._entries.values();
                for (LogElement val : entries) {
                    try {
                        this._objStore.removeState(val.uid, val.tn, val.state);
                    }
                    catch (Exception ex) {}
                }
                this._entries.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        Object object = this._lock;
        synchronized (object) {
            if (this._status == Status.PASSIVE) {
                this._lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            try {
                Object object = this._lock;
                synchronized (object) {
                    this._status = Status.PASSIVE;
                    this._lock.wait(this._purgeTime);
                }
            }
            catch (Exception ex) {
                this._status = Status.ACTIVE;
            }
            System.err.println("**THREAD RUNNING");
            this.writeRemovalEntries();
            try {
                this._objStore.truncateLogs();
            }
            catch (Exception exception) {
            }
        }
    }

    class LogElement {
        public String tn;
        public Uid uid;
        public int state;

        public LogElement(String t, Uid u, int s) {
            this.tn = t;
            this.uid = u;
            this.state = s;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Status {
        ACTIVE,
        PASSIVE,
        TERMINATED;

    }
}

