/*
 * Decompiled with CFR 0.152.
 */
package org.chromattic.core.vt;

import java.io.InputStream;
import java.util.Date;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import org.chromattic.core.vt.BaseValueType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ValueType<V> {
    public static final ValueType<Object> DEFAULT = new ValueType<Object>(){
        private final BaseValueType STRING = new BaseValueType.STRING.TO_STRING(null, String.class);
        private final BaseValueType INT = new BaseValueType.LONG.TO_INT(null, Integer.class);
        private final BaseValueType LONG = new BaseValueType.LONG.TO_LONG(null, Long.class);
        private final BaseValueType DATE = new BaseValueType.DATE.TO_DATE(null, Date.class);
        private final BaseValueType DOUBLE = new BaseValueType.DOUBLE.TO_DOUBLE(null, Double.class);
        private final BaseValueType FLOAT = new BaseValueType.DOUBLE.TO_FLOAT(null, Float.class);
        private final BaseValueType STREAM = new BaseValueType.STREAM.TO_STREAM(null, InputStream.class);
        private final BaseValueType BOOLEAN = new BaseValueType.BOOLEAN.TO_BOOLEAN(null, Boolean.class);

        @Override
        public List<Object> getDefaultValue() {
            return null;
        }

        @Override
        public boolean isPrimitive() {
            return false;
        }

        @Override
        public Object get(Value value) throws RepositoryException {
            int propertyType = value.getType();
            switch (propertyType) {
                case 6: {
                    return value.getBoolean();
                }
                case 3: {
                    return (int)value.getLong();
                }
                case 4: {
                    return value.getDouble();
                }
                case 1: 
                case 7: 
                case 8: {
                    return value.getString();
                }
                case 2: {
                    return value.getStream();
                }
                case 5: {
                    return value.getDate().getTime();
                }
            }
            throw new AssertionError((Object)("Property type " + propertyType + " not handled"));
        }

        @Override
        public Value get(ValueFactory valueFactory, Object o) throws ValueFormatException {
            BaseValueType typeKind;
            if (o instanceof String) {
                typeKind = this.STRING;
            } else if (o instanceof Integer) {
                typeKind = this.INT;
            } else if (o instanceof Long) {
                typeKind = this.LONG;
            } else if (o instanceof Date) {
                typeKind = this.DATE;
            } else if (o instanceof Double) {
                typeKind = this.DOUBLE;
            } else if (o instanceof Float) {
                typeKind = this.FLOAT;
            } else if (o instanceof InputStream) {
                typeKind = this.STREAM;
            } else if (o instanceof Boolean) {
                typeKind = this.BOOLEAN;
            } else {
                throw new UnsupportedOperationException("Type " + o.getClass().getName() + " is not accepted");
            }
            return typeKind.get(valueFactory, o);
        }

        @Override
        public Class<Object> getObjectType() {
            return Object.class;
        }

        @Override
        public Class<?> getRealType() {
            return Object.class;
        }
    };

    public abstract List<V> getDefaultValue();

    public abstract boolean isPrimitive();

    public abstract V get(Value var1) throws RepositoryException;

    public abstract Value get(ValueFactory var1, V var2) throws ValueFormatException;

    public abstract Class<V> getObjectType();

    public abstract Class<?> getRealType();
}

