/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.wcm.search;

import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import javax.jcr.query.RowIterator;
import org.apache.commons.lang.ArrayUtils;
import org.exoplatform.commons.exception.ExoMessageException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.wcm.core.NodeLocation;
import org.exoplatform.services.wcm.publication.WCMComposer;
import org.exoplatform.services.wcm.search.PaginatedQueryResult;
import org.exoplatform.services.wcm.search.QueryCriteria;
import org.exoplatform.services.wcm.search.ResultNode;
import org.exoplatform.services.wcm.search.SiteSearchService;
import org.exoplatform.services.wcm.utils.WCMCoreUtils;

public class WCMPaginatedQueryResult
extends PaginatedQueryResult {
    private long queryTime;
    private String spellSuggestion;
    private long numTotal = -1L;
    private boolean showTotalPagination = false;

    public WCMPaginatedQueryResult(int pageSize) {
        super(pageSize);
    }

    public WCMPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize, boolean isSearchContent) throws Exception {
        super(queryResult, pageSize, isSearchContent);
        this.queryCriteria = queryCriteria;
    }

    public WCMPaginatedQueryResult(QueryResult queryResult, QueryCriteria queryCriteria, int pageSize, long numTotal, boolean showTotalPagination, boolean isSearchContent) throws Exception {
        super(queryResult, pageSize, isSearchContent);
        this.numTotal = numTotal;
        this.queryCriteria = queryCriteria;
        this.showTotalPagination = showTotalPagination;
        this.populateCurrentListPage(queryResult);
    }

    public void setQueryTime(long time) {
        this.queryTime = time;
    }

    public float getQueryTimeInSecond() {
        return (float)this.queryTime / 1000.0f;
    }

    public QueryCriteria getQueryCriteria() {
        return this.queryCriteria;
    }

    public void setQueryCriteria(QueryCriteria queryCriteria) {
        this.queryCriteria = queryCriteria;
    }

    public int getAvailable() {
        if (this.numTotal > -1L) {
            return (int)this.numTotal;
        }
        return super.getAvailable();
    }

    public int getAvailablePage() {
        if (this.numTotal > -1L) {
            int npp = this.getNodesPerPage();
            double available = Math.ceil((double)this.numTotal / (double)npp);
            return (int)available;
        }
        return super.getAvailablePage();
    }

    public long getTotalNodes() {
        if (this.numTotal > -1L) {
            return this.numTotal;
        }
        return super.getTotalNodes();
    }

    protected void populateCurrentPage(int page) throws Exception {
        if (page == this.currentPage_ && this.currentListPage_ != null && !this.currentListPage_.isEmpty()) {
            return;
        }
        SiteSearchService siteSearchService = (SiteSearchService)WCMCoreUtils.getService(SiteSearchService.class);
        this.queryCriteria.setOffset((page - 1) * this.getPageSize());
        QueryResult queryResult = siteSearchService.searchSiteContents((SessionProvider)WCMCoreUtils.getUserSessionProvider(), (QueryCriteria)this.queryCriteria, (int)this.getPageSize(), (boolean)false).queryResult;
        this.populateCurrentListPage(queryResult);
        this.currentPage_ = page;
    }

    protected void populateCurrentListPage(QueryResult queryResult) throws Exception {
        this.currentListPage_ = new CopyOnWriteArrayList();
        RowIterator rowIterator = queryResult.getRows();
        NodeIterator iterator = queryResult.getNodes();
        int count = 0;
        while (iterator.hasNext()) {
            Row row = rowIterator.nextRow();
            Node node = iterator.nextNode();
            Node viewNode = this.filterNodeToDisplay(node);
            if (viewNode == null) continue;
            ResultNode resultNode = new ResultNode(viewNode, row);
            this.currentListPage_.add(resultNode);
            if (++count != this.getPageSize()) continue;
            break;
        }
    }

    public void setCurrentPage(int page) throws Exception {
        this.populateCurrentPage(page);
    }

    public List getPage(int page) throws Exception {
        if (page < 1 || page > this.getAvailablePage() && this.showTotalPagination) {
            Object[] args = new Object[]{Integer.toString(page), Integer.toString(this.availablePage_)};
            throw new ExoMessageException("PageList.page-out-of-range", args);
        }
        this.populateCurrentPage(page);
        return this.currentListPage_;
    }

    protected Node filterNodeToDisplay(Node node, boolean isSearchContent) throws Exception {
        Node displayNode = this.getNodeToCheckState(node);
        if (displayNode == null) {
            return null;
        }
        if (isSearchContent) {
            return displayNode;
        }
        NodeLocation nodeLocation = NodeLocation.make((Node)displayNode);
        WCMComposer wcmComposer = (WCMComposer)WCMCoreUtils.getService(WCMComposer.class);
        HashMap<String, String> filters = new HashMap<String, String>();
        filters.put("filter-mode", "Live");
        return wcmComposer.getContent(nodeLocation.getRepository(), nodeLocation.getWorkspace(), nodeLocation.getPath(), filters, WCMCoreUtils.getSystemSessionProvider());
    }

    protected Node getNodeToCheckState(Node node) throws Exception {
        String primaryNodeType;
        Node displayNode = node;
        if (node.getPath().contains("web contents/site artifacts")) {
            return null;
        }
        if (displayNode.isNodeType("nt:resource")) {
            displayNode = node.getParent();
        }
        if (displayNode.isNodeType("exo:htmlFile")) {
            Node parent = displayNode.getParent();
            if (this.queryCriteria.isSearchWebContent()) {
                if (parent.isNodeType("exo:webContent")) {
                    return parent;
                }
                return null;
            }
            if (parent.isNodeType("exo:webContent")) {
                return null;
            }
            return displayNode;
        }
        Object[] contentTypes = this.queryCriteria.getContentTypes();
        if (contentTypes != null && contentTypes.length > 0 && !ArrayUtils.contains((Object[])contentTypes, (Object)(primaryNodeType = displayNode.getPrimaryNodeType().getName()))) {
            return null;
        }
        return displayNode;
    }

    public String getSpellSuggestion() {
        return this.spellSuggestion;
    }

    public void setSpellSuggestion(String spellSuggestion) {
        this.spellSuggestion = spellSuggestion;
    }
}

