/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend;

import com.install4j.runtime.installer.config.LanguageConfig;
import com.install4j.runtime.installer.frontend.GUIHelper;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.util.DefaultPropertyResourceBundle;
import com.install4j.runtime.util.FileResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class Messages {
    private static ResourceBundle messages = null;
    private static LanguageConfig languageConfig;

    public static void setLanguageConfig(LanguageConfig languageConfig) {
        if (languageConfig == null) {
            throw new IllegalArgumentException("language config cannot be null");
        }
        Messages.languageConfig = languageConfig;
        messages = null;
        GUIHelper.setLanguage(languageConfig.getId());
    }

    public static ResourceBundle getMessages() {
        if (messages == null) {
            try {
                Messages.initMessages();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                JOptionPane.showMessageDialog(null, "Internal error: Could not open message file.", "install4j Setup", 0, null);
                System.exit(1);
            }
        }
        return messages;
    }

    private static void initMessages() throws IOException {
        File file = InstallerUtil.getInstallerFile("MessagesDefault");
        FileResourceBundle fileResourceBundle = new FileResourceBundle(file, null);
        if (languageConfig == null) {
            messages = fileResourceBundle;
        } else {
            File file2;
            File file3 = InstallerUtil.getInstallerFile(languageConfig.getMessageFile());
            messages = file3.exists() ? new FileResourceBundle(file3, fileResourceBundle) : fileResourceBundle;
            String string = languageConfig.getCustomLocalizationFile();
            if (string.trim().length() > 0 && (file2 = InstallerUtil.getInstallerFile(string)).exists()) {
                messages = string.toLowerCase().endsWith("properties") ? new DefaultPropertyResourceBundle(file2, messages) : new FileResourceBundle(file2, messages);
            }
        }
    }
}

