/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.producer;

import javax.portlet.PortletModeException;
import javax.portlet.WindowStateException;
import org.gatein.pc.api.PortletInvokerException;
import org.gatein.pc.api.invocation.response.ErrorResponse;
import org.gatein.pc.api.invocation.response.FragmentResponse;
import org.gatein.pc.api.invocation.response.HTTPRedirectionResponse;
import org.gatein.pc.api.invocation.response.PortletInvocationResponse;
import org.gatein.pc.api.invocation.response.UpdateNavigationalStateResponse;
import org.gatein.pc.portlet.state.producer.PortletStateChangeRequiredException;
import org.gatein.wsrp.WSRPExceptionFactory;
import org.gatein.wsrp.producer.ActionRequestProcessor;
import org.gatein.wsrp.producer.MarkupInterface;
import org.gatein.wsrp.producer.RenderRequestProcessor;
import org.gatein.wsrp.producer.RequestProcessor;
import org.gatein.wsrp.producer.ServiceHandler;
import org.gatein.wsrp.producer.WSRPProducerImpl;
import org.gatein.wsrp.servlet.ServletAccess;
import org.oasis.wsrp.v1.AccessDenied;
import org.oasis.wsrp.v1.BlockingInteractionResponse;
import org.oasis.wsrp.v1.GetMarkup;
import org.oasis.wsrp.v1.InconsistentParameters;
import org.oasis.wsrp.v1.InitCookie;
import org.oasis.wsrp.v1.InteractionParams;
import org.oasis.wsrp.v1.InvalidCookie;
import org.oasis.wsrp.v1.InvalidHandle;
import org.oasis.wsrp.v1.InvalidRegistration;
import org.oasis.wsrp.v1.InvalidSession;
import org.oasis.wsrp.v1.InvalidUserCategory;
import org.oasis.wsrp.v1.MarkupResponse;
import org.oasis.wsrp.v1.MissingParameters;
import org.oasis.wsrp.v1.OperationFailed;
import org.oasis.wsrp.v1.PerformBlockingInteraction;
import org.oasis.wsrp.v1.PortletStateChangeRequired;
import org.oasis.wsrp.v1.ReleaseSessions;
import org.oasis.wsrp.v1.ReturnAny;
import org.oasis.wsrp.v1.UnsupportedLocale;
import org.oasis.wsrp.v1.UnsupportedMimeType;
import org.oasis.wsrp.v1.UnsupportedMode;
import org.oasis.wsrp.v1.UnsupportedWindowState;

class MarkupHandler
extends ServiceHandler
implements MarkupInterface {
    static final String PBI = "PerformBlockingInteraction";
    static final String GET_MARKUP = "GetMarkup";

    MarkupHandler(WSRPProducerImpl producer) {
        super(producer);
    }

    public MarkupResponse getMarkup(GetMarkup getMarkup) throws UnsupportedWindowState, InvalidCookie, InvalidSession, AccessDenied, InconsistentParameters, InvalidHandle, UnsupportedLocale, UnsupportedMode, OperationFailed, MissingParameters, InvalidUserCategory, InvalidRegistration, UnsupportedMimeType {
        PortletInvocationResponse response;
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)getMarkup, (String)GET_MARKUP);
        RenderRequestProcessor requestProcessor = new RenderRequestProcessor(this.producer, getMarkup);
        String handle = ((RequestProcessor)requestProcessor).getPortletContext().getPortletHandle();
        try {
            log.debug("RenderInvocation on portlet '" + handle + "'");
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("RenderInvocation done");
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Could not render portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (MarkupResponse)((RequestProcessor)requestProcessor).processResponse(response);
    }

    public BlockingInteractionResponse performBlockingInteraction(PerformBlockingInteraction performBlockingInteraction) throws InvalidSession, UnsupportedMode, UnsupportedMimeType, OperationFailed, UnsupportedWindowState, UnsupportedLocale, AccessDenied, PortletStateChangeRequired, InvalidRegistration, MissingParameters, InvalidUserCategory, InconsistentParameters, InvalidHandle, InvalidCookie {
        PortletInvocationResponse response;
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)performBlockingInteraction, (String)PBI);
        InteractionParams interactionParams = performBlockingInteraction.getInteractionParams();
        WSRPExceptionFactory.throwMissingParametersIfValueIsMissing((Object)interactionParams, (String)"InteractionParams", (String)PBI);
        ActionRequestProcessor requestProcessor = new ActionRequestProcessor(this.producer, performBlockingInteraction, interactionParams);
        String handle = ((RequestProcessor)requestProcessor).getPortletContext().getPortletHandle();
        try {
            log.debug("ActionInvocation on portlet '" + handle + "'");
            response = this.producer.getPortletInvoker().invoke(requestProcessor.getInvocation());
            log.debug("ActionInvocation done");
        }
        catch (PortletStateChangeRequiredException e) {
            throw (PortletStateChangeRequired)WSRPExceptionFactory.throwWSException((String)"PortletStateChangeRequired", (String)e.getLocalizedMessage(), (Throwable)e);
        }
        catch (PortletInvokerException e) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Could not perform action on portlet '" + handle + "'"), (Throwable)e);
        }
        this.checkForError(response);
        return (BlockingInteractionResponse)((RequestProcessor)requestProcessor).processResponse(response);
    }

    public ReturnAny releaseSessions(ReleaseSessions releaseSessions) throws InvalidRegistration, OperationFailed, MissingParameters, AccessDenied {
        MarkupHandler.throwOperationFaultOnSessionOperation();
        return null;
    }

    public ReturnAny initCookie(InitCookie initCookie) throws AccessDenied, OperationFailed, InvalidRegistration {
        WSRPExceptionFactory.throwOperationFailedIfValueIsMissing((Object)initCookie, (String)"InitCookie");
        this.producer.getRegistrationOrFailIfInvalid(initCookie.getRegistrationContext());
        String sessionId = ServletAccess.getRequest().getSession().getId();
        log.debug("Got init cookie operation, created a session with id " + sessionId);
        return new ReturnAny();
    }

    static void throwOperationFaultOnSessionOperation() throws OperationFailed {
        throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)"JBoss Portal's Producer manages sessions completely on the server side, passing or trying to release sessionIDs is therefore an error.", null);
    }

    private void checkForError(PortletInvocationResponse response) throws UnsupportedMode, OperationFailed, UnsupportedWindowState {
        if (response instanceof ErrorResponse) {
            ErrorResponse errorResult = (ErrorResponse)response;
            Throwable cause = errorResult.getCause();
            if (cause instanceof PortletModeException) {
                throw (UnsupportedMode)WSRPExceptionFactory.throwWSException((String)"UnsupportedMode", (String)("Unsupported mode: " + ((PortletModeException)cause).getMode()), null);
            }
            if (cause instanceof WindowStateException) {
                throw (UnsupportedWindowState)WSRPExceptionFactory.throwWSException((String)"UnsupportedWindowState", (String)("Unsupported window state: " + ((WindowStateException)cause).getState()), null);
            }
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)errorResult.getMessage(), (Throwable)cause);
        }
        if (!(response instanceof HTTPRedirectionResponse || response instanceof FragmentResponse || response instanceof UpdateNavigationalStateResponse)) {
            throw (OperationFailed)WSRPExceptionFactory.throwWSException((String)"OperationFailed", (String)("Unsupported result type: " + response.getClass().getName()), null);
        }
    }
}

