/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui;

import java.io.InputStream;
import org.exoplatform.commons.utils.MimeTypeResolver;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.social.core.image.ImageUtils;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.upload.UploadResource;
import org.exoplatform.upload.UploadService;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormUploadInput;

@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/UIAvatarUploader.gtmpl", events={@EventConfig(listeners={ConfirmActionListener.class}), @EventConfig(listeners={CancelActionListener.class})})})
public class UIAvatarUploader
extends UIForm {
    private static final String MSG_IMG_NOT_UPLOADED = "UIAvatarUploader.msg.img_not_loaded";
    private static final String MSG_MIMETYPE_NOT_ACCEPTED = "UIAvatarUploader.msg.mimetype_not_accepted";
    private final String FIELD_NAME = "Name";
    private final String FIELD_UPLOADER = "Uploader";
    private final int uploadLimit = 2;
    private final String[] acceptedMimeTypes = new String[]{"image/jpeg", "image/jpg", "image/png", "image/x-png", "image/pjpeg"};
    private final UIFormUploadInput uiAvatarUploadInput;

    public UIAvatarUploader() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput("Name", null));
        this.uiAvatarUploadInput = new UIFormUploadInput("Uploader", null, 2);
        this.uiAvatarUploadInput.setAutoUpload(true);
        this.addUIFormInput((UIFormInput)this.uiAvatarUploadInput);
        this.setActions(new String[]{"Confirm", "Cancel"});
    }

    private boolean isAcceptedMimeType(String mimeType) {
        for (String acceptedMimeType : this.acceptedMimeTypes) {
            if (!mimeType.equals(acceptedMimeType)) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIAvatarUploader> {
        public void execute(Event<UIAvatarUploader> event) throws Exception {
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploader.getParent();
            uiPopup.setShow(false);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ConfirmActionListener
    extends EventListener<UIAvatarUploader> {
        private static final int WIDTH = 200;

        public void execute(Event<UIAvatarUploader> event) throws Exception {
            WebuiRequestContext ctx = event.getRequestContext();
            UIApplication uiApplication = ctx.getUIApplication();
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)((Object)event.getSource());
            UIFormUploadInput uiAvatarUploadInput = (UIFormUploadInput)uiAvatarUploader.getChild(UIFormUploadInput.class);
            UIFormStringInput uiName = (UIFormStringInput)uiAvatarUploader.getChild(UIFormStringInput.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiAvatarUploader.getParent();
            InputStream uploadedStream = uiAvatarUploadInput.getUploadDataAsStream();
            if (uploadedStream == null) {
                uiApplication.addMessage(new ApplicationMessage(UIAvatarUploader.MSG_IMG_NOT_UPLOADED, null, 0));
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiAvatarUploader);
                return;
            }
            UploadResource uploadResource = uiAvatarUploadInput.getUploadResource();
            String mimeType = uploadResource.getMimeType();
            String uploadId = uiAvatarUploadInput.getUploadId();
            if (!uiAvatarUploader.isAcceptedMimeType(mimeType)) {
                UploadService uploadService = (UploadService)PortalContainer.getComponent(UploadService.class);
                uploadService.removeUpload(uploadId);
                uiApplication.addMessage(new ApplicationMessage(UIAvatarUploader.MSG_MIMETYPE_NOT_ACCEPTED, null, 0));
                ctx.addUIComponentToUpdateByAjax((UIComponent)uiAvatarUploader);
            } else {
                MimeTypeResolver mimeTypeResolver = new MimeTypeResolver();
                String fileName = (String)uiName.getValue();
                fileName = fileName == null ? uploadResource.getFileName() : fileName + "." + mimeTypeResolver.getExtension(mimeType);
                AvatarAttachment avatarAttachment = ImageUtils.createResizedAvatarAttachment((InputStream)uploadedStream, (int)200, (int)0, null, (String)fileName, (String)mimeType, null);
                if (avatarAttachment == null) {
                    avatarAttachment = new AvatarAttachment(null, fileName, mimeType, uploadedStream, null, System.currentTimeMillis());
                }
                UploadService uploadService = (UploadService)PortalContainer.getComponent(UploadService.class);
                uploadService.removeUpload(uploadId);
                UIAvatarUploadContent uiAvatarUploadContent = (UIAvatarUploadContent)uiAvatarUploader.createUIComponent(UIAvatarUploadContent.class, null, null);
                uiAvatarUploadContent.setAvatarAttachment(avatarAttachment);
                uiPopup.setUIComponent((UIComponent)uiAvatarUploadContent);
                ctx.addUIComponentToUpdateByAjax(uiAvatarUploader.getParent());
            }
        }
    }
}

