/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.RelationshipListAccess;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(template="classpath:groovy/social/webui/connections/UIInvitations.gtmpl", events={@EventConfig(listeners={AcceptActionListener.class}), @EventConfig(listeners={DenyActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})})
public class UIInvitations
extends UIContainer {
    private final String iteratorIDInvitation = "UIPageIteratorInvitation";
    private static final String INVITATION_REVOKED_INFO = "UIInvitationRelation.label.RevokedInfo";
    private UIPageIterator uiPageIteratorInvitation = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorInvitation");
    private RelationshipManager relationshipManager;
    private IdentityManager identityManager = null;
    UIProfileUserSearch uiProfileUserSearchRelation = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIteratorInvitation() {
        return this.uiPageIteratorInvitation;
    }

    public UIInvitations() throws Exception {
        this.addChild((UIComponent)this.uiPageIteratorInvitation);
        this.uiProfileUserSearchRelation = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchRelation);
    }

    public List<Relationship> getInvitation() throws Exception {
        List<Relationship> invitationList = this.getInvitedRelations();
        List<Relationship> contactLists = this.getDisplayRelationList(invitationList, this.uiPageIteratorInvitation);
        return contactLists;
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = im.getOrCreateIdentity("organization", this.getCurrentViewerUserName());
        if (identity == null) {
            identity = im.getOrCreateIdentity("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        return currentUserName.equals(currentViewer);
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    private List<Relationship> getDisplayRelationList(List<Relationship> listContacts, UIPageIterator uiPageIterator) throws Exception {
        int curPage = uiPageIterator.getCurrentPage();
        LazyPageList pageListContact = new LazyPageList((ListAccess)new RelationshipListAccess(listContacts), 5);
        uiPageIterator.setPageList((PageList)pageListContact);
        int availablePageCount = uiPageIterator.getAvailablePage();
        if (availablePageCount >= curPage) {
            uiPageIterator.setCurrentPage(curPage);
        } else if (availablePageCount < curPage) {
            uiPageIterator.setCurrentPage(curPage - 1);
        }
        return uiPageIterator.getCurrentPageData();
    }

    private List<Relationship> getInvitedRelations() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        List<Identity> matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return relm.getPendingRelationships(currentIdentity, false);
        }
        return relm.getPendingRelationships(currentIdentity, matchIdentities, false);
    }

    private IdentityManager getIdentityManager() {
        if (this.identityManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.identityManager = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.identityManager;
    }

    private String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private String getCurrentUserName() {
        PortalRequestContext portalRequest = Util.getPortalRequestContext();
        return portalRequest.getRemoteUser();
    }

    private RelationshipManager getRelationshipManager() {
        if (this.relationshipManager == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.relationshipManager = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.relationshipManager;
    }

    private Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiMyRelation = (UIInvitations)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiMyRelation.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiMyRelation.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiMyRelation = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = uiMyRelation.getCurrentUserName();
            IdentityManager im = uiMyRelation.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(identityId);
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = uiMyRelation.getContactStatus(requestedIdentity);
            if (relationStatus == Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            RelationshipManager rm = uiMyRelation.getRelationshipManager();
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            if (rel != null) {
                rm.remove(rel);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AcceptActionListener
    extends EventListener<UIInvitations> {
        public void execute(Event<UIInvitations> event) throws Exception {
            UIInvitations uiMyRelation = (UIInvitations)((Object)event.getSource());
            String identityId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = uiMyRelation.getCurrentUserName();
            IdentityManager im = uiMyRelation.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(identityId);
            RelationshipManager rm = uiMyRelation.getRelationshipManager();
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = uiMyRelation.getContactStatus(requestedIdentity);
            if (relationStatus == Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIInvitations.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            rm.confirm(rel);
        }
    }
}

