/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.connections;

import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.manager.RelationshipManager;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.webui.RelationshipListAccess;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIProfileUserSearch;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(template="classpath:groovy/social/webui/connections/UIPendingRelation.gtmpl", events={@EventConfig(listeners={DenyContactActionListener.class}), @EventConfig(listeners={SearchActionListener.class}, phase=Event.Phase.DECODE)})
public class UIPendingRelation
extends UIContainer {
    private final String iteratorID_ = "UIPageIteratorPendingRelation";
    private static final String INVITATION_REVOKED_INFO = "UIPendingRelation.label.RevokedInfo";
    UIPageIterator uiPageIterator_ = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIPageIteratorPendingRelation");
    Identity currIdentity = null;
    RelationshipManager rm = null;
    IdentityManager im = null;
    UIProfileUserSearch uiProfileUserSearchPending = null;
    private List<Identity> identityList;

    public List<Identity> getIdentityList() {
        return this.identityList;
    }

    public void setIdentityList(List<Identity> identityList) {
        this.identityList = identityList;
    }

    public UIPageIterator getUIPageIterator() {
        return this.uiPageIterator_;
    }

    public UIPendingRelation() throws Exception {
        this.addChild((UIComponent)this.uiPageIterator_);
        this.uiProfileUserSearchPending = (UIProfileUserSearch)this.createUIComponent(UIProfileUserSearch.class, null, "UIProfileUserSearch");
        this.addChild((UIComponent)this.uiProfileUserSearchPending);
    }

    public List<Relationship> getPendingRelationList() throws Exception {
        List<Relationship> listRelationShip = this.getPendingRelationships();
        int currentPage = this.uiPageIterator_.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new RelationshipListAccess(listRelationShip), 5);
        this.uiPageIterator_.setPageList((PageList)pageList);
        int pageCount = this.uiPageIterator_.getAvailablePage();
        if (pageCount >= currentPage) {
            this.uiPageIterator_.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.uiPageIterator_.setCurrentPage(currentPage - 1);
        }
        return this.uiPageIterator_.getCurrentPageData();
    }

    public String getPortalName() {
        PortalContainer pcontainer = PortalContainer.getInstance();
        return pcontainer.getPortalContainerInfo().getContainerName();
    }

    public String getRepository() throws Exception {
        RepositoryService rService = (RepositoryService)this.getApplicationComponent(RepositoryService.class);
        return rService.getCurrentRepository().getConfiguration().getName();
    }

    public Identity getCurrentIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        return im.getOrCreateIdentity("organization", this.getCurrentUserName());
    }

    public Identity getCurrentViewerIdentity() throws Exception {
        IdentityManager im = this.getIdentityManager();
        Identity identity = im.getOrCreateIdentity("organization", this.getCurrentViewerUserName());
        if (identity == null) {
            identity = im.getOrCreateIdentity("organization", this.getCurrentUserName());
        }
        return identity;
    }

    public String getCurrentUserName() {
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public String getCurrentViewerUserName() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String currentUserName = context.getRemoteUser();
        String currentViewer = URLUtils.getCurrentUser();
        return currentUserName.equals(currentViewer);
    }

    private List<Relationship> getPendingRelationships() throws Exception {
        RelationshipManager relm = this.getRelationshipManager();
        Identity currentIdentity = this.getCurrentViewerIdentity();
        List<Identity> matchIdentities = this.getIdentityList();
        if (matchIdentities == null) {
            return relm.getPendingRelationships(currentIdentity, true);
        }
        return relm.getPendingRelationships(currentIdentity, matchIdentities, true);
    }

    private RelationshipManager getRelationshipManager() {
        if (this.rm == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.rm = (RelationshipManager)container.getComponentInstanceOfType(RelationshipManager.class);
        }
        return this.rm;
    }

    private IdentityManager getIdentityManager() {
        if (this.im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            this.im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return this.im;
    }

    private Relationship.Type getContactStatus(Identity identity) throws Exception {
        if (identity.getId().equals(this.getCurrentIdentity().getId())) {
            return Relationship.Type.SELF;
        }
        RelationshipManager rm = this.getRelationshipManager();
        Relationship rl = rm.getRelationship(identity, this.getCurrentIdentity());
        return rm.getRelationshipStatus(rl, this.getCurrentIdentity());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchActionListener
    extends EventListener<UIPendingRelation> {
        public void execute(Event<UIPendingRelation> event) throws Exception {
            UIPendingRelation uiPending = (UIPendingRelation)((Object)event.getSource());
            UIProfileUserSearch uiProfileUserSearch = (UIProfileUserSearch)uiPending.getChild(UIProfileUserSearch.class);
            List<Identity> identityList = uiProfileUserSearch.getIdentityList();
            uiPending.setIdentityList(identityList);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DenyContactActionListener
    extends EventListener<UIPendingRelation> {
        public void execute(Event<UIPendingRelation> event) throws Exception {
            UIPendingRelation portlet = (UIPendingRelation)((Object)event.getSource());
            String userId = event.getRequestContext().getRequestParameter("objectId");
            String currUserId = portlet.getCurrentUserName();
            IdentityManager im = portlet.getIdentityManager();
            Identity currIdentity = im.getOrCreateIdentity("organization", currUserId);
            Identity requestedIdentity = im.getIdentity(userId);
            UIApplication uiApplication = event.getRequestContext().getUIApplication();
            Relationship.Type relationStatus = portlet.getContactStatus(requestedIdentity);
            if (relationStatus == Relationship.Type.ALIEN) {
                uiApplication.addMessage(new ApplicationMessage(UIPendingRelation.INVITATION_REVOKED_INFO, null, 2));
                return;
            }
            RelationshipManager rm = portlet.getRelationshipManager();
            Relationship rel = rm.getRelationship(currIdentity, requestedIdentity);
            if (rel != null) {
                rm.remove(rel);
            }
        }
    }
}

