/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.webui.profile.UIProfileSection;
import org.exoplatform.social.webui.profile.UITitleBar;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.core.model.SelectItemOption;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormSelectBox;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.form.validator.StringLengthValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/profile/UIContactSection.gtmpl", events={@EventConfig(listeners={EditActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SaveActionListener.class}), @EventConfig(listeners={UIProfileSection.CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}), @EventConfig(listeners={RemoveActionListener.class}, phase=Event.Phase.DECODE)})
public class UIContactSection
extends UIProfileSection {
    public static final String GENDER_CHILD = "gender";
    public static final String PHONE = "1phone";
    public static final String IM = "2im";
    public static final String URL = "3url";
    public static final String VALUE_GENDER_MALE = "male";
    public static final String VALUE_GENDER_FEMALE = "female";
    public static final String[] PHONE_TYPES = new String[]{"Work", "Home", "Other"};
    public static final String[] IM_TYPES = new String[]{"Gtalk", "Msn", "Skype", "Yahoo", "Other"};
    public static final String WEBSITE_TITLE = "Website Title";
    public static final String URL_EXAMPLE = "http://";
    public static final String KEY = "key";
    public static final String VALUE = "value";
    public static final String PHONE_REGEX_EXPRESSION = "^[\\d\\s ().+-]+$";
    public static final String INVALID_PHONE = "UIContactSect.msg.Invalid-phone";
    public static final String URL_REGEX_EXPRESSION = "^(http|https|ftp)\\:\\/\\/[a-z0-9\\-\\.]+\\.[a-z]{2,3}(:[a-z0-9]*)?\\/?([a-z0-9\\-\\._\\?\\,\\'\\/\\\\+&amp;%\\$#\\=~])*$";
    public static final String INVALID_URL = "UIContactSect.msg.Invalid-url";
    private int phoneCount = 0;
    private int imCount = 0;
    private int urlCount = 0;

    public final int getPhoneCount() {
        return this.phoneCount;
    }

    public final int getImsCount() {
        return this.imCount;
    }

    public final int getUrlCount() {
        return this.urlCount;
    }

    public UIContactSection() throws Exception {
        this.addChild(UITitleBar.class, null, null);
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        options.add(new SelectItemOption((Object)VALUE_GENDER_MALE));
        options.add(new SelectItemOption((Object)VALUE_GENDER_FEMALE));
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(GENDER_CHILD, GENDER_CHILD, options));
    }

    public final List<UIComponent> getChilds() {
        List listChild = this.getChildren();
        return this.sort(listChild);
    }

    public final List<UIComponent> getPhoneChilds() {
        return this.sortSubList(this.getSubList(0, this.phoneCount));
    }

    public final List<UIComponent> getImsChilds() {
        return this.sortSubList(this.getSubList(this.phoneCount, this.phoneCount + this.imCount));
    }

    public final List<UIComponent> getUrlChilds() {
        return this.sortSubList(this.getSubList(this.phoneCount + this.imCount, this.phoneCount + this.imCount + this.urlCount));
    }

    public final UIFormInput<String> getGenderChild() {
        return (UIFormInput)this.getChildById(GENDER_CHILD);
    }

    private void saveProfileInfo() throws Exception {
        IdentityManager im = (IdentityManager)ExoContainerContext.getCurrentContainer().getComponentInstanceOfType(IdentityManager.class);
        Profile p = this.getProfile(true);
        Profile toBeUpdatedProfile = new Profile(p.getIdentity());
        toBeUpdatedProfile.setId(p.getId());
        toBeUpdatedProfile.setProperty(GENDER_CHILD, this.getGenderChild().getValue());
        toBeUpdatedProfile.setProperty("phones", this.getProfileForSave(this.phoneCount, this.getPhoneChilds(), PHONE));
        toBeUpdatedProfile.setProperty("ims", this.getProfileForSave(this.imCount, this.getImsChilds(), IM));
        toBeUpdatedProfile.setProperty("urls", this.getProfileForSave(this.urlCount, this.getUrlChilds(), URL));
        im.updateBasicInfo(toBeUpdatedProfile);
    }

    private ArrayList<HashMap<String, String>> getProfileForSave(int count, List<UIComponent> listUIComp, String uiStringType) {
        ArrayList<HashMap<String, String>> profileMap = new ArrayList<HashMap<String, String>>();
        for (int i = 0; i < count; i += 2) {
            HashMap<String, String> uiMap = new HashMap<String, String>();
            String value = null;
            String key = null;
            if (uiStringType.equals(URL)) {
                UIFormStringInput uiStringInput = (UIFormStringInput)listUIComp.get(i + 1);
                key = (String)uiStringInput.getValue();
                value = (String)uiStringInput.getValue();
            } else {
                key = (String)((UIFormSelectBox)listUIComp.get(i)).getValue();
                value = (String)((UIFormStringInput)listUIComp.get(i + 1)).getValue();
            }
            uiMap.put(KEY, key);
            uiMap.put(VALUE, value);
            profileMap.add(uiMap);
        }
        return profileMap;
    }

    private List<UIComponent> getSubList(int startIdx, int endIdx) {
        ArrayList<UIComponent> rtnList = new ArrayList<UIComponent>();
        for (int idx = startIdx; idx < endIdx; ++idx) {
            rtnList.add(this.getChilds().get(idx));
        }
        return rtnList;
    }

    private void setValue() throws Exception {
        Profile profile = this.getProfile(false);
        String gender = (String)profile.getProperty(GENDER_CHILD);
        if (gender != "") {
            this.getGenderChild().setValue((Object)gender);
        }
        this.setValueByType(profile, this.getPhoneChilds(), "phones");
        this.setValueByType(profile, this.getImsChilds(), "ims");
        this.setValueByType(profile, this.getUrlChilds(), "urls");
    }

    private void setValueByType(Profile profile, List<UIComponent> listChilds, String uiType) throws Exception {
        block13: {
            int index;
            List profiles;
            block14: {
                block12: {
                    int newProfileSize;
                    if (profile == null || listChilds == null || uiType == null || uiType.equals("")) {
                        return;
                    }
                    profiles = (List)profile.getProperty(uiType);
                    int numberOfUI = listChilds.size();
                    int n = newProfileSize = profiles == null ? 0 : profiles.size();
                    while (numberOfUI / 2 > newProfileSize) {
                        String id1 = listChilds.get(--numberOfUI).getName();
                        String id2 = listChilds.get(--numberOfUI).getName();
                        this.removeFormInput(id1, id2);
                    }
                    if (newProfileSize == 0) {
                        return;
                    }
                    while (newProfileSize > numberOfUI / 2) {
                        if ("ims".equals(uiType)) {
                            this.addUIFormInput(IM);
                        } else if ("phones".equals(uiType)) {
                            this.addUIFormInput(PHONE);
                        } else if ("urls".equals(uiType)) {
                            this.addUIFormInput(URL);
                        }
                        numberOfUI += 2;
                    }
                    index = 0;
                    if (!"ims".equals(uiType)) break block12;
                    for (Map map : profiles) {
                        ((UIFormInput)this.getImsChilds().get(index++)).setValue(map.get(KEY));
                        ((UIFormInput)this.getImsChilds().get(index++)).setValue(map.get(VALUE));
                    }
                    break block13;
                }
                if (!"urls".equals(uiType)) break block14;
                for (Map map : profiles) {
                    ((UIFormInput)this.getUrlChilds().get(index++)).setValue(map.get(KEY));
                    ((UIFormInput)this.getUrlChilds().get(index++)).setValue(map.get(VALUE));
                }
                break block13;
            }
            if (!"phones".equals(uiType)) break block13;
            for (Map map : profiles) {
                ((UIFormInput)this.getPhoneChilds().get(index++)).setValue(map.get(KEY));
                ((UIFormInput)this.getPhoneChilds().get(index++)).setValue(map.get(VALUE));
            }
        }
    }

    private void removeFormInput(String id1, String id2) {
        this.removeChildById(id1);
        this.removeChildById(id2);
        if (id1.startsWith(IM)) {
            this.imCount -= 2;
        } else if (id1.startsWith(URL)) {
            this.urlCount -= 2;
        } else if (id1.startsWith(PHONE)) {
            this.phoneCount -= 2;
        }
    }

    private void addUIFormInput(String type) throws Exception {
        if (PHONE.equals(type)) {
            int phoneIdx = this.phoneCount;
            this.createUISelectBox(PHONE_TYPES, PHONE + StringUtils.leftPad((String)String.valueOf(phoneIdx++), (int)3, (char)'0'));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(PHONE + StringUtils.leftPad((String)String.valueOf(phoneIdx++), (int)3, (char)'0'), null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 20}).addValidator(ExpressionValidator.class, new Object[]{PHONE_REGEX_EXPRESSION, INVALID_PHONE}));
            this.phoneCount += 2;
        } else if (IM.equals(type)) {
            int imIdx = this.imCount;
            this.createUISelectBox(IM_TYPES, IM + StringUtils.leftPad((String)String.valueOf(imIdx++), (int)3, (char)'0'));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(IM + StringUtils.leftPad((String)String.valueOf(imIdx++), (int)3, (char)'0'), null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(StringLengthValidator.class, new Object[]{3, 60}));
            this.imCount += 2;
        } else if (URL.equals(type)) {
            int urlIdx = this.urlCount;
            this.addUIFormInput((UIFormInput)new UIFormStringInput(URL + StringUtils.leftPad((String)String.valueOf(urlIdx++), (int)3, (char)'0'), null, WEBSITE_TITLE));
            this.addUIFormInput((UIFormInput)new UIFormStringInput(URL + StringUtils.leftPad((String)String.valueOf(urlIdx++), (int)3, (char)'0'), null, URL_EXAMPLE).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{URL_REGEX_EXPRESSION, INVALID_URL}));
            this.urlCount += 2;
        }
    }

    private void createUISelectBox(String[] values, String uiName) {
        ArrayList<SelectItemOption> options = new ArrayList<SelectItemOption>();
        for (String value : values) {
            options.add(new SelectItemOption((Object)value));
        }
        this.addUIFormInput((UIFormInput)new UIFormSelectBox(uiName, null, options));
    }

    private List<UIComponent> sort(List<UIComponent> lstComps) {
        Collections.sort(lstComps, new UiComponentComparator());
        return lstComps;
    }

    private List<UIComponent> sortSubList(List<UIComponent> lstComps) {
        Collections.sort(lstComps, new UiComponentComparator());
        return lstComps;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UiComponentComparator
    implements Comparator<UIComponent> {
        private UiComponentComparator() {
        }

        @Override
        public int compare(UIComponent uicomp1, UIComponent uicomp2) {
            return uicomp1.getId().compareToIgnoreCase(uicomp2.getId());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditActionListener
    extends UIProfileSection.EditActionListener {
        @Override
        public final void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIContactSection uiContactSectionSect = (UIContactSection)sect;
            uiContactSectionSect.setValue();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)sect);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveActionListener
    extends EventListener<UIContactSection> {
        public final void execute(Event<UIContactSection> event) throws Exception {
            UIContactSection sect = (UIContactSection)((Object)event.getSource());
            String comps = event.getRequestContext().getRequestParameter("objectId");
            String uiComp1 = comps.substring(0, comps.indexOf("."));
            String uiComp2 = comps.substring(comps.indexOf(".") + 1, comps.length());
            sect.removeFormInput(uiComp1, uiComp2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIContactSection> {
        public final void execute(Event<UIContactSection> event) throws Exception {
            UIContactSection sect = (UIContactSection)((Object)event.getSource());
            String typeOfComp = event.getRequestContext().getRequestParameter("objectId");
            sect.addUIFormInput(typeOfComp);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SaveActionListener
    extends UIProfileSection.SaveActionListener {
        @Override
        public final void execute(Event<UIProfileSection> event) throws Exception {
            super.execute(event);
            UIProfileSection sect = (UIProfileSection)((Object)event.getSource());
            UIContactSection uiContactSectionSect = (UIContactSection)sect;
            uiContactSectionSect.saveProfileInfo();
        }
    }
}

