/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.profile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.model.AvatarAttachment;
import org.exoplatform.social.webui.UIAvatarUploadContent;
import org.exoplatform.social.webui.UIAvatarUploader;
import org.exoplatform.social.webui.URLUtils;
import org.exoplatform.social.webui.profile.UIBasicInfoSection;
import org.exoplatform.social.webui.profile.UIContactSection;
import org.exoplatform.social.webui.profile.UIExperienceSection;
import org.exoplatform.social.webui.profile.UIHeaderSection;
import org.exoplatform.web.application.RequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIContainer;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIApplicationLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIApplicationLifecycle.class, template="classpath:groovy/social/webui/profile/UIProfile.gtmpl", events={@EventConfig(listeners={ChangeAvatarActionListener.class})})
public class UIProfile
extends UIContainer {
    private final String POPUP_AVATAR_UPLOADER = "UIPopupAvatarUploader";
    private Profile profile;
    private static IdentityManager im;

    public UIProfile() throws Exception {
        List sections = this.getSections();
        for (Class sect : sections) {
            this.addChild(sect, null, null);
        }
        UIPopupWindow uiPopup = (UIPopupWindow)this.createUIComponent(UIPopupWindow.class, null, "UIPopupAvatarUploader");
        uiPopup.setWindowSize(500, 0);
        this.addChild((UIComponent)uiPopup);
    }

    public String getCurrentUriObj() {
        String portalUrl;
        PortalRequestContext pcontext = Util.getPortalRequestContext();
        String requestUrl = pcontext.getRequestURI();
        String uriObj = requestUrl.replace(portalUrl = pcontext.getPortalURI(), "");
        if (uriObj.contains("/")) {
            uriObj = uriObj.split("/")[0] + "/" + uriObj.split("/")[1];
        }
        return uriObj;
    }

    public Profile getProfile(boolean forceReload) throws Exception {
        if (forceReload || this.profile == null) {
            Identity id = this.getIdentity();
            this.profile = id.getProfile();
        }
        return this.profile;
    }

    public boolean isEditable() {
        RequestContext context = RequestContext.getCurrentInstance();
        String rUser = context.getRemoteUser();
        if (rUser == null) {
            return false;
        }
        return this.getCurrentProfileID().equals(rUser);
    }

    public String getImageSource() throws Exception {
        return this.getProfile(true).getAvatarImageSource();
    }

    public void saveAvatar(UIAvatarUploadContent uiAvatarUploadContent) throws Exception {
        AvatarAttachment attacthment = uiAvatarUploadContent.getAvatarAttachment();
        if (im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        Profile p = this.getProfile(true);
        p.setProperty("avatar", (Object)attacthment);
        Map props = p.getProperties();
        Iterator it = props.keySet().iterator();
        it = props.keySet().iterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            if (!name.startsWith("avatar_")) continue;
            it.remove();
            p.removeProperty(name);
        }
        im.updateAvatar(p);
    }

    private String getCurrentProfileID() {
        String username = URLUtils.getCurrentUser();
        if (username != null) {
            return username;
        }
        RequestContext context = RequestContext.getCurrentInstance();
        return context.getRemoteUser();
    }

    private Identity getIdentity() throws Exception {
        if (im == null) {
            ExoContainer container = ExoContainerContext.getCurrentContainer();
            im = (IdentityManager)container.getComponentInstanceOfType(IdentityManager.class);
        }
        return im.getOrCreateIdentity("organization", this.getCurrentProfileID());
    }

    private List getSections() {
        ArrayList<Class> sects = new ArrayList<Class>();
        sects.add(UIHeaderSection.class);
        sects.add(UIBasicInfoSection.class);
        sects.add(UIContactSection.class);
        sects.add(UIExperienceSection.class);
        return sects;
    }

    public void setProfile(Profile profile) {
        this.profile = profile;
    }

    public Profile getProfile() {
        return this.profile;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeAvatarActionListener
    extends EventListener<UIProfile> {
        public void execute(Event<UIProfile> event) throws Exception {
            UIProfile uiProfile = (UIProfile)((Object)event.getSource());
            UIPopupWindow uiPopup = (UIPopupWindow)uiProfile.getChild(UIPopupWindow.class);
            UIAvatarUploader uiAvatarUploader = (UIAvatarUploader)uiProfile.createUIComponent(UIAvatarUploader.class, null, null);
            uiPopup.setUIComponent((UIComponent)uiAvatarUploader);
            uiPopup.setShow(true);
        }
    }
}

