/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.webui.space;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.LazyPageList;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PageList;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.Query;
import org.exoplatform.services.organization.User;
import org.exoplatform.social.core.space.SpaceException;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.webui.StringListAccess;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.ComponentConfigs;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPageIterator;
import org.exoplatform.webui.core.UIPopupWindow;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInput;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.validator.ExpressionValidator;
import org.exoplatform.webui.form.validator.MandatoryValidator;
import org.exoplatform.webui.organization.account.UIUserSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfigs(value={@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/social/webui/space/UISpaceMember.gtmpl", events={@EventConfig(listeners={InviteActionListener.class}), @EventConfig(listeners={SearchUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RevokeInvitedUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={DeclineUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ValidateUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveUserActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemoveLeaderActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={MakeLeaderActionListener.class}, phase=Event.Phase.DECODE)}), @ComponentConfig(type=UIPopupWindow.class, id="SearchUser", template="system:/groovy/webui/core/UIPopupWindow.gtmpl", events={@EventConfig(listeners={UIPopupWindow.CloseActionListener.class}, name="ClosePopup"), @EventConfig(listeners={CloseActionListener.class}, name="Close", phase=Event.Phase.DECODE), @EventConfig(listeners={AddActionListener.class}, name="Add", phase=Event.Phase.DECODE)})})
public class UISpaceMember
extends UIForm {
    private static final String MSG_ERROR_REMOVE_MEMBER = "UISpaceMember.msg.error_remove_member";
    private static final String MSG_ERROR_REMOVE_LEADER = "UISpaceMember.msg.error_remove_leader";
    private static final String MSG_ERROR_SELF_REMOVE_LEADER = "UISpaceMember.msg.error_self_remove_leader";
    private static final String MSG_ERROR_REVOKE_INVITED = "UISpaceMember.msg.error_revoke_invited";
    private static final String MSG_ERROR_DECLINE_USER = "UISpaceMember.msg.error_decline_user";
    private static final String MSG_ERROR_VALIDATE_USER = "UISpaceMember.msg.error_validate_user";
    private static final String MSG_ERROR_MAKE_LEADER = "UISpaceMember.msg.error_make_leader";
    private String spaceId;
    private SpaceService spaceService = null;
    private static final String USER = "user";
    private UIPageIterator iteratorPendingUsers;
    private UIPageIterator iteratorInvitedUsers;
    private UIPageIterator iteratorExistingUsers;
    private final String iteratorPendingID = "UIIteratorPendding";
    private final String iteratorInvitedID = "UIIteratorInvited";
    private final String iteratorExistingID = "UIIteratorExisting";
    private final Integer ITEMS_PER_PAGE = 5;

    public UISpaceMember() throws Exception {
        this.addUIFormInput((UIFormInput)new UIFormStringInput(USER, null, null).addValidator(MandatoryValidator.class, new Object[0]).addValidator(ExpressionValidator.class, new Object[]{"^\\p{L}[\\p{L}\\d\\s._,]+$", "UISpaceMember.msg.Invalid-char"}));
        UIPopupWindow searchUserPopup = (UIPopupWindow)this.addChild(UIPopupWindow.class, "SearchUser", "SearchUser");
        searchUserPopup.setWindowSize(640, 0);
        this.iteratorPendingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorPendding");
        this.iteratorInvitedUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorInvited");
        this.iteratorExistingUsers = (UIPageIterator)this.createUIComponent(UIPageIterator.class, null, "UIIteratorExisting");
        this.addChild((UIComponent)this.iteratorPendingUsers);
        this.addChild((UIComponent)this.iteratorInvitedUsers);
        this.addChild((UIComponent)this.iteratorExistingUsers);
    }

    public UIPageIterator getUIPageIteratorPendingUsers() {
        return this.iteratorPendingUsers;
    }

    public UIPageIterator getUIPageIteratorInvitedUsers() {
        return this.iteratorInvitedUsers;
    }

    public UIPageIterator getUIPageIteratorExistingUsers() {
        return this.iteratorExistingUsers;
    }

    public void setValue(String spaceId) throws Exception {
        this.spaceId = spaceId;
    }

    public List<String> getAllUserNames() throws Exception {
        String[] invitedUsers;
        OrganizationService organizationService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        List allUsers = organizationService.getUserHandler().findUsers(new Query()).getAll();
        ArrayList<String> allUserNames = new ArrayList<String>();
        ArrayList<String> pendingUsersList = new ArrayList<String>();
        ArrayList<String> invitedUsersList = new ArrayList<String>();
        List membersList = new ArrayList();
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers != null) {
            pendingUsersList.addAll(Arrays.asList(pendingUsers));
        }
        if ((invitedUsers = space.getInvitedUsers()) != null) {
            invitedUsersList.addAll(Arrays.asList(invitedUsers));
        }
        membersList = spaceService.getMembers(space);
        for (User user : allUsers) {
            String userName = user.getUserName();
            if (pendingUsersList.contains(userName) || invitedUsersList.contains(userName) || membersList.contains(userName)) continue;
            allUserNames.add(userName);
        }
        return allUserNames;
    }

    public List<String> getPendingUsers() throws Exception {
        ArrayList<String> pendingUsersList = new ArrayList<String>();
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] pendingUsers = space.getPendingUsers();
        if (pendingUsers != null) {
            pendingUsersList.addAll(Arrays.asList(pendingUsers));
        }
        int currentPage = this.iteratorPendingUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(pendingUsersList), this.ITEMS_PER_PAGE.intValue());
        this.iteratorPendingUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorPendingUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorPendingUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorPendingUsers.getCurrentPageData();
    }

    public List<String> getInvitedUsers() throws Exception {
        ArrayList<String> invitedUsersList = new ArrayList<String>();
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        String[] invitedUsers = space.getInvitedUsers();
        if (invitedUsers != null) {
            invitedUsersList.addAll(Arrays.asList(invitedUsers));
        }
        int currentPage = this.iteratorInvitedUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(invitedUsersList), this.ITEMS_PER_PAGE.intValue());
        this.iteratorInvitedUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorInvitedUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorInvitedUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorInvitedUsers.getCurrentPageData();
    }

    public List<String> getExistingUsers() throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        if (space == null) {
            return new ArrayList<String>(0);
        }
        int currentPage = this.iteratorExistingUsers.getCurrentPage();
        LazyPageList pageList = new LazyPageList((ListAccess)new StringListAccess(spaceService.getMembers(space)), this.ITEMS_PER_PAGE.intValue());
        this.iteratorExistingUsers.setPageList((PageList)pageList);
        int pageCount = this.iteratorExistingUsers.getAvailablePage();
        if (pageCount >= currentPage) {
            this.iteratorExistingUsers.setCurrentPage(currentPage);
        } else if (pageCount < currentPage) {
            this.iteratorExistingUsers.setCurrentPage(currentPage - 1);
        }
        return this.iteratorExistingUsers.getCurrentPageData();
    }

    public void setUsersName(String userName) {
        this.getUIStringInput(USER).setValue((Object)userName);
    }

    public String getUsersName() {
        return (String)this.getUIStringInput(USER).getValue();
    }

    public boolean isSuperUser() throws Exception {
        return this.getRemoteUser().equals(this.getUserACL().getSuperUser());
    }

    public String getHomeSpaceUrl() throws Exception {
        Space space = this.getSpaceService().getSpaceById(this.spaceId);
        return Util.getPortalRequestContext().getPortalURI() + space.getUrl();
    }

    public String getManageSpacesUrl() throws Exception {
        return Util.getPortalRequestContext().getPortalURI() + "spaces";
    }

    public boolean isLeader(String userName) throws Exception {
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        return spaceService.isLeader(space, userName);
    }

    public boolean isCurrentUser(String userName) throws Exception {
        return this.getRemoteUser().equals(userName);
    }

    private void validateInvitedUser() throws Exception {
        WebuiRequestContext requestContext = (WebuiRequestContext)WebuiRequestContext.getCurrentInstance();
        UIApplication uiApp = requestContext.getUIApplication();
        String[] invitedUserList = this.getUsersName().split(",");
        String usersNotExist = null;
        String usersIsInvited = null;
        String usersIsMember = null;
        String newMemberForInvite = null;
        SpaceService spaceService = this.getSpaceService();
        Space space = spaceService.getSpaceById(this.spaceId);
        String invitedUser = null;
        for (String userStr : invitedUserList) {
            invitedUser = userStr.trim();
            if (invitedUser.length() == 0) continue;
            try {
                if (invitedUser.equals(this.getUserACL().getSuperUser())) {
                    if (spaceService.isMember(space, invitedUser)) {
                        throw new SpaceException(SpaceException.Code.USER_ALREADY_MEMBER);
                    }
                    spaceService.addMember(space, invitedUser);
                    continue;
                }
                this.checkInvitedUser(space, invitedUser);
                if (newMemberForInvite == null) {
                    newMemberForInvite = invitedUser;
                    continue;
                }
                newMemberForInvite = newMemberForInvite + ", " + invitedUser;
            }
            catch (SpaceException e) {
                if (e.getCode() == SpaceException.Code.USER_NOT_EXIST) {
                    if (usersNotExist == null) {
                        usersNotExist = invitedUser;
                        continue;
                    }
                    usersNotExist = usersNotExist + "," + invitedUser;
                    continue;
                }
                if (e.getCode() == SpaceException.Code.USER_ALREADY_INVITED) {
                    if (usersIsInvited == null) {
                        usersIsInvited = invitedUser;
                        continue;
                    }
                    usersIsInvited = usersIsInvited + "," + invitedUser;
                    continue;
                }
                if (e.getCode() != SpaceException.Code.USER_ALREADY_MEMBER) continue;
                usersIsMember = usersIsMember == null ? invitedUser : usersIsMember + "," + invitedUser;
            }
        }
        this.setUsersName(newMemberForInvite);
        String remainUsers = null;
        if (usersNotExist != null) {
            remainUsers = usersNotExist;
            uiApp.addMessage(new ApplicationMessage("UISpaceMember.msg.user-not-exist", (Object[])new String[]{usersNotExist}, 1));
        }
        if (usersIsInvited != null) {
            remainUsers = remainUsers == null ? usersIsInvited : remainUsers + "," + usersIsInvited;
            uiApp.addMessage(new ApplicationMessage("UISpaceMember.msg.user-is-invited", (Object[])new String[]{usersIsInvited}, 1));
        }
        if (usersIsMember != null) {
            remainUsers = remainUsers == null ? usersIsMember : remainUsers + "," + usersIsMember;
            uiApp.addMessage(new ApplicationMessage("UISpaceMember.msg.user-is-member", (Object[])new String[]{usersIsMember}, 1));
        }
    }

    private void checkInvitedUser(Space space, String userId) throws Exception {
        OrganizationService orgService = (OrganizationService)this.getApplicationComponent(OrganizationService.class);
        SpaceService spaceService = this.getSpaceService();
        try {
            User user = orgService.getUserHandler().findUserByName(userId);
            if (user == null) {
                throw new SpaceException(SpaceException.Code.USER_NOT_EXIST);
            }
        }
        catch (Exception e) {
            if (e instanceof SpaceException) {
                throw (SpaceException)((Object)e);
            }
            throw new SpaceException(SpaceException.Code.ERROR_RETRIEVING_USER, (Throwable)e);
        }
        if (spaceService.isInvited(space, userId)) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_INVITED);
        }
        if (spaceService.isMember(space, userId) && !userId.equals(this.getUserACL().getSuperUser())) {
            throw new SpaceException(SpaceException.Code.USER_ALREADY_MEMBER);
        }
    }

    private SpaceService getSpaceService() {
        if (this.spaceService == null) {
            this.spaceService = (SpaceService)this.getApplicationComponent(SpaceService.class);
        }
        return this.spaceService;
    }

    private UserACL getUserACL() throws Exception {
        return (UserACL)this.getApplicationComponent(UserACL.class);
    }

    private String getRemoteUser() throws Exception {
        return Util.getPortalRequestContext().getRemoteUser();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CloseActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddActionListener
    extends EventListener<UIUserSelector> {
        public void execute(Event<UIUserSelector> event) throws Exception {
            UIUserSelector uiForm = (UIUserSelector)event.getSource();
            UISpaceMember uiSpaceMember = (UISpaceMember)uiForm.getAncestorOfType(UISpaceMember.class);
            String userNamesSelected = uiForm.getSelectedUsers();
            String userNamesInputted = uiSpaceMember.getUsersName();
            String userNameForInvite = null;
            userNameForInvite = userNamesInputted == null || userNamesInputted.length() == 0 ? userNamesSelected : userNamesInputted.trim() + ", " + userNamesSelected;
            uiSpaceMember.setUsersName(userNameForInvite);
            UIPopupWindow uiPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            uiPopup.setUIComponent(null);
            uiPopup.setShow(false);
            uiSpaceMember.validateInvitedUser();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MakeLeaderActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            try {
                spaceService.setLeader(space, userName, true);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_MAKE_LEADER, null, 1));
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveLeaderActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            PortalRequestContext prContext = Util.getPortalRequestContext();
            String currentUser = requestContext.getRemoteUser();
            boolean useAjax = prContext.useAjax();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            if (!useAjax) {
                userName = currentUser;
            }
            if (spaceService.isOnlyLeader(space, userName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, null, 1));
                return;
            }
            try {
                spaceService.setLeader(space, userName, false);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_REMOVE_LEADER, null, 1));
            }
            if (!useAjax) {
                prContext = Util.getPortalRequestContext();
                prContext.setResponseComplete(true);
                StringBuffer url = new StringBuffer(Util.getPortalRequestContext().getPortalURI());
                if (uiSpaceMember.isSuperUser()) {
                    url.append(space.getUrl()).append("/SpaceSettingPortlet");
                } else {
                    url.append(space.getUrl());
                }
                prContext.getResponse().sendRedirect(url.toString());
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ValidateUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            try {
                spaceService.validateRequest(uiSpaceMember.spaceId, userName);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_VALIDATE_USER, null, 1));
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemoveUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            PortalRequestContext prContext = Util.getPortalRequestContext();
            boolean useAjax = prContext.useAjax();
            UIApplication uiApp = requestContext.getUIApplication();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            String currentUser = requestContext.getRemoteUser();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            if (!useAjax) {
                userName = currentUser;
            }
            if (spaceService.isOnlyLeader(space, userName)) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_SELF_REMOVE_LEADER, null, 1));
                return;
            }
            try {
                spaceService.removeMember(space, userName);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_REMOVE_MEMBER, null, 1));
                return;
            }
            if (!useAjax) {
                prContext = Util.getPortalRequestContext();
                prContext.setResponseComplete(true);
                StringBuffer url = new StringBuffer(Util.getPortalRequestContext().getPortalURI());
                if (uiSpaceMember.isSuperUser()) {
                    url.append(space.getUrl()).append("/SpaceSettingPortlet");
                } else {
                    url.append("spaces");
                }
                prContext.getResponse().sendRedirect(url.toString());
                return;
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DeclineUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            try {
                spaceService.declineRequest(uiSpaceMember.spaceId, userName);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_DECLINE_USER, null, 1));
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RevokeInvitedUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            String userName = event.getRequestContext().getRequestParameter("objectId");
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            try {
                spaceService.revokeInvitation(uiSpaceMember.spaceId, userName);
            }
            catch (SpaceException se) {
                uiApp.addMessage(new ApplicationMessage(UISpaceMember.MSG_ERROR_REVOKE_INVITED, null, 1));
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SearchUserActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            UIPopupWindow searchUserPopup = (UIPopupWindow)uiSpaceMember.getChild(UIPopupWindow.class);
            UIUserSelector userSelector = (UIUserSelector)uiSpaceMember.createUIComponent(UIUserSelector.class, null, null);
            userSelector.setShowSearchGroup(false);
            searchUserPopup.setUIComponent((UIComponent)userSelector);
            searchUserPopup.setShow(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class InviteActionListener
    extends EventListener<UISpaceMember> {
        public void execute(Event<UISpaceMember> event) throws Exception {
            UISpaceMember uiSpaceMember = (UISpaceMember)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            UIApplication uiApp = requestContext.getUIApplication();
            SpaceService spaceService = uiSpaceMember.getSpaceService();
            uiSpaceMember.validateInvitedUser();
            Space space = spaceService.getSpaceById(uiSpaceMember.spaceId);
            String usersInput = uiSpaceMember.getUsersName();
            String[] invitedUsers = null;
            String name = null;
            if (usersInput != null) {
                invitedUsers = uiSpaceMember.getUsersName().split(",");
                ArrayList<String> usersForInviting = new ArrayList<String>();
                if (invitedUsers != null) {
                    for (int idx = 0; idx < invitedUsers.length; ++idx) {
                        name = invitedUsers[idx].trim();
                        if (name.length() <= 0 || usersForInviting.contains(name)) continue;
                        usersForInviting.add(name);
                    }
                }
                for (String userName : usersForInviting) {
                    spaceService.inviteMember(space, userName);
                }
                uiSpaceMember.setUsersName(null);
            }
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiSpaceMember);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
        }
    }
}

