/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.xmpp.connection.impl;

import java.io.File;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.jcr.RepositoryException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.ext.common.SessionProvider;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.uistate.UIStateSession;
import org.exoplatform.services.uistate.bean.UIStateDataBean;
import org.exoplatform.services.xmpp.bean.ChangeNickBean;
import org.exoplatform.services.xmpp.bean.ConfigRoomBean;
import org.exoplatform.services.xmpp.bean.ContactBean;
import org.exoplatform.services.xmpp.bean.DeclineBean;
import org.exoplatform.services.xmpp.bean.EventsBean;
import org.exoplatform.services.xmpp.bean.FileTransferEventBean;
import org.exoplatform.services.xmpp.bean.FileTransferRequestBean;
import org.exoplatform.services.xmpp.bean.FileTransferResponseBean;
import org.exoplatform.services.xmpp.bean.FormBean;
import org.exoplatform.services.xmpp.bean.FullRoomInfoBean;
import org.exoplatform.services.xmpp.bean.HostedRoomBean;
import org.exoplatform.services.xmpp.bean.InitInfoBean;
import org.exoplatform.services.xmpp.bean.InviteBean;
import org.exoplatform.services.xmpp.bean.KickedBannedBean;
import org.exoplatform.services.xmpp.bean.MUCPacketBean;
import org.exoplatform.services.xmpp.bean.MessageBean;
import org.exoplatform.services.xmpp.bean.OccupantBean;
import org.exoplatform.services.xmpp.bean.PresenceBean;
import org.exoplatform.services.xmpp.bean.PrivilegeChangeBean;
import org.exoplatform.services.xmpp.bean.SubjectChangeBean;
import org.exoplatform.services.xmpp.connection.XMPPSession;
import org.exoplatform.services.xmpp.connection.impl.XMPPMessenger;
import org.exoplatform.services.xmpp.ext.transport.Transport;
import org.exoplatform.services.xmpp.filter.ErrorMessageFilter;
import org.exoplatform.services.xmpp.filter.MessageFilter;
import org.exoplatform.services.xmpp.filter.SubscriptionFilter;
import org.exoplatform.services.xmpp.groupchat.MultiUserChatManager;
import org.exoplatform.services.xmpp.history.HistoricalMessage;
import org.exoplatform.services.xmpp.history.Interlocutor;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoricalMessageImpl;
import org.exoplatform.services.xmpp.history.impl.jcr.HistoryImpl;
import org.exoplatform.services.xmpp.userinfo.UserInfo;
import org.exoplatform.services.xmpp.userinfo.UserInfoService;
import org.exoplatform.services.xmpp.util.CodingUtils;
import org.exoplatform.services.xmpp.util.HistoryUtils;
import org.exoplatform.services.xmpp.util.PresenceUtil;
import org.exoplatform.services.xmpp.util.TransformUtils;
import org.exoplatform.services.xmpp.util.XMPPConnectionUtils;
import org.exoplatform.ws.frameworks.cometd.transport.ContinuationServiceDelegate;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.exoplatform.ws.frameworks.json.impl.JsonGeneratorImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jivesoftware.smack.PacketInterceptor;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.Roster;
import org.jivesoftware.smack.RosterEntry;
import org.jivesoftware.smack.RosterGroup;
import org.jivesoftware.smack.RosterListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.jivesoftware.smack.packet.Presence;
import org.jivesoftware.smack.packet.XMPPError;
import org.jivesoftware.smackx.Form;
import org.jivesoftware.smackx.FormField;
import org.jivesoftware.smackx.ReportedData;
import org.jivesoftware.smackx.ServiceDiscoveryManager;
import org.jivesoftware.smackx.filetransfer.FileTransferListener;
import org.jivesoftware.smackx.filetransfer.FileTransferManager;
import org.jivesoftware.smackx.filetransfer.FileTransferRequest;
import org.jivesoftware.smackx.filetransfer.OutgoingFileTransfer;
import org.jivesoftware.smackx.muc.Affiliate;
import org.jivesoftware.smackx.muc.DefaultParticipantStatusListener;
import org.jivesoftware.smackx.muc.DefaultUserStatusListener;
import org.jivesoftware.smackx.muc.HostedRoom;
import org.jivesoftware.smackx.muc.InvitationListener;
import org.jivesoftware.smackx.muc.InvitationRejectionListener;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jivesoftware.smackx.muc.Occupant;
import org.jivesoftware.smackx.muc.ParticipantStatusListener;
import org.jivesoftware.smackx.muc.RoomInfo;
import org.jivesoftware.smackx.muc.SubjectUpdatedListener;
import org.jivesoftware.smackx.muc.UserStatusListener;
import org.jivesoftware.smackx.packet.DiscoverInfo;
import org.jivesoftware.smackx.packet.DiscoverItems;
import org.jivesoftware.smackx.packet.MUCUser;
import org.jivesoftware.smackx.search.UserSearchManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMPPSessionImpl
implements XMPPSession,
UIStateSession {
    private final XMPPConnection connection_;
    private final String username_;
    private int contFileTransfers;
    private MultiUserChatManager multiUserChatManager;
    private SessionProvider sessionProvider;
    private final HistoryImpl history_;
    private FileTransferManager fileTransferManager;
    private final Log log;
    private Map<String, FileTransferRequest> fileTransferRequestMap;
    private final UserInfoService organization_;
    private UIStateDataBean uiStateData_;
    private final ContinuationServiceDelegate delegate_;
    private final ResourceBundle rb_;
    private static final String DESCENDING = "desc";
    private static final String ASCENDING = "asc";
    private static ArrayList<OccupantBean> beanList = null;
    private final DateFormat dateFormat;
    private static final String ROOM_JID_VALUE = "muc#roomconfig_roomjid";
    private String status_;

    protected XMPPSessionImpl(String username, String password, UserInfoService organization, ContinuationServiceDelegate delegate, HistoryImpl history, ResourceBundle rb) throws XMPPException {
        block8: {
            this.log = ExoLogger.getLogger((String)"lr.XMPPSessionImpl");
            this.fileTransferRequestMap = new HashMap<String, FileTransferRequest>();
            this.dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z");
            this.status_ = "default_presence_status";
            if (beanList == null) {
                beanList = new ArrayList();
            }
            XMPPConnection.DEBUG_ENABLED = true;
            this.delegate_ = delegate;
            this.history_ = history;
            this.organization_ = organization;
            this.uiStateData_ = new UIStateDataBean();
            this.rb_ = rb;
            this.connection_ = new XMPPConnection(XMPPMessenger.getConnectionConfiguration());
            this.username_ = username;
            try {
                this.connection_.connect();
                this.connection_.login(username, password, null);
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)("Client '" + username + "' logged in."));
                }
                this.multiUserChatManager = new MultiUserChatManager();
                this.fileTransferManager = new FileTransferManager(this.connection_);
                this.fileTransferManager.addFileTransferListener(new FileTransferListener(){

                    public void fileTransferRequest(FileTransferRequest request) {
                        block6: {
                            try {
                                String uuid = UUID.randomUUID().toString();
                                XMPPSessionImpl.this.fileTransferRequestMap.put(uuid, request);
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                FileTransferRequestBean requestBean = new FileTransferRequestBean(request, uuid);
                                ArrayList<FileTransferRequestBean> list = new ArrayList<FileTransferRequestBean>();
                                list.add(requestBean);
                                FileTransferEventBean bean = new FileTransferEventBean();
                                bean.setFileTransportRequests(list);
                                EventsBean eventsBean = new EventsBean();
                                eventsBean.addFileEvent(bean);
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list2 = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list2.add(b);
                                    }
                                    eventsBean.setRoster(list2);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/FileExchange", json.toString(), null);
                                if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                    XMPPSessionImpl.this.log.debug((Object)json.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }
                });
                MessageFilter msgFilter = new MessageFilter();
                this.connection_.addPacketListener(new PacketListener(){

                    public void processPacket(Packet packet) {
                        try {
                            EventsBean eventsBean;
                            JsonGeneratorImpl generatorImpl;
                            block7: {
                                generatorImpl = new JsonGeneratorImpl();
                                if (packet.getPacketID() == null) {
                                    packet.setPacketID(CodingUtils.encodeToHex(UUID.randomUUID().toString()));
                                }
                                HistoricalMessageImpl historyMsg = HistoryUtils.messageToHistoricalMessage((Message)packet);
                                MessageBean message = TransformUtils.messageToBean(historyMsg);
                                XMPPSessionImpl.this.history_.logMessage(historyMsg);
                                eventsBean = new EventsBean();
                                eventsBean.addMessage(message);
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block7;
                                    e.printStackTrace();
                                }
                            }
                            JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                            XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/message", json.toString(), null);
                            if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                XMPPSessionImpl.this.log.debug((Object)json.toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, (PacketFilter)msgFilter);
                SubscriptionFilter subFilter = new SubscriptionFilter();
                this.connection_.addPacketListener(new PacketListener(){

                    public void processPacket(Packet packet) {
                        block6: {
                            try {
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                PresenceBean subscription = TransformUtils.presenceToBean((Presence)packet);
                                EventsBean eventsBean = new EventsBean();
                                UserInfo userInfo = XMPPSessionImpl.this.getUserInfo(subscription.getFrom().split("@")[0]);
                                subscription.setFromName(userInfo.getFirstName() + " " + userInfo.getLastName());
                                eventsBean.addSubscription(subscription);
                                if (subscription.getType().equals(Presence.Type.subscribed.name())) {
                                    Presence presence = XMPPSessionImpl.this.connection_.getRoster().getPresence(packet.getFrom());
                                    eventsBean.addPresence(TransformUtils.presenceToBean(presence));
                                }
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/subscription", json.toString(), null);
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }
                }, (PacketFilter)subFilter);
                MultiUserChat.addInvitationListener((XMPPConnection)this.connection_, (InvitationListener)new InvitationListener(){

                    public void invitationReceived(XMPPConnection conn, String room, String inviter, String reason, String password, Message message) {
                        block2: {
                            try {
                                MUCPacketBean bean = new MUCPacketBean();
                                bean.setAction("invite");
                                bean.setInvite(new InviteBean(inviter, TransformUtils.messageToBean(message), password, reason, room));
                                bean.setIsRoomPasswordProtect(XMPPSessionImpl.this.isPasswordRequired(room));
                                bean.setRoom(room);
                                XMPPSessionImpl.this.sendGroupChatEvent(bean);
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block2;
                                e.printStackTrace();
                            }
                        }
                    }
                });
                ErrorMessageFilter errorMessageFilter = new ErrorMessageFilter();
                this.connection_.addPacketListener(new PacketListener(){

                    public void processPacket(Packet packet) {
                        try {
                            EventsBean eventsBean;
                            JsonGeneratorImpl generatorImpl;
                            block10: {
                                Message message = (Message)packet;
                                String errorMessage = "";
                                if (message.getError().getCode() == 403 && message.getSubject() != null) {
                                    errorMessage = XMPPSessionImpl.this.rb_.getString("chat.message.subject.change.error");
                                } else if (message.getError().getCode() == 403) {
                                    MUCUser.Invite invite;
                                    errorMessage = XMPPSessionImpl.this.rb_.getString("chat.message.forbidden.error");
                                    MUCUser packetExtension = (MUCUser)packet.getExtension("x", "http://jabber.org/protocol/muc#user");
                                    if (packetExtension != null && (invite = packetExtension.getInvite()) != null) {
                                        errorMessage = XMPPSessionImpl.this.rb_.getString("chat.message.room.invite.forbidden.error");
                                        Object[] values = new Object[]{invite.getTo(), message.getFrom()};
                                        errorMessage = MessageFormat.format(errorMessage, values);
                                    }
                                }
                                generatorImpl = new JsonGeneratorImpl();
                                String id = CodingUtils.encodeToHex(UUID.randomUUID().toString());
                                MessageBean messageBean = new MessageBean(id, message.getFrom(), message.getTo(), message.getType().name(), errorMessage);
                                messageBean.setDateSend(Calendar.getInstance().getTime().toString());
                                eventsBean = new EventsBean();
                                eventsBean.addMessage(messageBean);
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block10;
                                    e.printStackTrace();
                                }
                            }
                            JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                            XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/message", json.toString(), null);
                            if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                XMPPSessionImpl.this.log.debug((Object)json.toString());
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }, (PacketFilter)errorMessageFilter);
                PacketTypeFilter discoverInfoFilter = new PacketTypeFilter(DiscoverInfo.class);
                this.connection_.addPacketWriterInterceptor(new PacketInterceptor(){

                    public void interceptPacket(Packet packet) {
                        DiscoverInfo.Identity id;
                        Iterator it;
                        DiscoverInfo discoverInfo = (DiscoverInfo)packet;
                        if (discoverInfo != null && discoverInfo.getType() == IQ.Type.RESULT && (it = discoverInfo.getIdentities()).hasNext() && (id = (DiscoverInfo.Identity)it.next()).getCategory().equalsIgnoreCase("client") && !discoverInfo.containsFeature("http://jabber.org/protocol/si/profile/file-transfer")) {
                            discoverInfo.addFeature("http://jabber.org/protocol/xhtml-im");
                            discoverInfo.addFeature("http://jabber.org/protocol/muc");
                            discoverInfo.addFeature("http://jabber.org/protocol/si/profile/file-transfer");
                            discoverInfo.addFeature("http://jabber.org/protocol/si");
                            discoverInfo.addFeature("http://jabber.org/protocol/bytestreams");
                            discoverInfo.addFeature("http://jabber.org/protocol/ibb");
                        }
                    }
                }, (PacketFilter)discoverInfoFilter);
                this.connection_.getRoster().addRosterListener(new RosterListener(){

                    public void entriesAdded(Collection<String> arg0) {
                        block6: {
                            try {
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                EventsBean eventsBean = new EventsBean();
                                eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", json.toString(), null);
                                if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                    XMPPSessionImpl.this.log.debug((Object)json.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }

                    public void entriesDeleted(Collection<String> arg0) {
                        block6: {
                            try {
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                EventsBean eventsBean = new EventsBean();
                                eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", json.toString(), null);
                                if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                    XMPPSessionImpl.this.log.debug((Object)json.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }

                    public void entriesUpdated(Collection<String> arg0) {
                        block6: {
                            try {
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                EventsBean eventsBean = new EventsBean();
                                eventsBean.setRoster(TransformUtils.rosterToRosterBean(XMPPSessionImpl.this.connection_.getRoster()));
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/roster", json.toString(), null);
                                if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                    XMPPSessionImpl.this.log.debug((Object)json.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }

                    public void presenceChanged(Presence presence) {
                        block6: {
                            try {
                                JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                                EventsBean eventsBean = new EventsBean();
                                eventsBean.addPresence(TransformUtils.presenceToBean(presence));
                                eventsBean.setEventId(Packet.nextID());
                                try {
                                    ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                                    for (ContactBean b : eventsBean.getRoster()) {
                                        UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                                        b.setFullName(info.getFirstName() + " " + info.getLastName());
                                        list.add(b);
                                    }
                                    eventsBean.setRoster(list);
                                }
                                catch (Exception e) {
                                    // empty catch block
                                }
                                JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                                XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/presence", json.toString(), null);
                                if (XMPPSessionImpl.this.log.isDebugEnabled()) {
                                    XMPPSessionImpl.this.log.debug((Object)json.toString());
                                }
                            }
                            catch (Exception e) {
                                if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block6;
                                e.printStackTrace();
                            }
                        }
                    }
                });
                this.sessionProvider = new SessionProvider(ConversationState.getCurrent());
                this.sessionProvider.getSession(this.history_.getWorkspace(), this.history_.getRepository());
            }
            catch (XMPPException e) {
                throw new XMPPException("Create XMPP connection for user '" + username + "' failed. ", (Throwable)e);
            }
            catch (RepositoryException e) {
                if (this.log.isDebugEnabled()) {
                    e.printStackTrace();
                }
            }
            catch (RepositoryConfigurationException e) {
                if (!this.log.isDebugEnabled()) break block8;
                e.printStackTrace();
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("finish initialize for the user:'" + username + "'."));
        }
    }

    @Override
    public boolean addTransport(Transport transport, String remoteUser, String remotePassword, boolean autoLogin) {
        if (!this.isTransportAvailable(transport) && this.isTransportSupported(transport)) {
            try {
                XMPPConnectionUtils.registerUser(this.connection_, transport.getServiceName(), remoteUser, remotePassword);
            }
            catch (XMPPException e) {
                e.printStackTrace();
                return false;
            }
            if (autoLogin) {
                Presence presence = new Presence(Presence.Type.available);
                presence.setTo(transport.getServiceName());
                this.sendPresence(presence);
            }
            return true;
        }
        return false;
    }

    @Override
    public void addBuddy(String username, String nickname, String group) throws XMPPException {
        String jid = username + "@" + this.connection_.getServiceName();
        Roster roster = this.connection_.getRoster();
        roster.createEntry(jid, nickname, new String[]{group});
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.username_ + " add to roster " + jid));
        }
    }

    @Override
    public void askForSubscription(String username, String nickname) {
        String jid = username + "@" + this.connection_.getServiceName();
        Presence precense = new Presence(Presence.Type.subscribe);
        precense.setTo(jid);
        this.sendPresence(precense);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.username_ + " ask subscription " + jid));
        }
    }

    @Override
    public RosterEntry getBuddy(String name) {
        String jid = name + "@" + this.connection_.getServiceName();
        return this.connection_.getRoster().getEntry(jid);
    }

    @Override
    public void updateBuddy(String username, String nickname, String group) throws XMPPException {
        String jid = username + "@" + this.connection_.getServiceName();
        Roster roster = this.connection_.getRoster();
        RosterEntry entry = roster.getEntry(jid);
        if (roster.getGroup(group) == null) {
            RosterGroup rosterGroup = roster.createGroup(group);
            rosterGroup.addEntry(entry);
        } else {
            RosterGroup rosterGroup = roster.getGroup(group);
            rosterGroup.addEntry(roster.getEntry(jid));
        }
    }

    public void createGroup(String grop) {
        try {
            Roster roster = this.connection_.getRoster();
            roster.createGroup(grop);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean cleanBuddiesList() throws XMPPException {
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            buddies.removeEntry(re);
        }
        return true;
    }

    @Override
    public void close() {
        this.sessionProvider.close();
        this.connection_.disconnect(new Presence(Presence.Type.unavailable));
        if (this.log.isDebugEnabled()) {
            this.log.info((Object)("Client '" + this.username_ + "' logged out."));
        }
    }

    @Override
    public List<HistoricalMessage> getAllHistory(String usernameto, String usernamefrom, boolean isGroupChat) {
        return this.history_.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, this.sessionProvider);
    }

    @Override
    public List<Presence> getBuddiesPresense() {
        ArrayList<Presence> list = new ArrayList<Presence>();
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            list.add(buddies.getPresence(re.getUser()));
        }
        return list;
    }

    @Override
    public XMPPConnection getConnection() {
        return this.connection_;
    }

    @Override
    public List<HistoricalMessage> getHistoryBetweenDate(String usernameto, String usernamefrom, boolean isGroupChat, Date dateFrom, Date dateTo) {
        return this.history_.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, dateFrom, dateTo, this.sessionProvider);
    }

    @Override
    public List<HistoricalMessage> getHistoryFromDateToNow(String usernameto, String usernamefrom, boolean isGroupChat, Date dateFrom) {
        return this.history_.getHistoricalMessages(usernameto, usernamefrom, isGroupChat, dateFrom, this.sessionProvider);
    }

    @Override
    public List<HistoricalMessage> getNotRecieveMessages() {
        String usernameTo = this.username_ + "@";
        return this.history_.getNotReciveMessage(usernameTo, this.sessionProvider);
    }

    @Override
    public List<Interlocutor> getInterlocutors(String username) {
        return this.history_.getInterlocutors(username, this.sessionProvider);
    }

    public MultiUserChatManager getMultiUserChatManager() {
        return this.multiUserChatManager;
    }

    @Override
    public Boolean isJoin(String room) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            return chat.isJoined();
        }
        return null;
    }

    @Override
    public Form getSearchForm(String searchService) throws XMPPException {
        return new UserSearchManager(this.connection_).getSearchForm(searchService);
    }

    @Override
    public List<String> getSearchServices() {
        DiscoverItems discoverItems = XMPPConnectionUtils.getDiscoverItems(this.connection_, this.connection_.getServiceName());
        Iterator iterator = discoverItems.getItems();
        ArrayList<String> services = new ArrayList<String>();
        ServiceDiscoveryManager discoveryManager = ServiceDiscoveryManager.getInstanceFor((XMPPConnection)this.connection_);
        while (iterator.hasNext()) {
            DiscoverInfo info;
            DiscoverItems.Item item = (DiscoverItems.Item)iterator.next();
            try {
                info = discoveryManager.discoverInfo(item.getEntityID());
            }
            catch (XMPPException e) {
                continue;
            }
            if (!info.containsFeature("jabber:iq:search")) continue;
            services.add(item.getEntityID());
        }
        return services;
    }

    @Override
    public UIStateDataBean getUIStateData() {
        return this.uiStateData_;
    }

    @Override
    public void setUIStateData(UIStateDataBean uiStateData) {
        this.uiStateData_ = uiStateData;
    }

    @Override
    public UserInfo getUserInfo(String userID) {
        return this.organization_.getUserInfo(userID);
    }

    @Override
    public String getUsername() {
        return this.username_;
    }

    private boolean isTransportAvailable(Transport transport) {
        return XMPPConnectionUtils.isRegistered(this.connection_, transport.getServiceName());
    }

    private boolean isTransportSupported(Transport transport) {
        List<Transport> supportedTransports = XMPPConnectionUtils.getSupportedTransports(this.connection_);
        for (Transport t : supportedTransports) {
            if (!t.getServiceName().equals(transport.getServiceName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeAllTransport() throws XMPPException {
        List<Transport> list = XMPPConnectionUtils.getSupportedTransports(this.connection_);
        for (Transport transport : list) {
            this.removeTransport(transport);
        }
    }

    @Override
    public boolean removeBuddy(String name) throws XMPPException {
        String jid = name + "@" + this.connection_.getServiceName();
        Roster buddies = this.connection_.getRoster();
        for (RosterEntry re : buddies.getEntries()) {
            if (!jid.equals(re.getUser())) continue;
            buddies.removeEntry(re);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeTransport(Transport transport) throws XMPPException {
        if (this.isTransportAvailable(transport)) {
            XMPPConnectionUtils.unregisterUser(this.connection_, transport.getServiceName());
            Presence presence = new Presence(Presence.Type.unavailable);
            presence.setTo(transport.getServiceName());
            this.sendPresence(presence);
        }
        return true;
    }

    @Override
    public ReportedData searchUser(String search, boolean byUsername, boolean byName, boolean byEmail, String searchService) throws XMPPException {
        UserSearchManager searchManager = new UserSearchManager(this.connection_);
        Form searchForm = searchManager.getSearchForm(searchService);
        Form answerForm = searchForm.createAnswerForm();
        Iterator searchableFieldsIterator = searchForm.getDataFormToSend().getFields();
        while (searchableFieldsIterator.hasNext()) {
            String searchVariable = ((FormField)searchableFieldsIterator.next()).getVariable();
            if (searchVariable.equalsIgnoreCase("username")) {
                answerForm.setAnswer(searchVariable, byUsername);
            }
            if (searchVariable.equalsIgnoreCase("name")) {
                answerForm.setAnswer(searchVariable, byName);
            }
            if (searchVariable.equalsIgnoreCase("email")) {
                answerForm.setAnswer(searchVariable, byEmail);
            }
            if (!searchVariable.equalsIgnoreCase("search") || search == null) continue;
            answerForm.setAnswer(searchVariable, search);
        }
        return searchManager.getSearchResults(answerForm, searchService);
    }

    @Override
    public void sendMessage(Message message) {
        if (this.connection_.isConnected()) {
            this.connection_.sendPacket((Packet)message);
        }
    }

    @Override
    public void sendMessageToMUC(String room, String body) throws XMPPException {
        MultiUserChat chat = this.multiUserChatManager.getMultiUserChat(room);
        Message message = chat.createMessage();
        message.setBody(body);
        message.setFrom(this.getUsername());
        chat.sendMessage(message);
    }

    @Override
    public void sendPresence(Presence presence) {
        if (this.connection_.isConnected()) {
            this.connection_.sendPacket((Packet)presence);
        }
    }

    @Override
    public void subscribeUser(String user) {
        String jid = user + "@" + this.connection_.getServiceName();
        Presence precense = new Presence(Presence.Type.subscribed);
        precense.setTo(jid);
        this.sendPresence(precense);
    }

    @Override
    public void subscribeUser(String toUser, String serviceName) {
        Presence precense = new Presence(Presence.Type.subscribed);
        precense.setTo(toUser + "@" + serviceName);
        this.sendPresence(precense);
    }

    @Override
    public void unsubscribeUser(String user) {
        String jid = user + "@" + this.connection_.getServiceName();
        Presence precense = new Presence(Presence.Type.unsubscribed);
        precense.setTo(jid);
        this.sendPresence(precense);
    }

    @Override
    public void unsubscribeUser(String toUser, String serviceName) {
        Presence precense = new Presence(Presence.Type.unsubscribed);
        precense.setTo(toUser + "@" + serviceName);
        this.sendPresence(precense);
    }

    @Override
    public void messageReceive(String messageId) {
        this.history_.messageReceive(messageId, this.sessionProvider);
    }

    public SessionProvider getSessionProvider() {
        return this.sessionProvider;
    }

    @Override
    public MultiUserChat getMultiUserChat(String room) throws XMPPException {
        String roomJID = this.validateRoomJID(room);
        return this.multiUserChatManager.getMultiUserChat(roomJID);
    }

    @Override
    public FormBean createRoom(String room, String nickname) throws XMPPException {
        String roomJID = this.validateRoomJID(room);
        MultiUserChat chat = new MultiUserChat(this.connection_, roomJID);
        if (nickname == null) {
            nickname = this.username_;
        }
        chat.create(nickname);
        this.multiUserChatManager.addMultiUserChat(chat);
        this.addListeners(chat);
        MUCPacketBean bean = new MUCPacketBean();
        bean.setAction("created");
        bean.setRoom(roomJID);
        bean.setCreatedRoom(this.getRoomInfoBean(roomJID));
        this.sendGroupChatEvent(bean);
        Form form = chat.getConfigurationForm();
        form = this.addRoomIDField(form, chat.getRoom());
        return TransformUtils.formToFormBean(form);
    }

    @Override
    public FormBean getConfigFormRoom(String room) throws XMPPException {
        Form form;
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null && (form = chat.getConfigurationForm()) != null) {
            form = this.addRoomIDField(form, chat.getRoom());
            FormBean formBean = TransformUtils.formToFormBean(form);
            ArrayList<String> users = new ArrayList<String>();
            ArrayList<String> fullNames = new ArrayList<String>();
            Iterator occupants = chat.getOccupants();
            while (occupants.hasNext()) {
                String occ = (String)occupants.next();
                String jid = chat.getOccupant(occ).getJid();
                users.add(jid);
                UserInfo info = this.getUserInfo(jid.split("@")[0]);
                fullNames.add(info.getFirstName() + " " + info.getLastName());
            }
            formBean.setMembers(users);
            formBean.setFullNames(fullNames);
            return formBean;
        }
        return null;
    }

    private Form addRoomIDField(Form form, String roomJID) {
        FormField formField = new FormField(ROOM_JID_VALUE);
        formField.addValue(roomJID);
        formField.setDescription("A fully qualified xmpp ID, e.g. roomName@service");
        formField.setLabel("Room JID");
        formField.setType("jid-single");
        form.addField(formField);
        return form;
    }

    @Override
    public MultiUserChat configRoom(String room, ConfigRoomBean cr) throws XMPPException {
        String service = this.connection_.getServiceName();
        ConfigRoomBean configRoom = new ConfigRoomBean();
        configRoom.setAllowinvites(cr.getAllowinvites());
        configRoom.setCanchangenick(cr.getCanchangenick());
        configRoom.setChangesubject(cr.getChangesubject());
        configRoom.setMaxusers(cr.getMaxusers());
        configRoom.setMembersonly(cr.getMembersonly());
        configRoom.setModeratedroom(cr.getModeratedroom());
        configRoom.setPasswordprotectedroom(cr.getPasswordprotectedroom());
        configRoom.setPersistentroom(cr.getPersistentroom());
        configRoom.setPresencebroadcast(cr.getPresencebroadcast());
        configRoom.setPublicroom(cr.getPublicroom());
        configRoom.setReservednick(cr.getReservednick());
        configRoom.setRoomdesc(cr.getRoomdesc());
        configRoom.setRoomname(cr.getRoomname());
        configRoom.setRoomsecret(cr.getRoomsecret());
        configRoom.setWhois(cr.getWhois());
        configRoom.setEnablelogging(cr.getEnablelogging());
        ArrayList<String> roomadmins = new ArrayList<String>();
        if (cr.getRoomadmins() != null) {
            for (String name : cr.getRoomadmins()) {
                if (!name.contains("@")) {
                    roomadmins.add(name + "@" + service);
                    continue;
                }
                roomadmins.add(name);
            }
        }
        configRoom.setRoomadmins(roomadmins);
        ArrayList<String> roomowners = new ArrayList<String>();
        if (cr.getRoomowners() != null) {
            for (String name : cr.getRoomowners()) {
                if (!name.contains("@")) {
                    roomowners.add(name + "@" + service);
                    continue;
                }
                roomowners.add(name);
            }
        }
        configRoom.setRoomowners(roomowners);
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            Form answerform = chat.getConfigurationForm().createAnswerForm();
            if (configRoom.getRoomname() != null) {
                answerform.setAnswer("muc#roomconfig_roomname", configRoom.getRoomname());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_roomname");
            }
            if (configRoom.getRoomdesc() != null) {
                answerform.setAnswer("muc#roomconfig_roomdesc", configRoom.getRoomdesc());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_roomdesc");
            }
            if (configRoom.getEnablelogging() != null) {
                answerform.setAnswer("muc#roomconfig_enablelogging", configRoom.getEnablelogging().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_enablelogging");
            }
            if (configRoom.getChangesubject() != null) {
                answerform.setAnswer("muc#roomconfig_changesubject", configRoom.getChangesubject().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_changesubject");
            }
            if (configRoom.getMaxusers() != null) {
                answerform.setAnswer("muc#roomconfig_maxusers", configRoom.getMaxusers());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_maxusers");
            }
            if (configRoom.getPresencebroadcast() != null) {
                answerform.setAnswer("muc#roomconfig_presencebroadcast", configRoom.getPresencebroadcast());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_presencebroadcast");
            }
            if (configRoom.getPublicroom() != null) {
                answerform.setAnswer("muc#roomconfig_publicroom", configRoom.getPublicroom().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_publicroom");
            }
            if (configRoom.getPersistentroom() != null) {
                answerform.setAnswer("muc#roomconfig_persistentroom", configRoom.getPersistentroom().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_persistentroom");
            }
            if (configRoom.getModeratedroom() != null) {
                answerform.setAnswer("muc#roomconfig_moderatedroom", configRoom.getModeratedroom().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_moderatedroom");
            }
            if (configRoom.getMembersonly() != null) {
                answerform.setAnswer("muc#roomconfig_membersonly", configRoom.getMembersonly().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_membersonly");
            }
            if (configRoom.getAllowinvites() != null) {
                answerform.setAnswer("muc#roomconfig_allowinvites", configRoom.getAllowinvites().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_allowinvites");
            }
            if (configRoom.getPasswordprotectedroom() != null) {
                answerform.setAnswer("muc#roomconfig_passwordprotectedroom", configRoom.getPasswordprotectedroom().booleanValue());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_passwordprotectedroom");
            }
            if (configRoom.getRoomsecret() != null) {
                answerform.setAnswer("muc#roomconfig_roomsecret", configRoom.getRoomsecret());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_roomsecret");
            }
            if (configRoom.getWhois() != null) {
                answerform.setAnswer("muc#roomconfig_whois", configRoom.getWhois());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_whois");
            }
            if (configRoom.getReservednick() != null) {
                answerform.setAnswer("x-muc#roomconfig_reservednick", configRoom.getReservednick().booleanValue());
            } else {
                answerform.setDefaultAnswer("x-muc#roomconfig_reservednick");
            }
            if (configRoom.getCanchangenick() != null) {
                answerform.setAnswer("x-muc#roomconfig_canchangenick", configRoom.getCanchangenick().booleanValue());
            } else {
                answerform.setDefaultAnswer("x-muc#roomconfig_canchangenick");
            }
            if (configRoom.getRoomadmins() != null) {
                if (configRoom.getRoomadmins().isEmpty()) {
                    ArrayList<String> adminsjid = new ArrayList<String>();
                    Collection admins = chat.getAdmins();
                    for (Affiliate affiliate : admins) {
                        adminsjid.add(affiliate.getJid());
                    }
                    chat.revokeAdmin(adminsjid);
                } else {
                    answerform.setAnswer("muc#roomconfig_roomadmins", configRoom.getRoomadmins());
                }
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_roomadmins");
            }
            if (configRoom.getRoomowners() != null) {
                answerform.setAnswer("muc#roomconfig_roomowners", configRoom.getRoomowners());
            } else {
                answerform.setDefaultAnswer("muc#roomconfig_roomowners");
            }
            chat.sendConfigurationForm(answerform);
            this.multiUserChatManager.updateMultiUserChat(chat);
            return chat;
        }
        return null;
    }

    public boolean isPasswordRequired(String room) {
        try {
            String roomJID = this.validateRoomJID(room);
            ServiceDiscoveryManager discover = new ServiceDiscoveryManager(this.connection_);
            DiscoverInfo info = discover.discoverInfo(roomJID);
            return info.containsFeature("muc_passwordprotected");
        }
        catch (XMPPException e) {
            e.printStackTrace();
            return false;
        }
    }

    @Override
    public void addFullUserNames(String userName, String fullUserName) {
        OccupantBean bean = new OccupantBean();
        bean.setFullName(fullUserName);
        bean.setNick(userName);
        beanList.add(bean);
    }

    @Override
    public void joinRoom(String room, String nickname, String password) throws XMPPException {
        MultiUserChat chat;
        JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
        FullRoomInfoBean infoBean = new FullRoomInfoBean();
        infoBean.setOccupants(beanList);
        try {
            JsonValue json = generatorImpl.createJsonObject((Object)infoBean);
            for (OccupantBean bean : beanList) {
                this.delegate_.sendMessage(bean.getNick(), "/eXo/Application/Chat/fullnameExchange", json.toString(), null);
            }
        }
        catch (JsonException e) {
            // empty catch block
        }
        if (nickname == null) {
            nickname = this.username_;
        }
        if ((chat = this.getMultiUserChat(room)) == null) {
            String roomJID = this.validateRoomJID(room);
            chat = new MultiUserChat(this.connection_, roomJID);
            this.addListeners(chat);
            this.multiUserChatManager.addMultiUserChat(chat);
        }
        if (!chat.isJoined()) {
            if (password != null) {
                chat.join(nickname, password);
            } else {
                chat.join(nickname);
            }
        }
    }

    public InitInfoBean getRooms(Integer from, Integer to, String sort) throws XMPPException {
        Collection collectionMUCService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_);
        String mucService = collectionMUCService.toArray()[0].toString();
        ArrayList<HostedRoom> hr = new ArrayList<HostedRoom>();
        ArrayList<HostedRoomBean> rooms = new ArrayList<HostedRoomBean>();
        Collection hostedRoomsAll = MultiUserChat.getHostedRooms((XMPPConnection)this.connection_, (String)mucService);
        for (HostedRoom hostedRoom : hostedRoomsAll) {
            hr.add(hostedRoom);
        }
        if (sort == null) {
            sort = ASCENDING;
        }
        if (sort.equalsIgnoreCase(DESCENDING)) {
            Collections.sort(hr, new RoomNameComparatorDesc());
        } else {
            Collections.sort(hr, new RoomNameComparatorAsc());
        }
        if (from == null || from < 0 || from > hr.size()) {
            from = 0;
        }
        if (to == null || from > to || to < 0 || to > hr.size()) {
            to = hr.size();
        }
        List hrp = hr.subList(from, to);
        for (HostedRoom hostedRoom : hrp) {
            HostedRoomBean roomBean = new HostedRoomBean();
            RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)this.connection_, (String)hostedRoom.getJid());
            if (roomInfo != null) {
                roomBean = new HostedRoomBean(roomInfo);
            }
            roomBean.setJid(hostedRoom.getJid());
            roomBean.setName(hostedRoom.getName());
            rooms.add(roomBean);
        }
        InitInfoBean infoBean = new InitInfoBean();
        infoBean.setHostedRooms(rooms);
        infoBean.setTotalRooms(hostedRoomsAll.size());
        return infoBean;
    }

    @Override
    public void changeSubject(String room, String newSubject) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            chat.changeSubject(newSubject);
        }
    }

    @Override
    public void changeAvailabilityStatusInRoom(String room, String status, String mode) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            Presence.Mode m = Presence.Mode.valueOf((String)mode);
            if ((status == null || status.length() == 0) && (status = PresenceUtil.getDefaultStatusMode(m)) == null) {
                status = mode;
            }
            chat.changeAvailabilityStatus(status, m);
        }
    }

    @Override
    public List<String> getJoinedRooms() {
        Collection<MultiUserChat> collection = this.multiUserChatManager.getAll();
        ArrayList<String> joinedRooms = new ArrayList<String>();
        for (MultiUserChat multiUserChat : collection) {
            if (!multiUserChat.isJoined()) continue;
            joinedRooms.add(multiUserChat.getRoom());
        }
        return joinedRooms;
    }

    @Override
    public FullRoomInfoBean getRoomInfoBean(String room) throws XMPPException {
        ExoContainer container = ExoContainerContext.getCurrentContainer();
        UserInfoService organization = (UserInfoService)container.getComponentInstanceOfType(UserInfoService.class);
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            RoomInfo roomInfo = MultiUserChat.getRoomInfo((XMPPConnection)this.connection_, (String)chat.getRoom());
            ArrayList<OccupantBean> occupants = new ArrayList<OccupantBean>();
            Iterator occ = chat.getOccupants();
            while (occ.hasNext()) {
                String user = (String)occ.next();
                Occupant occupant = chat.getOccupant(user);
                OccupantBean occupantBean = new OccupantBean();
                occupantBean.setAffiliation(occupant.getAffiliation());
                occupantBean.setJid(occupant.getJid());
                occupantBean.setNick(occupant.getNick());
                occupantBean.setRole(occupant.getRole());
                UserInfo userInfo = organization.getUserInfo(occupant.getNick());
                occupantBean.setFullName(userInfo.getFirstName() + " " + userInfo.getLastName());
                occupants.add(occupantBean);
            }
            FullRoomInfoBean infoBean = new FullRoomInfoBean(occupants, roomInfo);
            return infoBean;
        }
        return null;
    }

    @Override
    public RoomInfo getRoomInfo(String room) throws XMPPException {
        String roomJID = this.validateRoomJID(room);
        return MultiUserChat.getRoomInfo((XMPPConnection)this.connection_, (String)roomJID);
    }

    @Override
    public void declineRoom(String room, String inviter, String reason) {
        String roomJID = this.validateRoomJID(room);
        String inviterJID = inviter + "@" + this.connection_.getServiceName();
        MultiUserChat.decline((XMPPConnection)this.connection_, (String)roomJID, (String)inviterJID, (String)reason);
    }

    @Override
    public Boolean inviteToRoom(String room, String invitee, String reason) throws XMPPException {
        String inviteeJID = invitee + "@" + this.connection_.getServiceName();
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null && chat.isJoined()) {
            chat.invite(inviteeJID, reason);
            return true;
        }
        return false;
    }

    @Override
    public Boolean leaveRoom(String room) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            if (chat.isJoined()) {
                chat.leave();
            }
            this.multiUserChatManager.removeMultiUserChat(chat);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manageRole(String room, String nickname, String role, String command) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat == null) {
            throw new XMPPException("Chat not found", new XMPPError(XMPPError.Condition.item_not_found));
        }
        if (role.equals("moderator")) {
            if (command.equals("grant")) {
                chat.grantModerator(nickname);
                return;
            } else {
                if (!command.equals("revoke")) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeModerator(nickname);
            }
            return;
        } else {
            if (!role.equals("participant")) throw new XMPPException("Wrong role must be: 'moderator' or 'participant'");
            if (command.equals("grant")) {
                chat.grantVoice(nickname);
                return;
            } else {
                if (!command.equals("revoke")) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeVoice(nickname);
            }
        }
    }

    @Override
    public void kickUser(String room, String nickname, String reason) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat == null) {
            throw new XMPPException("Chat not found", new XMPPError(XMPPError.Condition.item_not_found));
        }
        chat.kickParticipant(nickname, reason);
    }

    @Override
    public void banUser(String room, String nickname, String reason) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat == null) {
            throw new XMPPException("Chat not found", new XMPPError(XMPPError.Condition.item_not_found));
        }
        Occupant occupant = chat.getOccupant(chat.getRoom() + "/" + nickname);
        if (occupant != null) {
            String jid = occupant.getJid();
            chat.banUser(jid, reason);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Occupants witn nickname " + nickname + " not found!"));
        }
    }

    @Override
    public void changeNickname(String room, String nickname) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null && nickname != null) {
            chat.changeNickname(nickname);
        }
    }

    @Override
    public Boolean destroyRoom(String room, String reason, String altRoom) throws XMPPException {
        String alternateJID = this.validateRoomJID(altRoom);
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat != null) {
            chat.destroy(reason, alternateJID);
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void manageAffiliation(String room, String nickname, String affiliation, String command) throws XMPPException {
        MultiUserChat chat = this.getMultiUserChat(room);
        if (chat == null) {
            throw new XMPPException("Chat not found", new XMPPError(XMPPError.Condition.item_not_found));
        }
        Occupant occupant = chat.getOccupant(chat.getRoom() + "/" + nickname);
        if (occupant == null) return;
        String jid = occupant.getJid();
        if (affiliation.equals("admin")) {
            if (command.equals("grant")) {
                chat.grantAdmin(jid);
                return;
            } else {
                if (!command.equals("revoke")) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeAdmin(jid);
            }
            return;
        } else if (affiliation.equals("member")) {
            if (command.equals("grant")) {
                chat.grantMembership(jid);
                return;
            } else {
                if (!command.equals("revoke")) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeMembership(jid);
            }
            return;
        } else {
            if (!affiliation.equals("owner")) throw new XMPPException("Wrong affiliation must be: 'owner, 'admin' or 'member'");
            if (command.equals("grant")) {
                chat.grantOwnership(jid);
                return;
            } else {
                if (!command.equals("revoke")) throw new XMPPException("Wrong command must be: 'grant' or 'revoke'");
                chat.revokeOwnership(jid);
            }
        }
    }

    public FileTransferRequest getFileTransferRequest(String uuid) {
        return this.fileTransferRequestMap.remove(uuid);
    }

    public void sendFile(String requestor, String path, String description, boolean isRoom) throws Exception {
        if (!isRoom) {
            this.contFileTransfers = 1;
            String fullJID = this.connection_.getRoster().getPresence(requestor + "@" + this.connection_.getServiceName()).getFrom();
            this.sendFile(fullJID, path, description);
        } else {
            MultiUserChat chat = this.getMultiUserChat(requestor);
            Iterator occ = chat.getOccupants();
            ArrayList<String> reqs = new ArrayList<String>();
            while (occ.hasNext()) {
                String user = (String)occ.next();
                String jid = chat.getOccupant(user).getJid();
                if (jid.split("@")[0].equals(this.username_)) continue;
                reqs.add(jid);
            }
            this.contFileTransfers = reqs.size();
            for (String jid : reqs) {
                this.sendFile(jid, path, description);
            }
        }
    }

    private void sendFile(String fullJID, String path, String description) throws Exception {
        FileTransferManager manager = new FileTransferManager(this.connection_);
        OutgoingFileTransfer transfer = manager.createOutgoingFileTransfer(fullJID);
        transfer.sendFile(new File(path), description);
        CheckStatusFileTransfer check = new CheckStatusFileTransfer(transfer);
        check.start();
    }

    public void rejectFile(String uuid) {
        this.getFileTransferRequest(uuid).reject();
    }

    private void delFile(String path) {
        block3: {
            try {
                File file = new File(path);
                File dir = new File(file.getParent());
                file.delete();
                dir.delete();
                if (this.log.isDebugEnabled()) {
                    this.log.info((Object)("Delete file : " + file.getAbsolutePath()));
                }
            }
            catch (SecurityException e) {
                if (!this.log.isDebugEnabled()) break block3;
                e.printStackTrace();
            }
        }
    }

    private void addListeners(final MultiUserChat chat) {
        chat.addInvitationRejectionListener(new InvitationRejectionListener(){

            public void invitationDeclined(String invitee, String reason) {
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("decline");
                bean.setDecline(new DeclineBean(invitee, reason));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }
        });
        chat.addParticipantListener(new PacketListener(){

            public void processPacket(Packet packet) {
                Presence prs = (Presence)packet;
                if (prs.getStatus() != null) {
                    MUCPacketBean bean = new MUCPacketBean();
                    bean.setAction("presence-change");
                    String mode = new String();
                    String type = new String();
                    if (prs.getMode() != null) {
                        mode = prs.getMode().name();
                    }
                    if (prs.getType() != null) {
                        type = prs.getType().name();
                    }
                    bean.setPresence(new PresenceBean(prs.getFrom(), mode, type, prs.getStatus()));
                    bean.setRoom(chat.getRoom());
                    XMPPSessionImpl.this.sendGroupChatEvent(bean);
                }
            }
        });
        chat.addSubjectUpdatedListener(new SubjectUpdatedListener(){

            public void subjectUpdated(String subject, String from) {
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("subject-change");
                bean.setSubjectChange(new SubjectChangeBean(from, subject));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }
        });
        chat.addParticipantStatusListener((ParticipantStatusListener)new DefaultParticipantStatusListener(){

            public void ownershipGranted(String participant) {
                super.ownershipGranted(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("owner", "granted", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void ownershipRevoked(String participant) {
                super.ownershipRevoked(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("owner", "revoked", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void adminGranted(String participant) {
                super.adminGranted(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("admin", "granted", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void adminRevoked(String participant) {
                super.adminRevoked(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("admin", "revoked", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void membershipGranted(String participant) {
                super.membershipGranted(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("member", "granted", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void membershipRevoked(String participant) {
                super.membershipRevoked(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("member", "revoked", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void moderatorGranted(String participant) {
                super.moderatorGranted(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("role-change");
                bean.setRole(new PrivilegeChangeBean("moderator", "granted", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void moderatorRevoked(String participant) {
                super.moderatorRevoked(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("role-change");
                bean.setRole(new PrivilegeChangeBean("moderator", "revoked", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void voiceGranted(String participant) {
                super.voiceGranted(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("role-change");
                bean.setRole(new PrivilegeChangeBean("visitor", "granted", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void voiceRevoked(String participant) {
                super.voiceRevoked(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("role-change");
                bean.setRole(new PrivilegeChangeBean("visitor", "revoked", participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void nicknameChanged(String participant, String newNickname) {
                super.nicknameChanged(participant, newNickname);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("nickname-change");
                bean.setChangeNick(new ChangeNickBean(newNickname, participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void banned(String participant, String actor, String reason) {
                super.banned(participant, actor, reason);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("banned");
                bean.setBanned(new KickedBannedBean(actor, participant, reason));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void kicked(String participant, String actor, String reason) {
                super.kicked(participant, actor, reason);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("kicked");
                bean.setKicked(new KickedBannedBean(actor, participant, reason));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void joined(String participant) {
                super.joined(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("joined");
                bean.setJoined(participant);
                bean.setOccupant(chat.getOccupant(participant));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void left(String participant) {
                super.left(participant);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("left");
                bean.setLeft(participant);
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }
        });
        chat.addUserStatusListener((UserStatusListener)new DefaultUserStatusListener(){

            public void ownershipGranted() {
                super.ownershipGranted();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("owner", "granted", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void ownershipRevoked() {
                super.ownershipRevoked();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("owner", "revoked", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void adminGranted() {
                super.adminGranted();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("admin", "granted", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void adminRevoked() {
                super.adminRevoked();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("admin", "revoked", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void membershipGranted() {
                super.membershipGranted();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("member", "granted", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void membershipRevoked() {
                super.membershipRevoked();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-affiliate-change");
                bean.setAffiliate(new PrivilegeChangeBean("member", "revoked", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void moderatorGranted() {
                super.moderatorGranted();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-role-change");
                bean.setRole(new PrivilegeChangeBean("moderator", "granted", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void moderatorRevoked() {
                super.moderatorRevoked();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-role-change");
                bean.setRole(new PrivilegeChangeBean("moderator", "revoked", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void voiceGranted() {
                super.voiceGranted();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-role-change");
                bean.setRole(new PrivilegeChangeBean("visitor", "granted", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void voiceRevoked() {
                super.voiceRevoked();
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-role-change");
                bean.setRole(new PrivilegeChangeBean("visitor", "revoked", null));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void banned(String actor, String reason) {
                super.banned(actor, reason);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-banned");
                bean.setBanned(new KickedBannedBean(actor, null, reason));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }

            public void kicked(String actor, String reason) {
                super.kicked(actor, reason);
                MUCPacketBean bean = new MUCPacketBean();
                bean.setAction("you-kicked");
                bean.setKicked(new KickedBannedBean(actor, null, reason));
                bean.setRoom(chat.getRoom());
                XMPPSessionImpl.this.sendGroupChatEvent(bean);
            }
        });
    }

    public void sendErrorMessage(String msg, String sender) {
        try {
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            String id = CodingUtils.encodeToHex(UUID.randomUUID().toString());
            MessageBean messageBean = new MessageBean();
            messageBean.setBody(msg);
            messageBean.setFrom(sender);
            messageBean.setId(id);
            messageBean.setTo(this.connection_.getUser());
            messageBean.setType(Message.Type.error.name());
            messageBean.setDateSend(Calendar.getInstance().getTime().toString());
            EventsBean eventsBean = new EventsBean();
            eventsBean.addMessage(messageBean);
            eventsBean.setEventId(Packet.nextID());
            try {
                ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                for (ContactBean b : eventsBean.getRoster()) {
                    UserInfo info = this.getUserInfo(b.getUser().split("@")[0]);
                    b.setFullName(info.getFirstName() + " " + info.getLastName());
                    list.add(b);
                }
                eventsBean.setRoster(list);
            }
            catch (Exception e) {
                // empty catch block
            }
            JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
            this.delegate_.sendMessage(this.username_, "/eXo/Application/Chat/message", json.toString(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendGroupChatEvent(MUCPacketBean bean) {
        try {
            JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
            EventsBean eventsBean = new EventsBean();
            eventsBean.addMUCEvent(bean);
            try {
                ArrayList<ContactBean> list = new ArrayList<ContactBean>();
                for (ContactBean b : eventsBean.getRoster()) {
                    UserInfo info = this.getUserInfo(b.getUser().split("@")[0]);
                    b.setFullName(info.getFirstName() + " " + info.getLastName());
                    list.add(b);
                }
                eventsBean.setRoster(list);
            }
            catch (Exception e) {
                // empty catch block
            }
            JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
            this.delegate_.sendMessage(this.username_, "/eXo/Application/Chat/groupchat", json.toString(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String validateRoomJID(String room) {
        String roomJID;
        block4: {
            roomJID = new String();
            try {
                if (room.contains("@")) {
                    roomJID = room;
                } else {
                    String mucService = MultiUserChat.getServiceNames((XMPPConnection)this.connection_).toArray()[0].toString();
                    roomJID = room + "@" + mucService;
                }
            }
            catch (Exception e) {
                if (!this.log.isDebugEnabled()) break block4;
                e.printStackTrace();
            }
        }
        return roomJID;
    }

    @Override
    public String getPresenceStatus_() {
        return this.status_;
    }

    @Override
    public void setPresenceStatus_(String status) {
        this.status_ = status;
    }

    class CheckStatusFileTransfer
    extends Thread {
        OutgoingFileTransfer transfer;

        public CheckStatusFileTransfer(OutgoingFileTransfer transfer) {
            this.transfer = transfer;
        }

        public void run() {
            block7: {
                try {
                    while (!this.transfer.isDone()) {
                        Thread.sleep(1000L);
                    }
                    JsonGeneratorImpl generatorImpl = new JsonGeneratorImpl();
                    FileTransferResponseBean responseBean = new FileTransferResponseBean(this.transfer, XMPPSessionImpl.this.connection_.getUser());
                    ArrayList<FileTransferResponseBean> list = new ArrayList<FileTransferResponseBean>();
                    list.add(responseBean);
                    FileTransferEventBean bean = new FileTransferEventBean();
                    bean.setFileTransportResponses(list);
                    EventsBean eventsBean = new EventsBean();
                    eventsBean.addFileEvent(bean);
                    eventsBean.setEventId(Packet.nextID());
                    try {
                        ArrayList<ContactBean> list2 = new ArrayList<ContactBean>();
                        for (ContactBean b : eventsBean.getRoster()) {
                            UserInfo info = XMPPSessionImpl.this.getUserInfo(b.getUser().split("@")[0]);
                            b.setFullName(info.getFirstName() + " " + info.getLastName());
                            list2.add(b);
                        }
                        eventsBean.setRoster(list2);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    JsonValue json = generatorImpl.createJsonObject((Object)eventsBean);
                    XMPPSessionImpl.this.delegate_.sendMessage(XMPPSessionImpl.this.username_, "/eXo/Application/Chat/FileExchange", json.toString(), null);
                    XMPPSessionImpl.this.contFileTransfers--;
                    if (XMPPSessionImpl.this.contFileTransfers == 0) {
                        XMPPSessionImpl.this.delFile(this.transfer.getFilePath());
                    }
                }
                catch (Exception e) {
                    if (!XMPPSessionImpl.this.log.isDebugEnabled()) break block7;
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoomNameComparatorDesc
    implements Comparator<HostedRoom> {
        private RoomNameComparatorDesc() {
        }

        @Override
        public int compare(HostedRoom room1, HostedRoom room2) {
            if (room1.getName().length() == room2.getName().length()) {
                return room2.getName().compareTo(room1.getName());
            }
            return room2.getName().length() > room1.getName().length() ? 1 : -1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RoomNameComparatorAsc
    implements Comparator<HostedRoom> {
        private RoomNameComparatorAsc() {
        }

        @Override
        public int compare(HostedRoom room1, HostedRoom room2) {
            if (room1.getName().length() == room2.getName().length()) {
                return room1.getName().compareTo(room2.getName());
            }
            return room1.getName().length() > room2.getName().length() ? 1 : -1;
        }
    }
}

