/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.mail.service.impl;

import org.exoplatform.container.xml.InitParams;
import org.exoplatform.mail.service.Account;
import org.exoplatform.mail.service.Folder;
import org.exoplatform.mail.service.MailService;
import org.exoplatform.mail.service.Utils;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserEventListener;

public class NewUserListener
extends UserEventListener {
    private MailService mservice_;
    public static final String FD_INBOX = "Inbox".intern();
    public static final String FD_DRAFTS = "Drafts".intern();
    public static final String FD_SENT = "Sent".intern();
    public static final String FD_SPAM = "Spam".intern();
    public static final String FD_TRASH = "Trash".intern();
    public static final String[] defaultFolders_ = new String[]{FD_INBOX, FD_DRAFTS, FD_SENT, FD_SPAM, FD_TRASH};
    String protocol;
    boolean isSSL;
    String incomingHost;
    String incomingPort;
    String incomingFolder;
    String outgoingHost;
    String outgoingPort;

    public NewUserListener(MailService mservice, InitParams params) throws Exception {
        this.mservice_ = mservice;
        this.protocol = params.getValueParam("protocol").getValue();
        String ssl = params.getValueParam("ssl").getValue();
        this.isSSL = ssl != null && ssl.equalsIgnoreCase("true");
        this.incomingHost = params.getValueParam("incomingServer").getValue();
        this.incomingPort = params.getValueParam("incomingPort").getValue();
        this.incomingFolder = params.getValueParam("incomingFolder").getValue();
        this.outgoingHost = params.getValueParam("outgoingServer").getValue();
        this.outgoingPort = params.getValueParam("outgoingPort").getValue();
    }

    public void postSave(User user, boolean isNew) throws Exception {
        if (!isNew) {
            return;
        }
        String fullName = user.getFullName();
        String email = user.getEmail();
        String password = user.getPassword();
        Account acc = new Account();
        String incomingUserName = email;
        acc.setLabel(fullName);
        acc.setDescription("");
        acc.setUserDisplayName(fullName);
        acc.setEmailAddress(email);
        acc.setEmailReplyAddress(email);
        acc.setSignature("");
        acc.setIncomingUser(incomingUserName);
        acc.setIncomingPassword(password);
        acc.setIsSavePassword(true);
        acc.setIncomingHost(this.incomingHost);
        acc.setIncomingPort(this.incomingPort);
        acc.setProtocol(this.protocol);
        acc.setIncomingSsl(this.isSSL);
        acc.setIncomingFolder(this.incomingFolder);
        acc.setServerProperty(Utils.SVR_SMTP_USER, incomingUserName);
        acc.setOutgoingHost(this.outgoingHost);
        acc.setOutgoingPort(this.outgoingPort);
        String username = user.getUserName();
        String accId = acc.getId();
        String folderId = null;
        Folder folder = null;
        try {
            this.mservice_.createAccount(username, acc);
            for (String folderName : defaultFolders_) {
                folderId = Utils.generateFID(accId, folderName, false);
                folder = this.mservice_.getFolder(username, accId, folderId);
                if (folder != null) continue;
                folder = new Folder();
                folder.setId(folderId);
                folder.setName(folderName);
                folder.setPersonalFolder(false);
                this.mservice_.saveFolder(username, accId, folder);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

