/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core;

import javax.jcr.RepositoryException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.services.jcr.core.XASession;
import org.exoplatform.services.jcr.impl.core.RepositoryImpl;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.jcr.impl.core.XASessionException;
import org.exoplatform.services.jcr.impl.dataflow.session.TransactionableResourceManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.transaction.ExoResource;
import org.exoplatform.services.transaction.TransactionException;
import org.exoplatform.services.transaction.TransactionService;

public class XASessionImpl
extends SessionImpl
implements XASession,
XAResource,
ExoResource {
    private static final Log LOG = ExoLogger.getLogger((String)"exo.jcr.component.core.XASessionImpl");
    private final TransactionService tService;
    private final TransactionableResourceManager txResourceManager;
    private int startFlags = 0;
    private int txTimeout;
    private Object payload;
    private TransactionException commitException = null;

    XASessionImpl(String workspaceName, ConversationState userState, ExoContainer container, TransactionService tService, TransactionableResourceManager txResourceManager) throws RepositoryException {
        super(workspaceName, userState, container);
        this.txTimeout = tService.getDefaultTimeout();
        this.tService = tService;
        this.txResourceManager = txResourceManager;
        try {
            this.enlistResource();
        }
        catch (XAException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public XAResource getXAResource() {
        return this;
    }

    public void delistResource() throws XAException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Delist session: " + this.getSessionInfo() + ", " + this));
            }
            this.commitException = null;
            this.txResourceManager.remove(this);
            this.tService.delistResource((ExoResource)this);
        }
        catch (RollbackException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Delist error, session: " + this.getSessionInfo() + ", " + this), (Throwable)e);
            }
            throw new XASessionException("Cannot delist resource XASession " + this.getSessionInfo() + ". " + (Object)((Object)e));
        }
        catch (SystemException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Delist error, session: " + this.getSessionInfo() + ", " + this), (Throwable)e);
            }
            throw new XASessionException("Cannot delist resource XASession " + this.getSessionInfo() + ". " + (Object)((Object)e));
        }
    }

    public void enlistResource() throws XAException {
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enlist session: " + this.getSessionInfo() + ", " + this));
            }
            this.commitException = null;
            this.txResourceManager.add(this);
            this.tService.enlistResource((ExoResource)this);
        }
        catch (RollbackException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enlist error, session: " + this.getSessionInfo() + ", " + this), (Throwable)e);
            }
            throw new XASessionException("Cannot enlist resource XASession " + this.getSessionInfo() + ". " + (Object)((Object)e));
        }
        catch (SystemException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Enlist error, session: " + this.getSessionInfo() + ", " + this), (Throwable)e);
            }
            throw new XASessionException("Cannot enlist resource XASession " + this.getSessionInfo() + ". " + (Object)((Object)e));
        }
    }

    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.txResourceManager.commit(this, onePhase);
        }
        catch (TransactionException e) {
            this.commitException = e;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Commit Error. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this), (Throwable)e);
            }
            throw new XASessionException(e.toString(), e.getErrorCode());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Commit. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void start(Xid xid, int flags) throws XAException {
        this.txResourceManager.start(this);
        this.startFlags = flags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Start. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void end(Xid xid, int flags) throws XAException {
        this.startFlags = flags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("End. Xid:" + xid + ", " + flags + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public void forget(Xid xid) throws XAException {
    }

    public int getTransactionTimeout() throws XAException {
        return this.txTimeout;
    }

    public boolean isSameRM(XAResource resource) throws XAException {
        if (resource instanceof XASessionImpl) {
            boolean isSame;
            XASessionImpl session = (XASessionImpl)resource;
            boolean bl = isSame = this.getUserID().equals(session.getUserID()) && this.getWorkspace().getName().equals(session.getWorkspace().getName()) && ((RepositoryImpl)this.getRepository()).getName().equals(((RepositoryImpl)session.getRepository()).getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("isSameRM: " + this.getSessionInfo() + " -- " + session.getSessionInfo() + " : " + isSame + ", " + this + " -- " + session + ", Flags:" + this.startFlags));
            }
            return isSame;
        }
        return false;
    }

    public int prepare(Xid xid) throws XAException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Prepare. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
        return 0;
    }

    public Xid[] recover(int xid) throws XAException {
        return null;
    }

    public void rollback(Xid xid) throws XAException {
        this.txResourceManager.rollback(this);
        this.commitException = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Rollback. Xid:" + xid + ", session: " + this.getSessionInfo() + ", " + this));
        }
    }

    public boolean setTransactionTimeout(int seconds) throws XAException {
        try {
            this.tService.setTransactionTimeout(seconds);
        }
        catch (SystemException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cannot set transaction timeout " + seconds + "sec via XASession " + this.getSessionInfo() + ". "), (Throwable)e);
            }
            throw new XASessionException("Cannot set transaction timeout " + seconds + "sec via XASession " + this.getSessionInfo() + ". " + (Object)((Object)e));
        }
        this.txTimeout = seconds;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void logout() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Logout. Session: " + this.getSessionInfo() + ", " + this));
        }
        try {
            this.getTransientNodesManager().getTransactManager().rollback();
            super.logout();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            try {
                this.delistResource();
                this.startFlags = 0;
            }
            catch (XAException e) {
                LOG.error((Object)("Logout error " + e), (Throwable)e);
            }
            throw throwable;
        }
        try {
            this.delistResource();
            this.startFlags = 0;
        }
        catch (XAException e) {
            LOG.error((Object)("Logout error " + e), (Throwable)e);
        }
    }

    private String getSessionInfo() {
        return this.getUserID() + "@" + this.workspaceName;
    }

    public Object getPayload() {
        return this.payload;
    }

    public void setPayload(Object payload) {
        this.payload = payload;
    }

    public TransactionException getCommitException() {
        return this.commitException;
    }
}

