/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.platform.listeners;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import org.exoplatform.commons.chromattic.ChromatticManager;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.config.DataStorage;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationType;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.space.SpaceListenerPlugin;
import org.exoplatform.social.core.space.spi.SpaceLifeCycleEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomizeSpacePagesListener
extends SpaceListenerPlugin {
    private static Log LOG = ExoLogger.getExoLogger(CustomizeSpacePagesListener.class);
    private static final String GROUP_ID_PREFERENCE = "{groupId}";
    private static final String MODIFIED_GROUP_ID_PREFERENCE = "{modifiedGroupId}";
    private static final String PAGE_NAME_PREFERENCE = "{pageName}";
    private DataStorage dataStorageService = null;
    private ChromatticManager chromatticManager = null;
    private String portletName = null;
    private String navigationLabel = null;
    private ExoProperties portletPreferencesInitParams = null;

    public CustomizeSpacePagesListener(DataStorage dataStorageService, ChromatticManager chromatticManager, InitParams params) {
        this.dataStorageService = dataStorageService;
        this.chromatticManager = chromatticManager;
        this.portletName = params.getValueParam("portlet-name").getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("portlet-name init param = " + this.portletName));
        }
        this.navigationLabel = params.getValueParam("navigation-label").getValue();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("navigation-name init param = " + this.navigationLabel));
        }
        this.portletPreferencesInitParams = params.getPropertiesParam("portletPreferences").getProperties();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("portletPreferences init param = " + this.portletPreferencesInitParams));
        }
    }

    public void applicationActivated(SpaceLifeCycleEvent event) {
    }

    public void applicationAdded(SpaceLifeCycleEvent spaceLifeCycleEvent) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("applicationAdded(spaceLifeCycleEvent = " + spaceLifeCycleEvent + ")"));
        }
        String groupId = spaceLifeCycleEvent.getSpace().getGroupId();
        String pageName = (String)spaceLifeCycleEvent.getSource();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Application was added in a page named " + pageName + "for the group" + groupId));
        }
        if (!pageName.equals(this.portletName)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"actual page name is different to the portlet name. No modifications will be made on this page");
            }
            return;
        }
        try {
            int i;
            boolean beginRequest;
            block27: {
                beginRequest = false;
                try {
                    if (this.chromatticManager.getSynchronization() == null) {
                        this.chromatticManager.beginRequest();
                        beginRequest = true;
                    }
                }
                catch (Exception exception) {
                    if (!LOG.isDebugEnabled()) break block27;
                    LOG.debug((Object)("chromatticManager.beginRequest() have thrown an exception: " + exception.getMessage()));
                }
            }
            Page page = null;
            for (i = 0; page == null && i < Integer.MAX_VALUE; ++i) {
                page = this.dataStorageService.getPage("group::" + groupId + "::" + pageName);
            }
            if (page == null) {
                LOG.error((Object)new IllegalStateException("referenced page with '" + pageName + "' name couldn't be found. No modifications will be applied."));
                return;
            }
            PageNavigation pageNavigation = null;
            for (i = 0; pageNavigation == null && i < Integer.MAX_VALUE; ++i) {
                pageNavigation = this.dataStorageService.getPageNavigation("group", groupId);
            }
            if (pageNavigation == null) {
                LOG.error((Object)new IllegalStateException("referenced Page Navigation node for 'group:" + groupId + "' name couldn't be found. No modifications will be applied."));
                return;
            }
            PageNode pageNode = this.getPageNode(pageName, pageNavigation.getNodes());
            if (pageNode == null) {
                LOG.error((Object)new IllegalStateException("referenced Page Node node with '" + pageName + "' name couldn't be found. No modifications will be applied."));
                return;
            }
            pageNode.setLabel(this.navigationLabel);
            this.dataStorageService.save(pageNavigation);
            Application<Portlet> selectedPortlet = this.getPortletApplication(page.getChildren(), this.portletName);
            if (selectedPortlet == null) {
                LOG.warn((Object)("referenced portlet with '" + this.portletName + "' name couldn't be found in the page group::" + groupId + "::" + pageName + ". No modifications will be applied."));
                return;
            }
            Portlet prefs = (Portlet)this.dataStorageService.load(selectedPortlet.getState(), ApplicationType.PORTLET);
            if (prefs == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("The portlet '" + this.portletName + "' have no ProtletPreferences."));
                }
                prefs = new Portlet();
            }
            for (String preferenceName : this.portletPreferencesInitParams.keySet()) {
                String preferenceValue = (String)this.portletPreferencesInitParams.get((Object)preferenceName);
                if (preferenceValue.contains(GROUP_ID_PREFERENCE)) {
                    preferenceValue = preferenceValue.replace(GROUP_ID_PREFERENCE, groupId);
                }
                if (preferenceValue.contains(MODIFIED_GROUP_ID_PREFERENCE)) {
                    preferenceValue = preferenceValue.replace(MODIFIED_GROUP_ID_PREFERENCE, groupId.replace("/", "."));
                }
                if (preferenceValue.contains(PAGE_NAME_PREFERENCE)) {
                    preferenceValue = preferenceValue.replace(PAGE_NAME_PREFERENCE, pageName);
                }
                prefs.putPreference(new Preference(preferenceName, preferenceValue, false));
            }
            this.dataStorageService.save(selectedPortlet.getState(), (Object)prefs);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"PortletPreferences saved successfully.");
            }
            prefs = (Portlet)this.dataStorageService.load(selectedPortlet.getState(), ApplicationType.PORTLET);
            if (beginRequest) {
                try {
                    this.chromatticManager.endRequest(true);
                }
                catch (Exception exception) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("chromatticManager.endRequest(true) have thrown an exception: " + exception.getMessage()));
                    }
                }
            }
        }
        catch (Exception exception) {
            StringWriter sw = new StringWriter();
            exception.printStackTrace(new PrintWriter(sw));
            LOG.error((Object)sw.toString());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"applicationAdded end ");
        }
    }

    public PageNode getPageNode(String pageNodeName, List<PageNode> pageNodes) {
        if (pageNodeName == null || pageNodes == null || pageNodes.size() == 0) {
            return null;
        }
        for (PageNode pageNode : pageNodes) {
            PageNode tmpPageNode;
            if (pageNode.getName().equals(pageNodeName)) {
                return pageNode;
            }
            if (pageNode.getChildren() == null || pageNode.getChildren().size() <= 0 || (tmpPageNode = this.getPageNode(pageNodeName, pageNode.getChildren())) == null) continue;
            return tmpPageNode;
        }
        return null;
    }

    public Application<Portlet> getPortletApplication(List<ModelObject> children, String pageName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("getPortletApplication(children = " + children + ",pageName =  " + pageName + ")"));
        }
        if (children == null || children.size() == 0) {
            return null;
        }
        for (ModelObject modelObject : children) {
            Application application;
            String portletId;
            Application selectedApplication = null;
            if (modelObject instanceof Container) {
                selectedApplication = this.getPortletApplication(((Container)modelObject).getChildren(), pageName);
            } else if (modelObject instanceof Application && ((Application)modelObject).getType().equals(ApplicationType.PORTLET) && (portletId = this.dataStorageService.getId((application = (Application)modelObject).getState())).endsWith("/" + pageName)) {
                selectedApplication = application;
            }
            if (selectedApplication == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"selectedApplication found");
                LOG.debug((Object)"getPortletApplication end ");
            }
            return selectedApplication;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"return selectedApplication = null");
            LOG.debug((Object)"getPortletApplication end ");
        }
        return null;
    }

    public void applicationDeactivated(SpaceLifeCycleEvent event) {
    }

    public void applicationRemoved(SpaceLifeCycleEvent event) {
    }

    public void grantedLead(SpaceLifeCycleEvent event) {
    }

    public void joined(SpaceLifeCycleEvent event) {
    }

    public void left(SpaceLifeCycleEvent event) {
    }

    public void revokedLead(SpaceLifeCycleEvent event) {
    }

    public void spaceCreated(SpaceLifeCycleEvent event) {
    }

    public void spaceRemoved(SpaceLifeCycleEvent event) {
    }
}

