/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.portal.webui.portal;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exoplatform.portal.account.UIAccountSetting;
import org.exoplatform.portal.application.PortalRequestContext;
import org.exoplatform.portal.config.model.PageNavigation;
import org.exoplatform.portal.config.model.PageNode;
import org.exoplatform.portal.config.model.Properties;
import org.exoplatform.portal.webui.application.UIPortlet;
import org.exoplatform.portal.webui.container.UIContainer;
import org.exoplatform.portal.webui.page.UIPage;
import org.exoplatform.portal.webui.page.UIPageActionListener;
import org.exoplatform.portal.webui.page.UIPageBody;
import org.exoplatform.portal.webui.portal.UIPortalActionListener;
import org.exoplatform.portal.webui.portal.UIPortalComponentActionListener;
import org.exoplatform.portal.webui.portal.UIPortalLifecycle;
import org.exoplatform.portal.webui.util.Util;
import org.exoplatform.portal.webui.workspace.UIMaskWorkspace;
import org.exoplatform.portal.webui.workspace.UIPortalApplication;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleManager;
import org.exoplatform.web.application.JavascriptManager;
import org.exoplatform.web.security.security.AbstractTokenService;
import org.exoplatform.web.security.security.CookieTokenService;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ComponentConfig(lifecycle=UIPortalLifecycle.class, template="system:/groovy/portal/webui/portal/UIPortal.gtmpl", events={@EventConfig(listeners={UIPageActionListener.ChangePageNodeActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeApplicationListActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.MoveChildActionListener.class}), @EventConfig(listeners={ChangeWindowStateActionListener.class}), @EventConfig(listeners={LogoutActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ShowLoginFormActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeLanguageActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.EditPortalPropertiesActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.ChangeSkinActionListener.class}), @EventConfig(listeners={UIPortalComponentActionListener.RecoveryPasswordAndUsernameActionListener.class}), @EventConfig(listeners={AccountSettingsActionListener.class}), @EventConfig(listeners={UIPortalActionListener.PingActionListener.class})})
public class UIPortal
extends UIContainer {
    private String owner;
    private String ownerType;
    private String locale;
    private String editPermission;
    private String skin;
    private Properties properties;
    private PageNavigation navigation;
    private List<PageNode> selectedPath;
    private PageNode selectedNode_;
    private Map<String, UIPage> all_UIPages;
    private Map<String, String[]> publicParameters_ = new HashMap<String, String[]>();
    private UIComponent maximizedUIComponent;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String s) {
        this.owner = s;
    }

    public String getLocale() {
        return this.locale;
    }

    public void setLocale(String s) {
        this.locale = s;
    }

    public String getEditPermission() {
        return this.editPermission;
    }

    public void setEditPermission(String editPermission) {
        this.editPermission = editPermission;
    }

    public String getSkin() {
        return this.skin;
    }

    public void setSkin(String s) {
        this.skin = s;
    }

    public String getOwnerType() {
        return this.ownerType;
    }

    public void setOwnerType(String ownerType) {
        this.ownerType = ownerType;
    }

    public Map<String, String[]> getPublicParameters() {
        return this.publicParameters_;
    }

    public void setPublicParameters(Map<String, String[]> publicParams) {
        this.publicParameters_ = publicParams;
    }

    public List<PageNavigation> getNavigations() throws Exception {
        ArrayList<PageNavigation> listNavs = new ArrayList<PageNavigation>();
        listNavs.add(this.navigation);
        return listNavs;
    }

    public UIPage getUIPage(String pageReference) {
        if (this.all_UIPages == null) {
            this.all_UIPages = new HashMap<String, UIPage>(5);
            return null;
        }
        return this.all_UIPages.get(pageReference);
    }

    public void setUIPage(String pageReference, UIPage uiPage) {
        if (this.all_UIPages == null) {
            this.all_UIPages = new HashMap<String, UIPage>(5);
        }
        this.all_UIPages.put(pageReference, uiPage);
    }

    public void clearUIPage(String pageReference) {
        if (this.all_UIPages != null) {
            this.all_UIPages.remove(pageReference);
        }
    }

    public void setNavigation(PageNavigation _navigation) {
        this.navigation = _navigation;
    }

    public void refreshUIPage() throws Exception {
        UIPageBody uiPageBody;
        if (this.selectedNode_ == null) {
            this.selectedNode_ = (PageNode)this.navigation.getNodes().get(0);
        }
        if ((uiPageBody = (UIPageBody)this.findFirstComponentOfType(UIPageBody.class)) == null) {
            return;
        }
        if (uiPageBody.getMaximizedUIComponent() != null) {
            UIPortlet currentPortlet = (UIPortlet)uiPageBody.getMaximizedUIComponent();
            currentPortlet.setCurrentWindowState(WindowState.NORMAL);
            uiPageBody.setMaximizedUIComponent(null);
        }
        uiPageBody.setPageBody(this.selectedNode_, this);
        Locale locale = Util.getUIPortalApplication().getLocale();
        this.localizePageNavigation(this.navigation, locale);
    }

    public synchronized void setSelectedNode(PageNode node) {
        this.selectedNode_ = node;
    }

    public PageNode getSelectedNode() throws Exception {
        if (this.selectedNode_ != null) {
            return this.selectedNode_;
        }
        if (this.navigation == null || this.navigation.getNodes() == null || this.navigation.getNodes().size() < 1) {
            return null;
        }
        return (PageNode)this.navigation.getNodes().get(0);
    }

    public List<PageNode> getSelectedPath() {
        return this.selectedPath;
    }

    public void setSelectedPath(List<PageNode> nodes) {
        this.selectedPath = nodes;
    }

    public PageNavigation getSelectedNavigation() throws Exception {
        return this.navigation;
    }

    public void setSelectedNavigation(PageNavigation _navigation) {
        this.navigation = _navigation;
    }

    public UIComponent getMaximizedUIComponent() {
        return this.maximizedUIComponent;
    }

    public void setMaximizedUIComponent(UIComponent maximizedReferenceComponent) {
        this.maximizedUIComponent = maximizedReferenceComponent;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties props) {
        this.properties = props;
    }

    public String getProperty(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        if (this.properties == null) {
            return null;
        }
        return (String)this.properties.get((Object)name);
    }

    public String getProperty(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public void setProperty(String name, String value) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        if (value == null) {
            this.properties.remove((Object)name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    public void removeProperty(String name) {
        if (name == null || this.properties == null) {
            throw new NullPointerException();
        }
        this.properties.remove((Object)name);
    }

    public String getSessionAlive() {
        return this.getProperty("sessionAlive", "onDemand");
    }

    public void setSessionAlive(String type) {
        this.setProperty("sessionAlive", type);
    }

    private void localizePageNavigation(PageNavigation nav, Locale locale) {
        ResourceBundleManager mgr = (ResourceBundleManager)this.getApplicationComponent(ResourceBundleManager.class);
        if (nav.getOwnerType().equals("user")) {
            return;
        }
        ResourceBundle res = mgr.getNavigationResourceBundle(locale.getLanguage(), nav.getOwnerType(), nav.getOwnerId());
        for (PageNode node : nav.getNodes()) {
            this.resolveLabel(res, node);
        }
    }

    private void resolveLabel(ResourceBundle res, PageNode node) {
        node.setResolvedLabel(res);
        if (node.getChildren() == null) {
            return;
        }
        for (PageNode childNode : node.getChildren()) {
            this.resolveLabel(res, childNode);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AccountSettingsActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = Util.getUIPortal();
            UIPortalApplication uiApp = (UIPortalApplication)uiPortal.getAncestorOfType(UIPortalApplication.class);
            UIMaskWorkspace uiMaskWS = (UIMaskWorkspace)uiApp.getChildById("UIMaskWorkspace");
            String username = Util.getPortalRequestContext().getRemoteUser();
            OrganizationService service = (OrganizationService)uiPortal.getApplicationComponent(OrganizationService.class);
            User useraccount = service.getUserHandler().findUserByName(username);
            if (useraccount != null) {
                UIAccountSetting uiAccountForm = uiMaskWS.createUIComponent(UIAccountSetting.class, null, null);
                uiMaskWS.setUIComponent((UIComponent)uiAccountForm);
                uiMaskWS.setShow(true);
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiMaskWS);
            } else {
                JavascriptManager jsManager = Util.getPortalRequestContext().getJavascriptManager();
                jsManager.importJavascript((CharSequence)"eXo");
                jsManager.addJavascript((CharSequence)("if(confirm('" + Util.getPortalRequestContext().getApplicationResourceBundle().getString("UIAccountProfiles.msg.NotExistingAccount") + "')) {eXo.portal.logout();}"));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeWindowStateActionListener
    extends EventListener<UIPortal> {
        public void execute(Event<UIPortal> event) throws Exception {
            UIPortal uiPortal = (UIPortal)((Object)event.getSource());
            String portletId = event.getRequestContext().getRequestParameter("portletId");
            UIPortlet uiPortlet = (UIPortlet)uiPortal.findComponentById(portletId);
            WebuiRequestContext context = event.getRequestContext();
            uiPortlet.createEvent("ChangeWindowState", event.getExecutionPhase(), context).broadcast();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LogoutActionListener
    extends EventListener<UIComponent> {
        public void execute(Event<UIComponent> event) throws Exception {
            PortalRequestContext prContext = Util.getPortalRequestContext();
            HttpServletRequest req = prContext.getRequest();
            String token = this.getTokenCookie(req);
            if (token != null) {
                AbstractTokenService tokenService = AbstractTokenService.getInstance(CookieTokenService.class);
                tokenService.deleteToken((Object)token);
            }
            req.getSession().invalidate();
            Cookie cookie = new Cookie("rememberme", "");
            cookie.setPath(req.getContextPath());
            cookie.setMaxAge(0);
            prContext.getResponse().addCookie(cookie);
            String portalName = URLEncoder.encode(prContext.getPortalOwner(), "UTF-8");
            String redirect = req.getContextPath() + "/public/" + portalName + "/";
            prContext.getResponse().sendRedirect(redirect);
            prContext.setResponseComplete(true);
        }

        private String getTokenCookie(HttpServletRequest req) {
            Cookie[] cookies = req.getCookies();
            if (cookies != null) {
                for (Cookie cookie : cookies) {
                    if (!"rememberme".equals(cookie.getName())) continue;
                    return cookie.getValue();
                }
            }
            return null;
        }
    }
}

