/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.wsrp.consumer;

import java.util.Set;
import org.gatein.common.text.TextTools;
import org.gatein.pc.api.ContainerURL;
import org.gatein.pc.api.PortletContext;
import org.gatein.pc.api.URLFormat;
import org.gatein.pc.api.spi.PortletInvocationContext;
import org.gatein.wsrp.WSRPPortletURL;
import org.gatein.wsrp.WSRPResourceURL;
import org.gatein.wsrp.consumer.InvocationHandler;
import org.gatein.wsrp.consumer.ProducerInfo;

public class MarkupProcessor
implements TextTools.StringReplacementGenerator {
    private final PortletInvocationContext context;
    private final URLFormat format;
    private final Set<String> supportedCustomModes;
    private final Set<String> supportedCustomWindowStates;
    private final String namespace;

    protected MarkupProcessor(String namespace, PortletInvocationContext context, PortletContext target, URLFormat format, ProducerInfo info) {
        this.namespace = namespace;
        this.context = context;
        this.format = format;
        this.supportedCustomModes = info.getSupportedCustomModes();
        this.supportedCustomWindowStates = info.getSupportedCustomWindowStates();
    }

    public String getReplacementFor(String match, String prefix, String suffix) {
        if (prefix.equals(match)) {
            return this.namespace;
        }
        if (match.startsWith("?")) {
            match = match.substring("?".length());
            WSRPPortletURL portletURL = WSRPPortletURL.create((String)match, this.supportedCustomModes, this.supportedCustomWindowStates, (boolean)true);
            return this.context.renderURL((ContainerURL)portletURL, this.format);
        }
        return match;
    }

    static String getResourceURL(String urlAsString, WSRPResourceURL resource) {
        String resourceURL = resource.getResourceURL().toExternalForm();
        if (InvocationHandler.log.isDebugEnabled()) {
            InvocationHandler.log.debug("URL '" + urlAsString + "' refers to a resource which are not currently well supported. " + "Attempting to craft a URL that we might be able to work with: '" + resourceURL + "'");
        }
        return resourceURL;
    }
}

