/*
 * Decompiled with CFR 0.152.
 */
package org.gatein.common.i18n;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.gatein.common.i18n.ResourceBundleFactory;

public class SimpleResourceBundleFactory
implements ResourceBundleFactory {
    private String baseName;
    private ClassLoader classLoader;

    public SimpleResourceBundleFactory(String baseName, ClassLoader classLoader) throws IllegalArgumentException {
        if (baseName == null) {
            throw new IllegalArgumentException("No base name provided");
        }
        if (classLoader == null) {
            throw new IllegalArgumentException("No classloader provided");
        }
        this.baseName = baseName;
        this.classLoader = classLoader;
    }

    public ResourceBundle getBundle(Locale locale) throws IllegalArgumentException {
        if (locale == null) {
            throw new IllegalArgumentException("No null locale accepted");
        }
        try {
            return ResourceBundle.getBundle(this.baseName, locale, this.classLoader);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }
}

