/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.commands.write;

import java.util.Collections;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.Fqn;
import org.jboss.cache.InvocationContext;
import org.jboss.cache.NodeSPI;
import org.jboss.cache.commands.Visitor;
import org.jboss.cache.commands.write.AbstractVersionedDataCommand;
import org.jboss.cache.notifications.event.NodeModifiedEvent;
import org.jboss.cache.optimistic.DataVersion;
import org.jboss.cache.transaction.GlobalTransaction;

public class RemoveKeyCommand
extends AbstractVersionedDataCommand {
    public static final int METHOD_ID = 6;
    public static final int VERSIONED_METHOD_ID = 41;
    private static final Log log = LogFactory.getLog(RemoveKeyCommand.class);
    private static final boolean trace = log.isTraceEnabled();
    protected Object key;

    public RemoveKeyCommand(GlobalTransaction gtx, Fqn fqn, Object key) {
        this.globalTransaction = gtx;
        this.fqn = fqn;
        this.key = key;
    }

    public RemoveKeyCommand() {
    }

    public Object perform(InvocationContext ctx) {
        NodeSPI n;
        if (trace) {
            log.trace((Object)("perform(" + this.globalTransaction + ", \"" + this.fqn + "\", key=" + this.key + ")"));
        }
        if ((n = ctx.lookUpNode(this.fqn)) == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("node " + this.fqn + " not found"));
            }
            return null;
        }
        if (this.notifier.shouldNotifyOnNodeModified()) {
            this.notifier.notifyNodeModified(this.fqn, true, NodeModifiedEvent.ModificationType.REMOVE_DATA, n.getDataDirect(), ctx);
        }
        Object oldValue = n.removeDirect(this.key);
        if (this.notifier.shouldNotifyOnNodeModified()) {
            Map removedData = Collections.singletonMap(this.key, oldValue);
            this.notifier.notifyNodeModified(this.fqn, false, NodeModifiedEvent.ModificationType.REMOVE_DATA, removedData, ctx);
        }
        return oldValue;
    }

    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitRemoveKeyCommand(ctx, this);
    }

    public Object getKey() {
        return this.key;
    }

    public void setKey(Object key) {
        this.key = key;
    }

    public int getCommandId() {
        return this.isVersioned() ? 41 : 6;
    }

    public Object[] getParameters() {
        if (this.isVersioned()) {
            return new Object[]{this.globalTransaction, this.fqn, this.key, true, this.dataVersion};
        }
        return new Object[]{this.globalTransaction, this.fqn, this.key, true};
    }

    public void setParameters(int commandId, Object[] args) {
        this.globalTransaction = (GlobalTransaction)args[0];
        this.fqn = (Fqn)args[1];
        this.key = args[2];
        if (this.isVersionedId(commandId)) {
            this.dataVersion = (DataVersion)args[4];
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RemoveKeyCommand that = (RemoveKeyCommand)o;
        if (this.globalTransaction != null ? !this.globalTransaction.equals(that.globalTransaction) : that.globalTransaction != null) {
            return false;
        }
        return !(this.key != null ? !this.key.equals(that.key) : that.key != null);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.globalTransaction != null ? this.globalTransaction.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        return result;
    }

    protected boolean isVersionedId(int id) {
        return id == 41;
    }

    public String toString() {
        return "RemoveKeyCommand{fqn=" + this.fqn + ", dataVersion=" + this.dataVersion + ", globalTransaction=" + this.globalTransaction + ", key=" + this.key + '}';
    }
}

