/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.deploy;

import java.io.Serializable;
import org.apache.catalina.util.RequestUtil;

public class FilterMap
implements Serializable {
    public static final int ERROR = 1;
    public static final int FORWARD = 2;
    public static final int FORWARD_ERROR = 3;
    public static final int INCLUDE = 4;
    public static final int INCLUDE_ERROR = 5;
    public static final int INCLUDE_ERROR_FORWARD = 6;
    public static final int INCLUDE_FORWARD = 7;
    public static final int REQUEST = 8;
    public static final int REQUEST_ERROR = 9;
    public static final int REQUEST_ERROR_FORWARD = 10;
    public static final int REQUEST_ERROR_FORWARD_INCLUDE = 11;
    public static final int REQUEST_ERROR_INCLUDE = 12;
    public static final int REQUEST_FORWARD = 13;
    public static final int REQUEST_INCLUDE = 14;
    public static final int REQUEST_FORWARD_INCLUDE = 15;
    private static final int NOT_SET = -1;
    private int dispatcherMapping = -1;
    private String filterName = null;
    private String[] servletNames = new String[0];
    private boolean matchAllUrlPatterns = false;
    private boolean matchAllServletNames = false;
    private String[] urlPatterns = new String[0];

    public String getFilterName() {
        return this.filterName;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public String[] getServletNames() {
        return this.servletNames;
    }

    public void addServletName(String servletName) {
        if ("*".equals(servletName)) {
            this.matchAllServletNames = true;
        } else {
            String[] results = new String[this.servletNames.length + 1];
            System.arraycopy(this.servletNames, 0, results, 0, this.servletNames.length);
            results[this.servletNames.length] = servletName;
            this.servletNames = results;
        }
    }

    public boolean getMatchAllUrlPatterns() {
        return this.matchAllUrlPatterns;
    }

    public boolean getMatchAllServletNames() {
        return this.matchAllServletNames;
    }

    public String[] getURLPatterns() {
        return this.urlPatterns;
    }

    public void addURLPattern(String urlPattern) {
        if ("*".equals(urlPattern)) {
            this.matchAllUrlPatterns = true;
        } else {
            String[] results = new String[this.urlPatterns.length + 1];
            System.arraycopy(this.urlPatterns, 0, results, 0, this.urlPatterns.length);
            results[this.urlPatterns.length] = RequestUtil.URLDecode(urlPattern);
            this.urlPatterns = results;
        }
    }

    public void setDispatcher(String dispatcherString) {
        String dispatcher = dispatcherString.toUpperCase();
        if (dispatcher.equals("FORWARD")) {
            switch (this.dispatcherMapping) {
                case -1: {
                    this.dispatcherMapping = 2;
                    break;
                }
                case 1: {
                    this.dispatcherMapping = 3;
                    break;
                }
                case 4: {
                    this.dispatcherMapping = 7;
                    break;
                }
                case 5: {
                    this.dispatcherMapping = 6;
                    break;
                }
                case 8: {
                    this.dispatcherMapping = 13;
                    break;
                }
                case 9: {
                    this.dispatcherMapping = 10;
                    break;
                }
                case 12: {
                    this.dispatcherMapping = 11;
                    break;
                }
                case 14: {
                    this.dispatcherMapping = 15;
                }
            }
        } else if (dispatcher.equals("INCLUDE")) {
            switch (this.dispatcherMapping) {
                case -1: {
                    this.dispatcherMapping = 4;
                    break;
                }
                case 1: {
                    this.dispatcherMapping = 5;
                    break;
                }
                case 2: {
                    this.dispatcherMapping = 7;
                    break;
                }
                case 3: {
                    this.dispatcherMapping = 6;
                    break;
                }
                case 8: {
                    this.dispatcherMapping = 14;
                    break;
                }
                case 9: {
                    this.dispatcherMapping = 12;
                    break;
                }
                case 10: {
                    this.dispatcherMapping = 11;
                    break;
                }
                case 13: {
                    this.dispatcherMapping = 15;
                }
            }
        } else if (dispatcher.equals("REQUEST")) {
            switch (this.dispatcherMapping) {
                case -1: {
                    this.dispatcherMapping = 8;
                    break;
                }
                case 1: {
                    this.dispatcherMapping = 9;
                    break;
                }
                case 2: {
                    this.dispatcherMapping = 13;
                    break;
                }
                case 3: {
                    this.dispatcherMapping = 10;
                    break;
                }
                case 4: {
                    this.dispatcherMapping = 14;
                    break;
                }
                case 5: {
                    this.dispatcherMapping = 12;
                    break;
                }
                case 7: {
                    this.dispatcherMapping = 15;
                    break;
                }
                case 6: {
                    this.dispatcherMapping = 11;
                }
            }
        } else if (dispatcher.equals("ERROR")) {
            switch (this.dispatcherMapping) {
                case -1: {
                    this.dispatcherMapping = 1;
                    break;
                }
                case 2: {
                    this.dispatcherMapping = 3;
                    break;
                }
                case 4: {
                    this.dispatcherMapping = 5;
                    break;
                }
                case 7: {
                    this.dispatcherMapping = 6;
                    break;
                }
                case 8: {
                    this.dispatcherMapping = 9;
                    break;
                }
                case 14: {
                    this.dispatcherMapping = 12;
                    break;
                }
                case 13: {
                    this.dispatcherMapping = 10;
                    break;
                }
                case 15: {
                    this.dispatcherMapping = 11;
                }
            }
        }
    }

    public int getDispatcherMapping() {
        if (this.dispatcherMapping == -1) {
            return 8;
        }
        return this.dispatcherMapping;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer("FilterMap[");
        sb.append("filterName=");
        sb.append(this.filterName);
        for (i = 0; i < this.servletNames.length; ++i) {
            sb.append(", servletName=");
            sb.append(this.servletNames[i]);
        }
        for (i = 0; i < this.urlPatterns.length; ++i) {
            sb.append(", urlPattern=");
            sb.append(this.urlPatterns[i]);
        }
        sb.append("]");
        return sb.toString();
    }
}

