/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.impl.calendar;

import java.text.ParseException;
import java.util.Date;
import org.quartz.Calendar;
import org.quartz.CronExpression;
import org.quartz.impl.calendar.BaseCalendar;

public class CronCalendar
extends BaseCalendar {
    static final long serialVersionUID = -8172103999750856831L;
    private String name;
    CronExpression cronExpression;

    public CronCalendar(String name, String expression) throws ParseException {
        this.name = name;
        this.cronExpression = new CronExpression(expression);
    }

    public CronCalendar(String name, Calendar baseCalendar, String expression) throws ParseException {
        super(baseCalendar);
        this.name = name;
        this.cronExpression = new CronExpression(expression);
    }

    public String getName() {
        return this.name;
    }

    public boolean isTimeIncluded(long timeInMillis) {
        if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(timeInMillis)) {
            return false;
        }
        return !this.cronExpression.isSatisfiedBy(new Date(timeInMillis));
    }

    public long getNextIncludedTime(long timeInMillis) {
        long nextIncludedTime = timeInMillis + 1L;
        while (!this.isTimeIncluded(nextIncludedTime)) {
            if (this.cronExpression.isSatisfiedBy(new Date(nextIncludedTime))) {
                nextIncludedTime = this.cronExpression.getNextValidTimeAfter(new Date(nextIncludedTime)).getTime();
                continue;
            }
            if (this.getBaseCalendar() != null && !this.getBaseCalendar().isTimeIncluded(nextIncludedTime)) {
                nextIncludedTime = this.getBaseCalendar().getNextIncludedTime(nextIncludedTime);
                continue;
            }
            ++nextIncludedTime;
        }
        return nextIncludedTime;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(": base calendar: [");
        if (this.getBaseCalendar() != null) {
            buffer.append(this.getBaseCalendar().toString());
        } else {
            buffer.append("null");
        }
        buffer.append("], excluded cron expression: '");
        buffer.append(this.cronExpression);
        buffer.append("'");
        return buffer.toString();
    }

    public CronExpression getCronExpression() {
        return this.cronExpression;
    }

    public void setCronExpression(String expression) throws ParseException {
        CronExpression newExp;
        this.cronExpression = newExp = new CronExpression(expression);
    }

    public void setCronExpression(CronExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException("expression cannot be null");
        }
        this.cronExpression = expression;
    }
}

