/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.cs.ext.impl;

import java.util.Map;
import org.exoplatform.cs.ext.impl.ContactSpaceActivityPublisher;
import org.exoplatform.social.webui.activity.BaseUIActivity;
import org.exoplatform.webui.application.WebuiRequestContext;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="classpath:groovy/cs/social-integration/plugin/space/ContactUIActivity.gtmpl", events={@EventConfig(listeners={BaseUIActivity.ToggleDisplayLikesActionListener.class}), @EventConfig(listeners={BaseUIActivity.ToggleDisplayCommentFormActionListener.class}), @EventConfig(listeners={BaseUIActivity.LikeActivityActionListener.class}), @EventConfig(listeners={BaseUIActivity.SetCommentListStatusActionListener.class}), @EventConfig(listeners={BaseUIActivity.PostCommentActionListener.class}), @EventConfig(listeners={BaseUIActivity.DeleteActivityActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Activity"), @EventConfig(listeners={BaseUIActivity.DeleteCommentActionListener.class}, confirm="UIActivity.msg.Are_You_Sure_To_Delete_This_Comment"), @EventConfig(listeners={MoreContactInfoActionListener.class})})
public class ContactUIActivity
extends BaseUIActivity {
    private boolean isDisplayMoreInfo = false;

    public boolean isDisplayMoreInfo() {
        return this.isDisplayMoreInfo;
    }

    public void setDisplayMoreInfo(boolean isDisplayMoreInfo) {
        this.isDisplayMoreInfo = isDisplayMoreInfo;
    }

    public String getJobTitle() {
        return this.getActivityParamValue(ContactSpaceActivityPublisher.JOB_TITLE_KEY);
    }

    public String getEmail() {
        return this.getActivityParamValue(ContactSpaceActivityPublisher.EMAIL_KEY);
    }

    public String getPhone() {
        return this.getActivityParamValue(ContactSpaceActivityPublisher.PHONE_KEY);
    }

    public boolean isContactAdded() {
        String value = this.getActivityParamValue(ContactSpaceActivityPublisher.ACTIVITY_TYPE);
        if (value == null) {
            return false;
        }
        return value.equalsIgnoreCase(ContactSpaceActivityPublisher.CONTACT_ADD);
    }

    public String getActivityParamValue(String key) {
        String value = null;
        Map params = this.getActivity().getTemplateParams();
        if (params != null) {
            value = (String)params.get(key);
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MoreContactInfoActionListener
    extends EventListener<ContactUIActivity> {
        public void execute(Event<ContactUIActivity> event) throws Exception {
            ContactUIActivity uiComponent = (ContactUIActivity)((Object)event.getSource());
            WebuiRequestContext requestContext = event.getRequestContext();
            boolean display = uiComponent.isDisplayMoreInfo();
            uiComponent.setDisplayMoreInfo(!display);
            requestContext.addUIComponentToUpdateByAjax((UIComponent)uiComponent);
        }
    }
}

