/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.query;

import java.io.IOException;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.RepositoryConfigurationException;
import org.exoplatform.services.jcr.impl.core.query.IndexerChangesFilter;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoMode;
import org.exoplatform.services.jcr.impl.core.query.IndexerIoModeHandler;
import org.exoplatform.services.jcr.impl.core.query.IndexingTree;
import org.exoplatform.services.jcr.impl.core.query.QueryHandler;
import org.exoplatform.services.jcr.impl.core.query.SearchManager;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultChangesFilter
extends IndexerChangesFilter {
    private static final Log log = ExoLogger.getLogger((String)"exo.jcr.component.core.DefaultChangesFilter");

    public DefaultChangesFilter(SearchManager searchManager, SearchManager parentSearchManager, QueryHandlerEntry config, IndexingTree indexingTree, IndexingTree parentIndexingTree, QueryHandler handler, QueryHandler parentHandler, ConfigurationManager cfm) throws IOException, RepositoryConfigurationException, RepositoryException {
        super(searchManager, parentSearchManager, config, indexingTree, parentIndexingTree, handler, parentHandler, cfm);
        IndexerIoModeHandler modeHandler = new IndexerIoModeHandler(IndexerIoMode.READ_WRITE);
        handler.setIndexerIoModeHandler(modeHandler);
        parentHandler.setIndexerIoModeHandler(modeHandler);
        if (!parentHandler.isInitialized()) {
            parentHandler.init();
        }
        if (!handler.isInitialized()) {
            handler.init();
        }
    }

    @Override
    protected void doUpdateIndex(Set<String> removedNodes, Set<String> addedNodes, Set<String> parentRemovedNodes, Set<String> parentAddedNodes) {
        try {
            this.searchManager.updateIndex(removedNodes, addedNodes);
        }
        catch (RepositoryException e) {
            log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error indexing changes " + e), (Throwable)e);
            try {
                this.handler.logErrorChanges(removedNodes, addedNodes);
            }
            catch (IOException ioe) {
                log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
            }
        }
        try {
            this.parentSearchManager.updateIndex(parentRemovedNodes, parentAddedNodes);
        }
        catch (RepositoryException e) {
            log.error((Object)("Error indexing changes " + (Object)((Object)e)), (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)("Error indexing changes " + e), (Throwable)e);
            try {
                this.parentHandler.logErrorChanges(removedNodes, addedNodes);
            }
            catch (IOException ioe) {
                log.warn((Object)("Exception occure when errorLog writed. Error log is not complete. " + ioe), (Throwable)ioe);
            }
        }
    }
}

