/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.configuration;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import org.exoplatform.container.configuration.ConfigurationManager;
import org.exoplatform.container.configuration.ConfigurationUnmarshaller;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.Deserializer;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationManagerImpl
implements ConfigurationManager {
    public static final String WAR_CONF_LOCATION = "/WEB-INF";
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.container.ConfigurationManagerImpl");
    protected Configuration configurations_;
    private ServletContext scontext_;
    private ClassLoader scontextClassLoader_;
    private String contextPath = null;
    private boolean validateSchema = true;
    private final Set<String> profiles;
    private static final ThreadLocal<URL> currentURL = new ThreadLocal();

    public static URL getCurrentURL() {
        return currentURL.get();
    }

    public ConfigurationManagerImpl() {
        this.profiles = Collections.emptySet();
    }

    public ConfigurationManagerImpl(Set<String> profiles) {
        this.profiles = profiles;
    }

    public ConfigurationManagerImpl(ServletContext context, Set<String> profiles) {
        this.scontext_ = context;
        this.profiles = profiles;
    }

    public ConfigurationManagerImpl(ClassLoader loader, Set<String> profiles) {
        this.scontextClassLoader_ = loader;
        this.profiles = profiles;
    }

    @Override
    public Configuration getConfiguration() {
        return this.configurations_;
    }

    public void addConfiguration(ServletContext context, String url) throws Exception {
        if (url == null) {
            return;
        }
        this.addConfiguration(context, this.getURL(context, url));
    }

    @Override
    public void addConfiguration(String url) throws Exception {
        if (url == null) {
            return;
        }
        this.addConfiguration(this.getURL(url));
    }

    @Override
    public void addConfiguration(Collection urls) throws Exception {
        for (URL url : urls) {
            this.addConfiguration(url);
        }
    }

    @Override
    public void addConfiguration(URL url) throws Exception {
        this.addConfiguration(this.scontext_, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfiguration(ServletContext context, URL url) throws Exception {
        if (LOG_DEBUG) {
            log.info((Object)("Add configuration " + url));
        }
        if (url == null) {
            return;
        }
        try {
            this.contextPath = new File(url.toString()).getParent() + "/";
            this.contextPath = this.contextPath.replaceAll("\\\\", "/");
        }
        catch (Exception e) {
            this.contextPath = null;
        }
        if (currentURL.get() != null) {
            throw new IllegalStateException("Would not expect that");
        }
        currentURL.set(url);
        try {
            ConfigurationUnmarshaller unmarshaller = new ConfigurationUnmarshaller(this.profiles);
            Configuration conf = unmarshaller.unmarshall(url);
            if (this.configurations_ == null) {
                this.configurations_ = conf;
            } else {
                this.configurations_.mergeConfiguration(conf);
            }
            List urls = conf.getImports();
            if (urls != null) {
                for (int i = 0; i < urls.size(); ++i) {
                    String uri = (String)urls.get(i);
                    URL urlObject = this.getURL(uri);
                    if (urlObject != null) {
                        if (LOG_DEBUG) {
                            log.info((Object)("\timport " + urlObject));
                        }
                        currentURL.set(urlObject);
                        conf = unmarshaller.unmarshall(urlObject);
                        this.configurations_.mergeConfiguration(conf);
                        continue;
                    }
                    log.warn((Object)("Couldn't process the URL for " + uri + " configuration file ignored "));
                }
            }
        }
        catch (Exception ex) {
            log.error((Object)("Cannot process the configuration " + url), (Throwable)ex);
        }
        finally {
            currentURL.set(null);
        }
    }

    public void processRemoveConfiguration() {
        if (this.configurations_ == null) {
            return;
        }
        List list = this.configurations_.getRemoveConfiguration();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                String type = (String)list.get(i);
                this.configurations_.removeConfiguration(type);
            }
        }
    }

    @Override
    public Component getComponent(String service) {
        return this.configurations_.getComponent(service);
    }

    @Override
    public Component getComponent(Class clazz) throws Exception {
        return this.configurations_.getComponent(clazz.getName());
    }

    @Override
    public Collection getComponents() {
        if (this.configurations_ == null) {
            return null;
        }
        return this.configurations_.getComponents();
    }

    public boolean isValidateSchema() {
        return this.validateSchema;
    }

    public void setValidateSchema(boolean validateSchema) {
        this.validateSchema = validateSchema;
    }

    @Override
    public URL getResource(String url, String defaultURL) throws Exception {
        if (url == null) {
            url = defaultURL;
        }
        return this.getResource(url);
    }

    @Override
    public URL getResource(String uri) throws Exception {
        return this.getURL(uri);
    }

    @Override
    public InputStream getInputStream(String url, String defaultURL) throws Exception {
        if (url == null) {
            url = defaultURL;
        }
        return this.getInputStream(url);
    }

    @Override
    public InputStream getInputStream(String uri) throws Exception {
        URL url = this.getURL(uri);
        if (url == null) {
            throw new IOException("Resource (" + uri + ") could not be found or the invoker doesn't have adequate privileges to get the resource");
        }
        return url.openStream();
    }

    @Override
    public URL getURL(String url) throws Exception {
        return this.getURL(this.scontext_, url);
    }

    private URL getURL(ServletContext context, String url) throws Exception {
        if (url == null) {
            return null;
        }
        if (url.startsWith("jar:")) {
            String path = this.removePrefix("jar:/", url);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (url.startsWith("classpath:")) {
            String path = this.removePrefix("classpath:/", url);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            return cl.getResource(path);
        }
        if (url.startsWith("war:")) {
            String path = this.removePrefix("war:", url);
            if (context != null) {
                return context.getResource(WAR_CONF_LOCATION + path);
            }
            if (this.scontextClassLoader_ != null) {
                if (path.startsWith("/")) {
                    path = path.substring(1);
                }
                return this.scontextClassLoader_.getResource(path);
            }
            throw new Exception("unsupport war uri in this configuration service");
        }
        if (url.startsWith("file:")) {
            url = this.resolveFileURL(url);
            return new URL(url);
        }
        if (url.indexOf(":") < 0 && this.contextPath != null) {
            return new URL(this.contextPath + url.replace('\\', '/'));
        }
        return null;
    }

    private String resolveFileURL(String url) {
        url = Deserializer.resolveVariables(url);
        if (!(url = url.replace('\\', '/')).startsWith("file:///")) {
            url = url.startsWith("file://") ? "file:///" + url.substring(7) : (url.startsWith("file:/") ? "file:///" + url.substring(6) : "file:///" + url.substring(5));
        }
        return url;
    }

    @Override
    public boolean isDefault(String value) {
        return value == null || value.length() == 0 || "default".equals(value);
    }

    protected String removePrefix(String prefix, String url) {
        return url.substring(prefix.length(), url.length());
    }
}

