/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.blocks;

import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jgroups.Channel;
import org.jgroups.blocks.VotingAdapter;
import org.jgroups.blocks.VotingListener;
import org.jgroups.tests.ChannelTestBase;

public class VotingAdapterTest
extends ChannelTestBase {
    private Channel channel1;
    private Channel channel2;
    protected VotingAdapter adapter1;
    protected VotingAdapter adapter2;
    protected TestVoteChannelListener listener1;
    protected TestVoteChannelListener listener2;
    protected TestVoteChannelListener listener3;
    protected TestVoteChannelListener listener4;
    protected static boolean logConfigured = false;

    public VotingAdapterTest(String testName) {
        super(testName);
    }

    public static Test suite() {
        return new TestSuite(VotingAdapterTest.class);
    }

    public void setUp() throws Exception {
        super.setUp();
        this.listener1 = new TestVoteChannelListener(true);
        this.listener2 = new TestVoteChannelListener(true);
        this.listener3 = new TestVoteChannelListener(false);
        this.listener4 = new TestVoteChannelListener(false);
        this.channel1 = this.createChannel("A");
        this.adapter1 = new VotingAdapter(this.channel1);
        this.channel1.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (Exception ex) {
            // empty catch block
        }
        this.channel2 = this.createChannel("A");
        this.adapter2 = new VotingAdapter(this.channel2);
        this.channel2.connect("voting");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void tearDown() throws Exception {
        this.channel2.close();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.channel1.close();
        super.tearDown();
    }

    public void testVoteAll() throws Exception {
        this.adapter1.addVoteListener(this.listener1);
        this.adapter2.addVoteListener(this.listener2);
        boolean voting1 = this.adapter1.vote((Object)"object1", 1, 1000L);
        VotingAdapterTest.assertTrue((String)"Result of voting1 should be 'true'.", (boolean)voting1);
        this.adapter1.addVoteListener(this.listener3);
        boolean voting2 = this.adapter1.vote((Object)"object2", 1, 1000L);
        VotingAdapterTest.assertTrue((String)"Result of voting2 should be 'false'.", (!voting2 ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)VotingAdapterTest.suite());
    }

    public static class TestVoteChannelListener
    implements VotingListener {
        private boolean vote;

        public TestVoteChannelListener(boolean vote) {
            this.vote = vote;
        }

        public boolean vote(Object decree) {
            return this.vote;
        }
    }
}

