/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.tag;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Document;
import org.icepdf.core.pobjects.Page;
import org.icepdf.core.tag.TagState;
import org.icepdf.core.tag.TaggedImage;
import org.icepdf.core.tag.Tagger;
import org.icepdf.core.tag.query.DocumentResult;
import org.icepdf.core.tag.query.Expression;
import org.icepdf.core.tag.query.ParseException;
import org.icepdf.core.tag.query.Querior;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagUtil {
    public static void main(String[] args) {
        if (!Tagger.tagging) {
            System.out.println("PDF tagging not enabled");
            return;
        }
        if (args.length >= 1 && args[0].equals("-catalog")) {
            if (args.length >= 3) {
                TagUtil.catalog(args[1], args[2]);
            } else {
                System.out.println("Need 2 arguments for -catalog option: contentRoot and catalogFile");
            }
        } else if (args.length >= 1 && args[0].equals("-prune")) {
            if (args.length >= 3) {
                TagUtil.prune(args[1], args[2]);
            } else {
                System.out.println("Need 2 arguments for -prune option: oldCatalogFile newCatalogFile");
            }
        } else if (args.length >= 1 && args[0].equals("-tag")) {
            if (args.length >= 3) {
                TagUtil.tag(args[1], args[2]);
            } else {
                System.out.println("Need 2 arguments for -tag option: catalogFile tagFile");
            }
        } else if (args.length >= 1 && args[0].equals("-query")) {
            if (args.length >= 3) {
                String tagFile = args[1];
                String[] rpnQuery = new String[args.length - 2];
                System.arraycopy(args, 2, rpnQuery, 0, args.length - 2);
                TagUtil.query(tagFile, rpnQuery);
            } else {
                System.out.println("Need at least 2 arguments for -query option: tagFile queryArguments...");
                System.out.println("queryArguments is specified in RPN format. Eg: 'and or A B or C D' means (A or B) and (C or D)");
            }
        }
    }

    public static void catalog(String contentRoot, String catalogFile) {
        ObjectOutputStream oos = null;
        try {
            FileOutputStream fos = new FileOutputStream(catalogFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
            oos = new ObjectOutputStream(bos);
        }
        catch (IOException e) {
            System.out.println("Problem openning catalogFile: " + e);
            return;
        }
        ArrayList<File> allFiles = new ArrayList<File>(1024);
        System.out.println("Cataloging list of PDFs...");
        File contentRootFile = new File(contentRoot);
        if (contentRootFile.isDirectory()) {
            TagUtil.recursivelyCatalogPDFs(allFiles, contentRootFile);
        } else if (contentRootFile.isFile()) {
            TagUtil.addFileIfIsPDF(allFiles, contentRootFile);
        }
        allFiles.trimToSize();
        System.out.println("Cataloged " + allFiles.size() + " PDF files");
        try {
            oos.writeObject(allFiles);
            oos.flush();
            oos.close();
        }
        catch (IOException e) {
            System.out.println("Problem saving catalog of PDF files: " + e);
        }
    }

    public static void prune(String oldCatalogFile, String newCatalogFile) {
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("Problem getting SHA-256 digest: " + e);
            return;
        }
        ObjectOutputStream newOutput = null;
        try {
            FileOutputStream fos = new FileOutputStream(newCatalogFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
            newOutput = new ObjectOutputStream(bos);
        }
        catch (IOException e) {
            System.out.println("Problem openning newCatalogFile: " + e);
        }
        ArrayList allFiles = null;
        try {
            FileInputStream fis = new FileInputStream(oldCatalogFile);
            BufferedInputStream bis = new BufferedInputStream(fis, 16384);
            ObjectInputStream ois = new ObjectInputStream(bis);
            allFiles = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            System.out.println("Problem openning oldCatalogFile: " + e);
            return;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Problem reading catalog from [" + oldCatalogFile + "]: " + e);
            return;
        }
        System.out.println("Found " + allFiles.size() + " PDF files to process");
        ArrayList<File> prunedFiles = new ArrayList<File>(Math.max(allFiles.size(), 1));
        HashMap<FileHash, String> hash2path = new HashMap<FileHash, String>(allFiles.size());
        HashMap duplicatePaths = new HashMap();
        byte[] buffer = new byte[8192];
        int numMissing = 0;
        int numDuplicates = 0;
        long then = 0L;
        for (int i = 0; i < allFiles.size(); ++i) {
            File file = (File)allFiles.get(i);
            String path = file.getAbsolutePath();
            long now = System.currentTimeMillis();
            if (now - then >= 5000L) {
                then = now;
                System.out.println("Commencing processing file " + (i + 1) + " of " + allFiles.size());
            }
            if (!file.exists()) {
                System.out.println("Removed non-existant '" + path + "'");
                ++numMissing;
                continue;
            }
            try {
                int read;
                FileInputStream fis = new FileInputStream(file);
                digest.reset();
                while ((read = fis.read(buffer)) >= 0) {
                    digest.update(buffer, 0, read);
                }
                fis.close();
            }
            catch (IOException e) {
                System.out.println("Problem hashing '" + path + "' : " + e);
            }
            FileHash fh = new FileHash(digest.digest(), file.length());
            String originalPath = (String)hash2path.get(fh);
            if (originalPath == null) {
                hash2path.put(fh, path);
                prunedFiles.add(file);
                continue;
            }
            ArrayList<DuplicateEntry> duplicates = (ArrayList<DuplicateEntry>)duplicatePaths.get(originalPath);
            if (duplicates == null) {
                duplicates = new ArrayList<DuplicateEntry>();
                duplicatePaths.put(originalPath, duplicates);
            }
            DuplicateEntry de = new DuplicateEntry(originalPath, path, i);
            duplicates.add(de);
            ++numDuplicates;
        }
        prunedFiles.trimToSize();
        System.out.println("Finished processing " + allFiles.size() + " PDF files. Found " + numDuplicates + " duplicates, and " + numMissing + " missing.");
        for (File file : prunedFiles) {
            System.out.println(file.getAbsolutePath());
        }
        try {
            newOutput.writeObject(prunedFiles);
            newOutput.flush();
            newOutput.close();
        }
        catch (IOException e) {
            System.out.println("Problem saving newCatalogFile: " + e);
        }
    }

    public static void tag(String catalogFile, String tagFile) {
        ObjectOutputStream tagOutput = null;
        try {
            FileOutputStream fos = new FileOutputStream(tagFile);
            BufferedOutputStream bos = new BufferedOutputStream(fos, 16384);
            tagOutput = new ObjectOutputStream(bos);
        }
        catch (IOException e) {
            System.out.println("Problem openning tagFile: " + e);
        }
        ArrayList allFiles = null;
        try {
            FileInputStream fis = new FileInputStream(catalogFile);
            BufferedInputStream bis = new BufferedInputStream(fis, 16384);
            ObjectInputStream ois = new ObjectInputStream(bis);
            allFiles = (ArrayList)ois.readObject();
            ois.close();
        }
        catch (IOException e) {
            System.out.println("Problem openning catalogFile: " + e);
            return;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Problem reading catalog from [" + catalogFile + "]: " + e);
            return;
        }
        System.out.println("Found " + allFiles.size() + " PDF files to tag");
        long then = 0L;
        for (int i = 0; i < allFiles.size(); ++i) {
            File file = (File)allFiles.get(i);
            String path = file.getAbsolutePath();
            long now = System.currentTimeMillis();
            if (now - then >= 5000L) {
                then = now;
                System.out.println("Commencing tagging file " + (i + 1) + " of " + allFiles.size());
                System.out.println(path);
            }
            TagUtil.tagPdf(path);
            System.out.println("Used memory: " + (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
        }
        System.out.println("Finished tagging " + allFiles.size() + " PDF files");
        try {
            TagState state = Tagger.getTagState();
            tagOutput.writeObject(state);
            tagOutput.flush();
            tagOutput.close();
        }
        catch (IOException e) {
            System.out.println("Problem saving tags: " + e);
        }
    }

    public static void query(String tagFile, String[] rpnQuery) {
        Expression expression = null;
        try {
            expression = Querior.parse(rpnQuery);
        }
        catch (ParseException e) {
            System.out.println("Problem parsing expression: " + e);
            return;
        }
        if (expression == null) {
            return;
        }
        TagState state = null;
        try {
            FileInputStream fis = new FileInputStream(tagFile);
            BufferedInputStream bis = new BufferedInputStream(fis, 16384);
            ObjectInputStream tagInput = new ObjectInputStream(bis);
            state = (TagState)tagInput.readObject();
            tagInput.close();
        }
        catch (IOException e) {
            System.out.println("Problem reading from tagFile: " + e);
            e.printStackTrace();
            return;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Problem reading TagState from tagFile: " + e);
            return;
        }
        List documentResults = Querior.search(state, expression);
        if (documentResults == null || documentResults.size() == 0) {
            System.out.println("No results");
            return;
        }
        for (int i = 0; i < documentResults.size(); ++i) {
            DocumentResult docRes = (DocumentResult)documentResults.get(i);
            System.out.println(docRes.getDocument().getOrigin());
            List images = docRes.getImages();
            System.out.println("  Matching images: " + images.size());
            for (int j = 0; j < images.size(); ++j) {
                TaggedImage ti = (TaggedImage)images.get(j);
                System.out.println("  Image: " + (ti.getReference() != null ? ti.getReference().toString() : "<unreferenced>") + "  Inline: " + ti.isInlineImage() + "  Pages: " + ti.describePages());
            }
        }
    }

    private static void recursivelyCatalogPDFs(ArrayList<File> allFiles, File directory) {
        File[] children = directory.listFiles();
        if (children != null && children.length > 0) {
            int i;
            ArrayList<File> directories = new ArrayList<File>(children.length);
            ArrayList<File> files = new ArrayList<File>(children.length);
            for (i = 0; i < children.length; ++i) {
                if (children[i].isDirectory()) {
                    String name = children[i].getName();
                    if (name.startsWith(".")) continue;
                    directories.add(children[i]);
                    continue;
                }
                if (!children[i].isFile()) continue;
                TagUtil.addFileIfIsPDF(files, children[i]);
            }
            Collections.sort(directories);
            Collections.sort(files);
            for (i = 0; i < directories.size(); ++i) {
                TagUtil.recursivelyCatalogPDFs(allFiles, (File)directories.get(i));
            }
            allFiles.addAll(files);
        }
    }

    private static void addFileIfIsPDF(List<File> list, File file) {
        if (file.getName().toLowerCase().endsWith(".pdf")) {
            list.add(file);
        }
    }

    private static void tagPdf(String path) {
        Document pdfDoc = new Document();
        try {
            pdfDoc.setFile(path);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (Tagger.tagging) {
            Tagger.setCurrentDocument(pdfDoc);
        }
        int numberOfPages = pdfDoc.getNumberOfPages();
        for (int pageNumber = 0; pageNumber < numberOfPages; ++pageNumber) {
            Page page;
            if (Tagger.tagging) {
                Tagger.setCurrentPageIndex(pageNumber);
            }
            if ((page = pdfDoc.getPageTree().getPage(pageNumber, TagUtil.class)) == null) continue;
            page.init();
            pdfDoc.getPageTree().releasePage(page, TagUtil.class);
            try {
                Thread.sleep(20L);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        pdfDoc.dispose();
    }

    private static class DuplicateEntry {
        String originalPath;
        String duplicatePath;
        int duplicateIndex;

        DuplicateEntry(String originalPath, String duplicatePath, int duplicateIndex) {
            this.originalPath = originalPath;
            this.duplicatePath = duplicatePath;
            this.duplicateIndex = duplicateIndex;
        }
    }

    private static class FileHash {
        private byte[] digestBytes;
        private long fileLength;
        private int hash;

        FileHash(byte[] digestBytes, long fileLength) {
            this.digestBytes = digestBytes;
            this.fileLength = fileLength;
            this.hash = (int)(fileLength ^ fileLength >> 32);
            for (int i = digestBytes.length - 1; i >= 0; --i) {
                this.hash = 31 * this.hash + digestBytes[i];
            }
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object other) {
            if (other instanceof FileHash) {
                FileHash fh = (FileHash)other;
                if (this.hash != fh.hash || this.fileLength != fh.fileLength) {
                    return false;
                }
                if (this.digestBytes.length != fh.digestBytes.length) {
                    return false;
                }
                for (int i = this.digestBytes.length - 1; i >= 0; --i) {
                    if (this.digestBytes[i] == fh.digestBytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    }
}

