/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.swing.event;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.swing.event.Event;
import org.exoplatform.swing.event.EventListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventManager {
    private static EventManager singleton_ = new EventManager();
    private Map<String, List<EventListener>> listeners_ = new HashMap<String, List<EventListener>>();

    public void addEventListener(EventListener listener) {
        List<EventListener> listeners = this.listeners_.get(listener.getListenedEventName());
        if (listeners == null) {
            listeners = new ArrayList<EventListener>();
            this.listeners_.put(listener.getListenedEventName(), listeners);
        }
        listeners.add(listener);
    }

    public List<EventListener> getEventListeners(String listenedEventName) {
        return this.listeners_.get(listenedEventName);
    }

    public <S, D> void broadcast(Event<S, D> event) throws Exception {
        List<EventListener> listeners = this.listeners_.get(event.getEventName());
        if (listeners != null) {
            for (EventListener listener : listeners) {
                listener.onEvent(event);
            }
        }
    }

    public <S, D> void broadcast(String eventName, S source, D data) throws Exception {
        List<EventListener> listeners = this.listeners_.get(eventName);
        if (listeners != null) {
            Event<S, D> event = new Event<S, D>(eventName, source, data);
            for (EventListener listener : listeners) {
                listener.onEvent(event);
            }
        }
    }

    public static EventManager getInstance() {
        return singleton_;
    }
}

