/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index.merge;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.merge.DocumentCountAggregatePolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModificationTimeAggregatePolicy
extends DocumentCountAggregatePolicy {
    public static final int DEFAULT_MIN_MODIFACATION_TIME = 10000;
    public static final int DEFAULT_MAX_MODIFACATION_TIME = Integer.MAX_VALUE;
    private int minModificationTime = 10000;
    private int maxModificationTime = Integer.MAX_VALUE;
    private static final Log LOG = ExoLogger.getLogger(ModificationTimeAggregatePolicy.class);

    public int getMinModificationTime() {
        return this.minModificationTime;
    }

    public void setMinModificationTime(int minModificationTime) {
        this.minModificationTime = minModificationTime;
    }

    @Override
    public Collection<LuceneIndexDataManager> findIndexDataManagerToAggrigate(Collection<LuceneIndexDataManager> aggregateCandidat, long requiredCandidatCount, long reguiredTotalCandidatSize) {
        ArrayList<LuceneIndexDataManager> ready2aggregate = new ArrayList<LuceneIndexDataManager>();
        if (requiredCandidatCount == 0L && reguiredTotalCandidatSize == 0L) {
            for (LuceneIndexDataManager luceneIndexDataManager : aggregateCandidat) {
                long timeSinceLastCheck = System.currentTimeMillis() - luceneIndexDataManager.getLastModifedTime();
                if ((long)this.minModificationTime >= timeSinceLastCheck || timeSinceLastCheck >= (long)this.maxModificationTime) continue;
                ready2aggregate.add(luceneIndexDataManager);
            }
        } else if ((double)requiredCandidatCount * 1.3 < (double)aggregateCandidat.size()) {
            LuceneIndexDataManager[] indexes = new LuceneIndexDataManager[aggregateCandidat.size()];
            aggregateCandidat.toArray(indexes);
            Arrays.sort(indexes, new ModifficationTimeComparator());
            long variants = Math.round((double)requiredCandidatCount * 1.3);
            int i = 0;
            while ((long)i < variants) {
                ready2aggregate.add(indexes[i]);
                ++i;
            }
        } else {
            ready2aggregate.addAll(aggregateCandidat);
        }
        return super.findIndexDataManagerToAggrigate(ready2aggregate, requiredCandidatCount, reguiredTotalCandidatSize);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModifficationTimeComparator
    implements Comparator<LuceneIndexDataManager> {
        private ModifficationTimeComparator() {
        }

        @Override
        public int compare(LuceneIndexDataManager o1, LuceneIndexDataManager o2) {
            return (int)(o1.getLastModifedTime() - o2.getLastModifedTime());
        }
    }
}

