/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.util.jdbc.cleaner;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleanHelper;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.DBCleanerException;
import org.exoplatform.services.jcr.impl.util.jdbc.cleaner.WorkspaceDBCleaner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleDBCleaner
extends WorkspaceDBCleaner {
    protected final List<String> commonSingleDBCleanScripts = new ArrayList<String>();
    protected final boolean postHelpClean;
    protected final DBCleanHelper dbCleanHelper;

    public SingleDBCleaner(WorkspaceEntry wsEntry, Connection connection) {
        this(wsEntry, connection, false);
    }

    public SingleDBCleaner(WorkspaceEntry wsEntry, Connection connection, boolean postHelpClean) {
        super(wsEntry, connection);
        this.postHelpClean = postHelpClean;
        this.dbCleanHelper = new DBCleanHelper(this.containerName, connection);
        this.commonSingleDBCleanScripts.add("delete from JCR_SVALUE where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SVALUE.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
        this.commonSingleDBCleanScripts.add("delete from JCR_SREF where exists(select * from JCR_SITEM where JCR_SITEM.ID=JCR_SREF.PROPERTY_ID and JCR_SITEM.CONTAINER_NAME='" + this.containerName + "')");
        this.commonSingleDBCleanScripts.addAll(this.commonDBCleanScripts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clean() throws DBCleanerException {
        try {
            super.clean();
            if (this.postHelpClean) {
                this.dbCleanHelper.clean();
            }
            Object var2_1 = null;
            super.closeConnection();
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            super.closeConnection();
            throw throwable;
        }
    }

    @Override
    protected void closeConnection() {
    }

    @Override
    protected List<String> getDBCleanScripts() {
        ArrayList<String> scripts = new ArrayList<String>(this.commonSingleDBCleanScripts);
        scripts.add("delete from JCR_SITEM where CONTAINER_NAME='" + this.containerName + "'");
        return scripts;
    }
}

