/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup.impl.fs;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Calendar;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.impl.AbstractFullBackupJob;
import org.exoplatform.services.jcr.ext.backup.impl.FileNameProducer;
import org.exoplatform.services.jcr.impl.core.SessionImpl;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

public class FullBackupJob
extends AbstractFullBackupJob {
    protected static Log log = ExoLogger.getLogger("exo.jcr.component.ext.FullBackupJob");
    private String pathBackupFile;

    protected URL createStorage() throws FileNotFoundException, IOException {
        FileNameProducer fnp = new FileNameProducer(this.config.getRepository(), this.config.getWorkspace(), this.config.getBackupDir().getAbsolutePath(), this.timeStamp, true);
        return new URL("file:" + fnp.getNextFile().getAbsolutePath());
    }

    public void init(ManageableRepository repository, String workspaceName, BackupConfig config, Calendar timeStamp) {
        this.repository = repository;
        this.workspaceName = workspaceName;
        this.config = config;
        this.timeStamp = timeStamp;
        try {
            this.url = this.createStorage();
        }
        catch (FileNotFoundException e) {
            log.error("Full backup initialization failed ", e);
            this.notifyError("Full backup initialization failed ", e);
        }
        catch (IOException e) {
            log.error("Full backup initialization failed ", e);
            this.notifyError("Full backup initialization failed ", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.pathBackupFile = this.getStorageURL().getFile();
            SessionImpl session = (SessionImpl)this.repository.getSystemSession(this.workspaceName);
            try {
                this.notifyListeners();
                FileOutputStream fos = new FileOutputStream(this.pathBackupFile);
                session.exportWorkspaceSystemView((OutputStream)fos, false, false);
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                session.logout();
                throw throwable;
            }
            session.logout();
            {
            }
        }
        catch (RepositoryException e) {
            log.error("Full backup failed " + this.getStorageURL().getPath(), e);
            this.notifyError("Full backup failed", e);
        }
        catch (IOException e) {
            log.error("Full backup failed " + this.getStorageURL().getPath(), e);
            this.notifyError("Full backup failed", e);
        }
        this.state = 4;
        this.notifyListeners();
    }

    public void stop() {
        log.info("Stop requested " + this.getStorageURL().getPath());
    }
}

