/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.services.listener.Event;
import org.exoplatform.services.listener.Listener;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListenerService {
    private final Map<String, List<Listener>> listeners_ = new HashMap<String, List<Listener>>();
    private static final Log log = ExoLogger.getLogger((String)"exo.kernel.component.common.ListenerService");

    public void addListener(Listener listener) {
        this.addListener(listener.getName(), listener);
    }

    public void addListener(String eventName, Listener listener) {
        List<Listener> list = this.listeners_.get(eventName);
        if (list == null) {
            list = new ArrayList<Listener>();
            this.listeners_.put(eventName, list);
        }
        list.add(listener);
    }

    public final <S, D> void broadcast(String name, S source, D data) throws Exception {
        List<Listener> list = this.listeners_.get(name);
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("broadcasting event " + name + " on " + listener.getName()));
            }
            listener.onEvent(new Event<S, D>(name, source, data));
        }
    }

    public final <T extends Event> void broadcast(T event) throws Exception {
        List<Listener> list = this.listeners_.get(event.getEventName());
        if (list == null) {
            return;
        }
        for (Listener listener : list) {
            listener.onEvent(event);
        }
    }
}

