/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.impl.core.itemfilters;

import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.jcr.Item;
import javax.jcr.RepositoryException;
import org.exoplatform.services.jcr.impl.core.itemfilters.ItemFilter;

public class NamePatternFilter
implements ItemFilter {
    private ArrayList expressions = new ArrayList();

    public NamePatternFilter(String namePattern) {
        StringTokenizer parser = new StringTokenizer(namePattern, "|");
        while (parser.hasMoreTokens()) {
            String token = parser.nextToken();
            this.expressions.add(token.trim());
        }
    }

    public boolean accept(Item item) throws RepositoryException {
        String name = item.getName();
        for (int i = 0; i < this.expressions.size(); ++i) {
            String expr = (String)this.expressions.get(i);
            if (!this.estimate(name, expr)) continue;
            return true;
        }
        return false;
    }

    private boolean estimate(String name, String expr) {
        if (expr.indexOf("*") == -1) {
            return name.equals(expr);
        }
        String regexp = expr.replaceAll("\\*", ".*");
        return Pattern.compile(regexp).matcher(name).matches();
    }
}

