/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.contact.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.exoplatform.contact.service.Contact;
import org.exoplatform.contact.service.JCRPageList;
import org.exoplatform.contact.service.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataPageList
extends JCRPageList {
    private List<Contact> contactList_ = null;
    private boolean isQuery_ = false;
    private String value_;

    public DataPageList(List<Contact> contactList, long pageSize, String value, boolean isQuery) throws Exception {
        super(pageSize);
        this.contactList_ = contactList;
        Collections.sort(this.contactList_, new FullNameComparator());
        this.value_ = value;
        this.isQuery_ = isQuery;
        this.setAvailablePage(this.contactList_.size());
    }

    @Override
    protected void populateCurrentPage(long page, String username) throws Exception {
        this.setAvailablePage(this.contactList_.size());
        long pageSize = this.getPageSize();
        long position = 0L;
        position = page == 1L ? 0L : (page - 1L) * pageSize;
        this.currentListPage_ = new ArrayList();
        Long objPos = position;
        if (position + pageSize > (long)this.contactList_.size()) {
            this.currentListPage_ = this.contactList_.subList(objPos.intValue(), this.contactList_.size());
        } else {
            Long objPageSize = pageSize;
            this.currentListPage_ = this.contactList_.subList(objPos.intValue(), objPos.intValue() + objPageSize.intValue());
        }
    }

    @Override
    public List<Contact> getAll() throws Exception {
        return this.contactList_;
    }

    @Override
    public void setList(List<Contact> contacts) {
        this.contactList_ = contacts;
    }

    public static class FullNameComparator
    implements Comparator {
        public int compare(Object o1, Object o2) throws ClassCastException {
            String name1 = ((Contact)o1).getFullName();
            String name2 = ((Contact)o2).getFullName();
            if (Utils.isEmpty(name1) || Utils.isEmpty(name2)) {
                return 0;
            }
            return name1.compareTo(name2);
        }
    }
}

