/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ide.shindig.oauth;

import java.io.File;
import java.io.IOException;
import org.apache.shindig.auth.BlobCrypterSecurityToken;
import org.apache.shindig.common.crypto.BasicBlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypter;
import org.apache.shindig.common.crypto.BlobCrypterException;
import org.exoplatform.ide.shindig.oauth.TokenRequest;
import org.exoplatform.ide.shindig.oauth.TokenResponse;

public class SecurityTokenGenerator {
    public static TokenResponse createToken(TokenRequest tokenRequest, String keyFile) throws IOException, BlobCrypterException {
        BasicBlobCrypter crypter = new BasicBlobCrypter(new File(keyFile));
        BlobCrypterSecurityToken t = new BlobCrypterSecurityToken((BlobCrypter)crypter, tokenRequest.getContainer(), null);
        t.setAppUrl(tokenRequest.getGadgetURL());
        t.setModuleId(tokenRequest.getModuleId().longValue());
        t.setOwnerId(tokenRequest.getOwner());
        t.setViewerId(tokenRequest.getViewer());
        t.setTrustedJson("trusted");
        String securityToken = t.encrypt();
        TokenResponse tokenResponse = new TokenResponse(securityToken, tokenRequest.getGadgetURL(), tokenRequest.getModuleId());
        return tokenResponse;
    }
}

