/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.services.jcr.ext.backup;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.exoplatform.services.jcr.config.RepositoryEntry;
import org.exoplatform.services.jcr.config.RepositoryServiceConfiguration;
import org.exoplatform.services.jcr.ext.backup.BackupConfig;
import org.exoplatform.services.jcr.ext.backup.BackupOperationException;
import org.exoplatform.services.jcr.ext.backup.RepositoryBackupConfig;
import org.exoplatform.services.jcr.ext.backup.RepositoryChainLogPathHelper;
import org.exoplatform.services.jcr.ext.backup.server.RepositoryRestoreExeption;
import org.exoplatform.services.jcr.impl.util.JCRDateFormat;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.ws.frameworks.json.JsonHandler;
import org.exoplatform.ws.frameworks.json.impl.BeanBuilder;
import org.exoplatform.ws.frameworks.json.impl.JsonDefaultHandler;
import org.exoplatform.ws.frameworks.json.impl.JsonParserImpl;
import org.exoplatform.ws.frameworks.json.value.JsonValue;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IMarshallingContext;
import org.jibx.runtime.IUnmarshallingContext;
import org.jibx.runtime.JiBXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryBackupChainLog {
    protected static Log logger = ExoLogger.getLogger("exo.jcr.component.ext.BackupChainLog");
    protected static String VERSION_LOG_1_1 = "1.1";
    public static final String PREFIX = "repository-backup-";
    private static final String SUFFIX = ".xml";
    private File log;
    private LogWriter logWriter;
    private LogReader logReader;
    private RepositoryBackupConfig config;
    private String backupId;
    private Calendar startedTime;
    private Calendar finishedTime;
    private boolean finalized;
    private List<String> workspaceBackupsInfo;
    private String workspaceSystem;
    private String fullBackupType;
    private String increnetalBackupType;
    private RepositoryEntry originalRepositoryEntry;
    private final String versionLog;

    public RepositoryBackupChainLog(File logDirectory, RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType, String systemWorkspace, List<String> wsLogFilePathList, String backupId, Calendar startTime, RepositoryEntry rEntry, RepositoryServiceConfiguration repositoryServiceConfiguration) throws BackupOperationException {
        try {
            this.finalized = false;
            this.versionLog = VERSION_LOG_1_1;
            this.log = new File(logDirectory.getCanonicalPath() + File.separator + PREFIX + backupId + SUFFIX);
            this.log.createNewFile();
            this.backupId = backupId;
            this.config = config;
            this.startedTime = Calendar.getInstance();
            this.fullBackupType = fullBackupType;
            this.increnetalBackupType = incrementalBackupType;
            this.originalRepositoryEntry = rEntry;
            this.logWriter = new LogWriter(this.log);
            this.logWriter.write(config, fullBackupType, incrementalBackupType);
            this.logWriter.writeSystemWorkspaceName(systemWorkspace);
            this.logWriter.writeBackupsPath(wsLogFilePathList, config);
            this.logWriter.writeRepositoryEntry(rEntry, repositoryServiceConfiguration);
            this.workspaceBackupsInfo = wsLogFilePathList;
            this.workspaceSystem = systemWorkspace;
        }
        catch (IOException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (FactoryConfigurationError e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
        catch (JiBXException e) {
            throw new BackupOperationException("Can not create backup log ...", e);
        }
    }

    public RepositoryBackupChainLog(File log) throws BackupOperationException {
        this.log = log;
        this.backupId = log.getName().replaceAll(PREFIX, "").replaceAll(SUFFIX, "");
        try {
            this.logReader = new LogReader(log);
            this.logReader.readLogFile();
            this.versionLog = this.logReader.getVersionLog();
        }
        catch (FileNotFoundException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (XMLStreamException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
        catch (Exception e) {
            throw new BackupOperationException("Can not read RepositoryBackupChainLog from file :" + log.getAbsolutePath(), e);
        }
    }

    public String getLogFilePath() {
        return this.log.getAbsolutePath();
    }

    public RepositoryBackupConfig getBackupConfig() {
        return this.config;
    }

    public Calendar getStartedTime() {
        return this.startedTime;
    }

    public Calendar getFinishedTime() {
        return this.finishedTime;
    }

    public boolean isFinilized() {
        return this.finalized;
    }

    public synchronized void endLog() {
        if (!this.finalized) {
            this.finishedTime = Calendar.getInstance();
            this.finalized = true;
            this.logWriter.writeEndLog();
            try {
                FileInputStream in = new FileInputStream(this.log);
                File dest = new File(this.config.getBackupDir() + File.separator + this.log.getName());
                if (!dest.exists()) {
                    FileOutputStream out = new FileOutputStream(dest);
                    byte[] buf = new byte[(int)this.log.length()];
                    ((InputStream)in).read(buf);
                    String sConfig = new String(buf, "UTF-8");
                    sConfig = sConfig.replaceAll("<backup-dir>.+</backup-dir>", "<backup-dir>.</backup-dir>");
                    ((OutputStream)out).write(sConfig.getBytes("UTF-8"));
                    ((InputStream)in).close();
                    ((OutputStream)out).close();
                }
            }
            catch (Exception e) {
                logger.error("Can't write log", e);
            }
        }
    }

    public String getSystemWorkspace() {
        return this.workspaceSystem;
    }

    public List<String> getWorkspaceBackupsInfo() {
        return this.workspaceBackupsInfo;
    }

    public String getBackupId() {
        return this.backupId;
    }

    public RepositoryEntry getOriginalRepositoryEntry() {
        return this.originalRepositoryEntry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogReader {
        protected Log logger = ExoLogger.getLogger("exo.jcr.component.ext.LogReader");
        private File logFile;
        private XMLStreamReader reader;
        private String version;

        public LogReader(File logFile) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = logFile;
            this.reader = XMLInputFactory.newInstance().createXMLStreamReader(new FileInputStream(logFile), "UTF-8");
        }

        public void readLogFile() throws UnsupportedEncodingException, Exception {
            boolean endDocument = false;
            while (!endDocument) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("repository-backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("system-workspace")) {
                            RepositoryBackupChainLog.this.workspaceSystem = this.readContent();
                        }
                        if (name.equals("backup-config")) {
                            RepositoryBackupChainLog.this.config = this.readBackupConfig();
                        }
                        if (name.equals("workspaces-backup-info")) {
                            RepositoryBackupChainLog.this.workspaceBackupsInfo = this.readWorkspaceBackupInfo();
                        }
                        if (name.equals("start-time")) {
                            RepositoryBackupChainLog.this.startedTime = JCRDateFormat.parse((String)this.readContent());
                        }
                        if (name.equals("finish-time")) {
                            RepositoryBackupChainLog.this.finishedTime = JCRDateFormat.parse((String)this.readContent());
                        }
                        if (name.equals("original-repository-config")) {
                            RepositoryBackupChainLog.this.originalRepositoryEntry = this.readRepositoryEntry();
                        }
                        if (!name.equals("version-log")) break;
                        this.version = this.readContent();
                        break;
                    }
                    case 8: {
                        endDocument = true;
                    }
                }
            }
        }

        private RepositoryEntry readRepositoryEntry() throws UnsupportedEncodingException, Exception {
            String configName = this.readContent();
            File configFile = new File(RepositoryBackupChainLog.this.getBackupConfig().getBackupDir().getCanonicalPath() + File.separator + configName);
            if (!configFile.exists()) {
                throw new RepositoryRestoreExeption("The backup set is not contains original repositpry configuration : " + RepositoryBackupChainLog.this.getBackupConfig().getBackupDir().getCanonicalPath());
            }
            IBindingFactory factory = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IUnmarshallingContext uctx = factory.createUnmarshallingContext();
            RepositoryServiceConfiguration conf = (RepositoryServiceConfiguration)uctx.unmarshalDocument((InputStream)new FileInputStream(configFile), null);
            if (conf.getRepositoryConfigurations().size() != 1) {
                throw new RepositoryRestoreExeption("The oririginal configuration should be contains only one repository entry :" + configFile.getCanonicalPath());
            }
            if (!conf.getRepositoryConfiguration(RepositoryBackupChainLog.this.getBackupConfig().getRepository()).getName().equals(RepositoryBackupChainLog.this.getBackupConfig().getRepository())) {
                throw new RepositoryRestoreExeption("The oririginal configuration should be contains only one repository entry with name \"" + RepositoryBackupChainLog.this.getBackupConfig().getRepository() + "\" :" + configFile.getCanonicalPath());
            }
            return conf.getRepositoryConfiguration(RepositoryBackupChainLog.this.getBackupConfig().getRepository());
        }

        private Object getObject(Class cl, byte[] data) throws Exception {
            JsonDefaultHandler jsonHandler = new JsonDefaultHandler();
            JsonParserImpl jsonParser = new JsonParserImpl();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(data);
            jsonParser.parse((InputStream)inputStream, (JsonHandler)jsonHandler);
            JsonValue jsonValue = jsonHandler.getJsonObject();
            return new BeanBuilder().createObject(cl, jsonValue);
        }

        private List<String> readWorkspaceBackupInfo() throws XMLStreamException, IOException {
            ArrayList<String> wsBackupInfo = new ArrayList<String>();
            boolean endWorkspaceBackupInfo = false;
            while (!endWorkspaceBackupInfo) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (!name.equals("url")) break;
                        if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                            String path = this.readContent();
                            wsBackupInfo.add(RepositoryChainLogPathHelper.getPath(path, RepositoryBackupChainLog.this.config.getBackupDir().getCanonicalPath()));
                            break;
                        }
                        wsBackupInfo.add(this.readContent());
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("workspaces-backup-info")) break;
                        endWorkspaceBackupInfo = true;
                    }
                }
            }
            return wsBackupInfo;
        }

        private BackupConfig readBackupConfig() throws XMLStreamException, IOException {
            BackupConfig conf = new BackupConfig();
            boolean endBackupConfig = false;
            while (!endBackupConfig) {
                int eventCode = this.reader.next();
                switch (eventCode) {
                    case 1: {
                        String name = this.reader.getLocalName();
                        if (name.equals("backup-dir")) {
                            if (this.version != null && this.version.equals(VERSION_LOG_1_1)) {
                                String dir = this.readContent();
                                if (dir.equals(".")) {
                                    String path = this.logFile.getParentFile().getCanonicalPath();
                                    conf.setBackupDir(new File(path));
                                } else {
                                    conf.setBackupDir(new File(dir));
                                }
                            } else {
                                conf.setBackupDir(new File(this.readContent()));
                            }
                        }
                        if (name.equals("backup-type")) {
                            conf.setBackupType(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("repository")) {
                            conf.setRepository(this.readContent());
                        }
                        if (name.equals("workspace")) {
                            conf.setWorkspace(this.readContent());
                        }
                        if (name.equals("incremental-job-period")) {
                            conf.setIncrementalJobPeriod(Long.valueOf(this.readContent()));
                        }
                        if (name.equals("incremental-job-number")) {
                            conf.setIncrementalJobNumber(Integer.valueOf(this.readContent()));
                        }
                        if (name.equals("full-backup-type")) {
                            RepositoryBackupChainLog.this.fullBackupType = this.readContent();
                        }
                        if (!name.equals("incremental-backup-type")) break;
                        RepositoryBackupChainLog.this.increnetalBackupType = this.readContent();
                        break;
                    }
                    case 2: {
                        String tagName = this.reader.getLocalName();
                        if (!tagName.equals("repository-backup-config")) break;
                        endBackupConfig = true;
                    }
                }
            }
            return conf;
        }

        private String readContent() throws XMLStreamException {
            String content = null;
            int eventCode = this.reader.next();
            if (eventCode == 4) {
                content = this.reader.getText();
            }
            return content;
        }

        public String getVersionLog() {
            return this.version;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LogWriter {
        protected Log logger = ExoLogger.getLogger("exo.jcr.component.ext.LogWriter");
        private File logFile;
        XMLStreamWriter writer;

        public LogWriter(File file) throws FileNotFoundException, XMLStreamException, FactoryConfigurationError {
            this.logFile = file;
            this.writer = XMLOutputFactory.newInstance().createXMLStreamWriter(new FileOutputStream(this.logFile), "UTF-8");
            this.writer.writeStartDocument();
            this.writer.writeStartElement("repository-backup-chain-log");
            this.writer.writeStartElement("version-log");
            this.writer.writeCharacters(RepositoryBackupChainLog.this.versionLog);
            this.writer.writeEndElement();
            this.writer.writeStartElement("start-time");
            this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.startedTime));
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeSystemWorkspaceName(String wsName) throws XMLStreamException {
            this.writer.writeStartElement("system-workspace");
            this.writer.writeCharacters(wsName);
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public void writeBackupsPath(List<String> wsLogFilePathList, RepositoryBackupConfig config) throws XMLStreamException, IOException {
            this.writer.writeStartElement("workspaces-backup-info");
            for (String path : wsLogFilePathList) {
                this.writer.writeStartElement("url");
                this.writer.writeCharacters(RepositoryChainLogPathHelper.getRelativePath(path, config.getBackupDir().getCanonicalPath()));
                this.writer.writeEndElement();
            }
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void write(RepositoryBackupConfig config, String fullBackupType, String incrementalBackupType) throws XMLStreamException, IOException {
            this.writer.writeStartElement("repository-backup-config");
            this.writer.writeStartElement("backup-type");
            this.writer.writeCharacters(String.valueOf(config.getBackupType()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("full-backup-type");
            this.writer.writeCharacters(fullBackupType);
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-backup-type");
            this.writer.writeCharacters(incrementalBackupType);
            this.writer.writeEndElement();
            if (config.getBackupDir() != null) {
                this.writer.writeStartElement("backup-dir");
                this.writer.writeCharacters(config.getBackupDir().getCanonicalPath());
                this.writer.writeEndElement();
            }
            if (config.getRepository() != null) {
                this.writer.writeStartElement("repository");
                this.writer.writeCharacters(config.getRepository());
                this.writer.writeEndElement();
            }
            this.writer.writeStartElement("incremental-job-period");
            this.writer.writeCharacters(Long.toString(config.getIncrementalJobPeriod()));
            this.writer.writeEndElement();
            this.writer.writeStartElement("incremental-job-number");
            this.writer.writeCharacters(Integer.toString(config.getIncrementalJobNumber()));
            this.writer.writeEndElement();
            this.writer.writeEndElement();
            this.writer.flush();
        }

        public synchronized void writeEndLog() {
            try {
                this.writer.writeStartElement("finish-time");
                this.writer.writeCharacters(JCRDateFormat.format((Calendar)RepositoryBackupChainLog.this.finishedTime));
                this.writer.writeEndElement();
                this.writer.writeEndElement();
                this.writer.writeEndDocument();
                this.writer.flush();
            }
            catch (Exception e) {
                this.logger.error("Can't write end log", e);
            }
        }

        public synchronized void writeRepositoryEntry(RepositoryEntry rEntry, RepositoryServiceConfiguration serviceConfiguration) throws XMLStreamException, IOException, JiBXException {
            File config = new File(RepositoryBackupChainLog.this.config.getBackupDir().getCanonicalPath() + File.separator + "original-repository-config.xml");
            config.createNewFile();
            FileOutputStream saveStream = new FileOutputStream(config);
            ArrayList<RepositoryEntry> repositoryEntries = new ArrayList<RepositoryEntry>();
            repositoryEntries.add(rEntry);
            RepositoryServiceConfiguration newRepositoryServiceConfiguration = new RepositoryServiceConfiguration(serviceConfiguration.getDefaultRepositoryName(), repositoryEntries);
            IBindingFactory bfact = BindingDirectory.getFactory(RepositoryServiceConfiguration.class);
            IMarshallingContext mctx = bfact.createMarshallingContext();
            mctx.marshalDocument((Object)newRepositoryServiceConfiguration, "ISO-8859-1", null, (OutputStream)saveStream);
            ((OutputStream)saveStream).close();
            this.writer.writeStartElement("original-repository-config");
            this.writer.writeCharacters(config.getName());
            this.writer.writeEndElement();
        }
    }
}

