/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecms.xcmis.sp.index;

import java.util.ArrayList;
import org.exoplatform.ecms.xcmis.sp.NotSupportedNodeTypeException;
import org.exoplatform.ecms.xcmis.sp.index.ContentEntryAdapter;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.content.ContentEntry;
import org.xcmis.search.content.command.InvocationContext;
import org.xcmis.search.content.command.read.GetChildEntriesCommand;
import org.xcmis.search.content.command.read.GetContentEntryCommand;
import org.xcmis.search.content.command.read.GetUnfiledEntriesCommand;
import org.xcmis.search.content.interceptors.ContentReaderInterceptor;
import org.xcmis.spi.FolderData;
import org.xcmis.spi.ItemsIterator;
import org.xcmis.spi.ObjectData;
import org.xcmis.spi.ObjectNotFoundException;
import org.xcmis.spi.Storage;

public class CmisContentReader
extends ContentReaderInterceptor {
    private final Storage storage;
    private static final Log LOG = ExoLogger.getLogger((String)CmisContentReader.class.getName());
    private final ContentEntryAdapter contentEntryAdapter;

    public CmisContentReader(Storage storage) {
        this.storage = storage;
        this.contentEntryAdapter = new ContentEntryAdapter();
    }

    public Object visitChildEntriesCommand(InvocationContext ctx, GetChildEntriesCommand command) throws Throwable {
        ArrayList<ContentEntry> childs = new ArrayList<ContentEntry>();
        ObjectData parent = this.storage.getObjectById(command.getParentUuid());
        if (parent instanceof FolderData) {
            ItemsIterator childDatas = ((FolderData)parent).getChildren(null);
            while (childDatas.hasNext()) {
                childs.add(this.contentEntryAdapter.createEntry((ObjectData)childDatas.next()));
            }
        }
        return childs;
    }

    public Object visitGetContentEntryCommand(InvocationContext ctx, GetContentEntryCommand command) throws Throwable {
        ObjectData entry;
        try {
            entry = this.storage.getObjectById(command.getEntryUuid());
        }
        catch (ObjectNotFoundException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            return null;
        }
        catch (NotSupportedNodeTypeException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)((Object)e));
            }
            return null;
        }
        return this.contentEntryAdapter.createEntry(entry);
    }

    public Object visitGetUnfiledEntriesCommand(InvocationContext ctx, GetUnfiledEntriesCommand command) throws Throwable {
        return this.storage.getUnfiledObjectsId();
    }
}

