/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.identity.provider;

import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.core.identity.IdentityProvider;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceIdentityProvider
extends IdentityProvider<Space> {
    private static final Log LOG = ExoLogger.getExoLogger(SpaceIdentityProvider.class);
    public static final String NAME = "space";
    private SpaceService spaceService;

    public SpaceIdentityProvider(SpaceService spaceService) {
        this.spaceService = spaceService;
    }

    @Override
    public Space findByRemoteId(String spaceId) {
        Space space = null;
        try {
            space = this.spaceService.getSpaceById(spaceId);
            if (space == null) {
                space = this.spaceService.getSpaceByName(spaceId);
            }
        }
        catch (Exception e) {
            LOG.error((Object)("Could not find space " + spaceId), (Throwable)e);
        }
        return space;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Identity createIdentity(Space space) {
        Identity identity = new Identity(NAME, space.getId());
        return identity;
    }

    @Override
    public void populateProfile(Profile profile, Space space) {
        profile.setProperty("firstName", space.getName());
        profile.setProperty("username", space.getGroupId());
        profile.setProperty("avatarUrl", space.getImageSource());
        profile.setProperty("Url", space.getImageSource());
    }
}

