/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.agent;

import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import org.apache.sshd.agent.AgentLocal;
import org.apache.sshd.agent.AprLibrary;
import org.apache.sshd.agent.SshAgent;
import org.apache.sshd.common.util.Buffer;
import org.apache.tomcat.jni.Error;
import org.apache.tomcat.jni.Local;
import org.apache.tomcat.jni.Pool;
import org.apache.tomcat.jni.Socket;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AgentServer
implements SshAgent {
    static final byte SSH_AGENT_SUCCESS = 6;
    static final byte SSH2_AGENTC_REQUEST_IDENTITIES = 11;
    static final byte SSH2_AGENT_IDENTITIES_ANSWER = 12;
    static final byte SSH2_AGENTC_SIGN_REQUEST = 13;
    static final byte SSH2_AGENT_SIGN_RESPONSE = 14;
    static final byte SSH2_AGENTC_ADD_IDENTITY = 17;
    static final byte SSH2_AGENTC_REMOVE_IDENTITY = 18;
    static final byte SSH2_AGENTC_REMOVE_ALL_IDENTITIES = 19;
    static final byte SSH2_AGENT_FAILURE = 30;
    private final SshAgent engine = new AgentLocal();
    private String authSocket;
    private long pool;
    private long handle;
    private Thread thread;

    public String start() throws Exception {
        this.authSocket = AprLibrary.createLocalSocketAddress();
        this.pool = Pool.create((long)AprLibrary.getInstance().getRootPool());
        this.handle = Local.create((String)this.authSocket, (long)this.pool);
        int result = Local.bind((long)this.handle, (long)0L);
        if (result != 0) {
            AgentServer.throwException(result);
        }
        AprLibrary.secureLocalSocket(this.authSocket, this.handle);
        result = Local.listen((long)this.handle, (int)0);
        if (result != 0) {
            AgentServer.throwException(result);
        }
        this.thread = new Thread(){

            public void run() {
                try {
                    while (true) {
                        long clientSock = Local.accept((long)AgentServer.this.handle);
                        Socket.timeoutSet((long)clientSock, (long)10000000L);
                        new SshAgentSession(clientSock, AgentServer.this.engine).start();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
        };
        this.thread.start();
        return this.authSocket;
    }

    @Override
    public void close() {
        this.engine.close();
        Socket.close((long)this.handle);
    }

    @Override
    public List<SshAgent.Pair<PublicKey, String>> getIdentities() throws IOException {
        return this.engine.getIdentities();
    }

    @Override
    public byte[] sign(PublicKey key, byte[] data) throws IOException {
        return this.engine.sign(key, data);
    }

    @Override
    public void addIdentity(KeyPair key, String comment) throws IOException {
        this.engine.addIdentity(key, comment);
    }

    @Override
    public void removeIdentity(PublicKey key) throws IOException {
        this.engine.removeIdentity(key);
    }

    @Override
    public void removeAllIdentities() throws IOException {
        this.engine.removeAllIdentities();
    }

    private static void throwException(int code) throws IOException {
        throw new IOException(Error.strerror((int)(-code)) + " (code: " + code + ")");
    }

    protected static class SshAgentSession
    extends Thread {
        private final long socket;
        private final SshAgent engine;
        private final Buffer buffer = new Buffer();

        public SshAgentSession(long socket, SshAgent engine) {
            this.socket = socket;
            this.engine = engine;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                int result;
                byte[] buf = new byte[1024];
                while ((result = Socket.recv((long)this.socket, (byte[])buf, (int)0, (int)buf.length)) != 70014) {
                    if (result < 0) {
                        AgentServer.throwException(result);
                    }
                    this.messageReceived(new Buffer(buf, 0, result));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                Socket.close((long)this.socket);
            }
        }

        public synchronized void messageReceived(Buffer message) throws Exception {
            this.buffer.putBuffer(message);
            if (this.buffer.available() < 4) {
                return;
            }
            int rpos = this.buffer.rpos();
            int len = this.buffer.getInt();
            this.buffer.rpos(rpos);
            if (this.buffer.available() < len + 4) {
                return;
            }
            Buffer rep = new Buffer();
            rep.putInt(0L);
            rep.rpos(rep.wpos());
            try {
                this.process(new Buffer(this.buffer.getBytes()), rep);
            }
            catch (Exception e) {
                rep.clear();
                rep.putInt(1L);
                rep.putByte((byte)30);
            }
            this.reply(rep);
        }

        protected void process(Buffer req, Buffer rep) throws Exception {
            byte cmd = req.getByte();
            switch (cmd) {
                case 11: {
                    List<SshAgent.Pair<PublicKey, String>> keys = this.engine.getIdentities();
                    rep.putByte((byte)12);
                    rep.putInt(keys.size());
                    for (SshAgent.Pair<PublicKey, String> key : keys) {
                        rep.putPublicKey(key.getFirst());
                        rep.putString(key.getSecond());
                    }
                    break;
                }
                case 13: {
                    PublicKey key = req.getPublicKey();
                    byte[] data = req.getBytes();
                    int flags = req.getInt();
                    Buffer sig = new Buffer();
                    sig.putString(key instanceof RSAPublicKey ? "ssh-rsa" : "ssh-dss");
                    sig.putBytes(this.engine.sign(key, data));
                    rep.putByte((byte)14);
                    rep.putBytes(sig.array(), sig.rpos(), sig.available());
                    break;
                }
                case 17: {
                    this.engine.addIdentity(req.getKeyPair(), req.getString());
                    rep.putByte((byte)6);
                    break;
                }
                case 18: {
                    PublicKey key = req.getPublicKey();
                    this.engine.removeIdentity(key);
                    rep.putByte((byte)6);
                    break;
                }
                case 19: {
                    this.engine.removeAllIdentities();
                    rep.putByte((byte)6);
                    break;
                }
                default: {
                    rep.putByte((byte)30);
                }
            }
        }

        protected void reply(Buffer buf) throws Exception {
            int len = buf.available();
            int rpos = buf.rpos();
            int wpos = buf.wpos();
            buf.rpos(rpos - 4);
            buf.wpos(rpos - 4);
            buf.putInt(len);
            buf.wpos(wpos);
            int result = Socket.send((long)this.socket, (byte[])buf.array(), (int)buf.rpos(), (int)buf.available());
            if (result < 0) {
                AgentServer.throwException(result);
            }
        }
    }
}

