/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.index.TermVectorsReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.StringHelper;
import org.apache.lucene.util.UnicodeUtil;

final class TermVectorsWriter {
    private IndexOutput tvx = null;
    private IndexOutput tvd = null;
    private IndexOutput tvf = null;
    private FieldInfos fieldInfos;
    final UnicodeUtil.UTF8Result[] utf8Results = new UnicodeUtil.UTF8Result[]{new UnicodeUtil.UTF8Result(), new UnicodeUtil.UTF8Result()};
    static final /* synthetic */ boolean $assertionsDisabled;

    public TermVectorsWriter(Directory directory, String segment, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createOutput(segment + "." + "tvx");
        this.tvx.writeInt(4);
        this.tvd = directory.createOutput(segment + "." + "tvd");
        this.tvd.writeInt(4);
        this.tvf = directory.createOutput(segment + "." + "tvf");
        this.tvf.writeInt(4);
        this.fieldInfos = fieldInfos;
    }

    public final void addAllDocVectors(TermFreqVector[] vectors) throws IOException {
        this.tvx.writeLong(this.tvd.getFilePointer());
        this.tvx.writeLong(this.tvf.getFilePointer());
        if (vectors != null) {
            int numFields = vectors.length;
            this.tvd.writeVInt(numFields);
            long[] fieldPointers = new long[numFields];
            for (int i = 0; i < numFields; ++i) {
                int bits;
                boolean storeOffsets;
                boolean storePositions;
                TermPositionVector tpVector;
                fieldPointers[i] = this.tvf.getFilePointer();
                int fieldNumber = this.fieldInfos.fieldNumber(vectors[i].getField());
                this.tvd.writeVInt(fieldNumber);
                int numTerms = vectors[i].size();
                this.tvf.writeVInt(numTerms);
                if (vectors[i] instanceof TermPositionVector) {
                    tpVector = (TermPositionVector)vectors[i];
                    storePositions = tpVector.size() > 0 && tpVector.getTermPositions(0) != null;
                    storeOffsets = tpVector.size() > 0 && tpVector.getOffsets(0) != null;
                    bits = (byte)((storePositions ? 1 : 0) + (storeOffsets ? 2 : 0));
                } else {
                    tpVector = null;
                    bits = 0;
                    storePositions = false;
                    storeOffsets = false;
                }
                this.tvf.writeVInt(bits);
                String[] terms = vectors[i].getTerms();
                int[] freqs = vectors[i].getTermFrequencies();
                int utf8Upto = 0;
                this.utf8Results[1].length = 0;
                for (int j = 0; j < numTerms; ++j) {
                    int k;
                    UnicodeUtil.UTF16toUTF8(terms[j], 0, terms[j].length(), this.utf8Results[utf8Upto]);
                    int start = StringHelper.bytesDifference(this.utf8Results[1 - utf8Upto].result, this.utf8Results[1 - utf8Upto].length, this.utf8Results[utf8Upto].result, this.utf8Results[utf8Upto].length);
                    int length = this.utf8Results[utf8Upto].length - start;
                    this.tvf.writeVInt(start);
                    this.tvf.writeVInt(length);
                    this.tvf.writeBytes(this.utf8Results[utf8Upto].result, start, length);
                    utf8Upto = 1 - utf8Upto;
                    int termFreq = freqs[j];
                    this.tvf.writeVInt(termFreq);
                    if (storePositions) {
                        int[] positions = tpVector.getTermPositions(j);
                        if (positions == null) {
                            throw new IllegalStateException("Trying to write positions that are null!");
                        }
                        if (!$assertionsDisabled && positions.length != termFreq) {
                            throw new AssertionError();
                        }
                        int lastPosition = 0;
                        for (k = 0; k < positions.length; ++k) {
                            int position = positions[k];
                            this.tvf.writeVInt(position - lastPosition);
                            lastPosition = position;
                        }
                    }
                    if (!storeOffsets) continue;
                    TermVectorOffsetInfo[] offsets = tpVector.getOffsets(j);
                    if (offsets == null) {
                        throw new IllegalStateException("Trying to write offsets that are null!");
                    }
                    if (!$assertionsDisabled && offsets.length != termFreq) {
                        throw new AssertionError();
                    }
                    int lastEndOffset = 0;
                    for (k = 0; k < offsets.length; ++k) {
                        int startOffset = offsets[k].getStartOffset();
                        int endOffset = offsets[k].getEndOffset();
                        this.tvf.writeVInt(startOffset - lastEndOffset);
                        this.tvf.writeVInt(endOffset - startOffset);
                        lastEndOffset = endOffset;
                    }
                }
            }
            long lastFieldPointer = fieldPointers[0];
            for (int i = 1; i < numFields; ++i) {
                long fieldPointer = fieldPointers[i];
                this.tvd.writeVLong(fieldPointer - lastFieldPointer);
                lastFieldPointer = fieldPointer;
            }
        } else {
            this.tvd.writeVInt(0);
        }
    }

    final void addRawDocuments(TermVectorsReader reader, int[] tvdLengths, int[] tvfLengths, int numDocs) throws IOException {
        long tvdPosition = this.tvd.getFilePointer();
        long tvfPosition = this.tvf.getFilePointer();
        long tvdStart = tvdPosition;
        long tvfStart = tvfPosition;
        for (int i = 0; i < numDocs; ++i) {
            this.tvx.writeLong(tvdPosition);
            tvdPosition += (long)tvdLengths[i];
            this.tvx.writeLong(tvfPosition);
            tvfPosition += (long)tvfLengths[i];
        }
        this.tvd.copyBytes(reader.getTvdStream(), tvdPosition - tvdStart);
        this.tvf.copyBytes(reader.getTvfStream(), tvfPosition - tvfStart);
        if (!$assertionsDisabled && this.tvd.getFilePointer() != tvdPosition) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this.tvf.getFilePointer() != tvfPosition) {
            throw new AssertionError();
        }
    }

    final void close() throws IOException {
        IOException keep;
        block12: {
            block11: {
                block10: {
                    keep = null;
                    if (this.tvx != null) {
                        try {
                            this.tvx.close();
                        }
                        catch (IOException e) {
                            if (keep != null) break block10;
                            keep = e;
                        }
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e) {
                        if (keep != null) break block11;
                        keep = e;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e) {
                    if (keep != null) break block12;
                    keep = e;
                }
            }
        }
        if (keep != null) {
            throw (IOException)keep.fillInStackTrace();
        }
    }

    static {
        $assertionsDisabled = !TermVectorsWriter.class.desiredAssertionStatus();
    }
}

