/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.social.core.storage;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.Validate;
import org.exoplatform.services.jcr.util.IdGenerator;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.social.common.jcr.JCRSessionManager;
import org.exoplatform.social.common.jcr.LockManager;
import org.exoplatform.social.common.jcr.QueryBuilder;
import org.exoplatform.social.common.jcr.SocialDataLocation;
import org.exoplatform.social.core.activity.model.Activity;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityStorage {
    private static final Log LOG = ExoLogger.getLogger(ActivityStorage.class);
    private static final String PUBLISHED_NODE = "published".intern();
    private static final String NT_UNSTRUCTURED = "nt:unstructured".intern();
    private static final String ACTIVITY_NODETYPE = "exo:activity".intern();
    private static final String BODY = "exo:body".intern();
    private static final String BODY_TEMPLATE = "exo:bodyTemplate".intern();
    private static final String EXTERNAL_ID = "exo:externalId".intern();
    private static final String ID = "exo:id".intern();
    private static final String UPDATED_TIMESTAMP = "exo:updatedTimestamp".intern();
    private static final String POSTED_TIME = "exo:postedTime".intern();
    private static final String PRIORITY = "exo:priority".intern();
    private static final String TITLE = "exo:title".intern();
    private static final String TITLE_TEMPLATE = "exo:titleTemplate".intern();
    private static final String URL = "exo:url".intern();
    private static final String USER_ID = "exo:userId".intern();
    private static final String TYPE = "exo:type".intern();
    private static final String REPLY_TO_ID = "exo:replyToId".intern();
    private static final String HIDDEN = "exo:hidden".intern();
    private static final String LIKE_IDENTITY_IDS = "exo:likeIdentityIds".intern();
    private static final String PARAMS = "exo:params";
    private static final String ACTIVITY_PROPERTIES_NAME_PATTERN;
    private SocialDataLocation dataLocation;
    private JCRSessionManager sessionManager;
    private IdentityManager identityManager;
    private final LockManager lockManager;

    public ActivityStorage(SocialDataLocation dataLocation, IdentityManager identityManager, LockManager lockManager) {
        this.lockManager = lockManager;
        this.dataLocation = dataLocation;
        this.identityManager = identityManager;
        this.sessionManager = dataLocation.getSessionManager();
    }

    public void save(Identity owner, Activity activity) {
        this.saveActivity(owner, activity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity saveActivity(Identity owner, Activity activity) {
        Validate.notNull((Object)owner, (String)"owner must not be null.");
        Validate.notNull((Object)activity, (String)"activity must not be null.");
        Validate.notNull((Object)activity.getUpdated(), (String)"Activity.getUpdated() must not be null.");
        Validate.notNull((Object)activity.getPostedTime(), (String)"Activity.getPostedTime() must not be null.");
        Validate.notNull((Object)activity.getTitle(), (String)"Activity.getTitle() must not be null.");
        if (activity.getUserId() == null) {
            activity.setUserId(owner.getId());
        }
        Node activityHomeNode = this.getPublishedActivityServiceHome(owner);
        try {
            Node activityNode;
            Session session = this.sessionManager.getOrOpenSession();
            if (activity.getId() == null) {
                activityNode = activityHomeNode.addNode(IdGenerator.generate(), ACTIVITY_NODETYPE);
                activityNode.addMixin("mix:referenceable");
            } else {
                activityNode = session.getNodeByUUID(activity.getId());
            }
            this.setStreamInfo(activity, activityNode);
            activityNode.setProperty(TITLE, activity.getTitle());
            if (activity.getTitleId() != null) {
                activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            }
            activityNode.setProperty(UPDATED_TIMESTAMP, activity.getUpdatedTimestamp().longValue());
            activityNode.setProperty(POSTED_TIME, activity.getPostedTime().longValue());
            if (activity.getBody() != null) {
                activityNode.setProperty(BODY, activity.getBody());
            }
            if (activity.getExternalId() != null) {
                activityNode.setProperty(EXTERNAL_ID, activity.getExternalId());
            }
            if (activity.getPriority() != null) {
                activityNode.setProperty(PRIORITY, (double)activity.getPriority().floatValue());
            }
            if (activity.getTitle() != null) {
                activityNode.setProperty(TITLE, activity.getTitle());
            }
            if (activity.getUserId() != null) {
                activityNode.setProperty(USER_ID, activity.getUserId());
            }
            if (activity.getType() != null) {
                activityNode.setProperty(TYPE, activity.getType());
            }
            if (activity.getReplyToId() != null) {
                activityNode.setProperty(REPLY_TO_ID, activity.getReplyToId());
            }
            if (activity.getUrl() != null) {
                activityNode.setProperty(URL, activity.getUrl());
            }
            activityNode.setProperty(LIKE_IDENTITY_IDS, activity.getLikeIdentityIds());
            activityNode.setProperty(HIDDEN, activity.isHidden());
            activityNode.setProperty(TITLE_TEMPLATE, activity.getTitleId());
            activityNode.setProperty(BODY_TEMPLATE, activity.getBodyId());
            activityNode.setProperty(PARAMS, this.mapToArray(activity.getTemplateParams()));
            if (activity.getId() == null) {
                activityHomeNode.save();
                activity.setId(activityNode.getUUID());
            } else {
                activityNode.save();
            }
        }
        catch (Exception e) {
            LOG.warn((Object)"Failed to save activity", (Throwable)e);
            Activity activity2 = null;
            return activity2;
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteActivity(String activityId) {
        this.deleteActivityComments(activityId);
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                activityNode.remove();
                session.save();
            } else {
                LOG.warn((Object)("Failed to delete activityId: " + activityId + ": not found"));
            }
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to delete activity", (Throwable)ex);
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    public void deleteActivity(Activity storedActivity) {
        if (storedActivity.getId() == null) {
            LOG.warn((Object)"failed to delete this actvitiy. It is not stored in JCR yet.");
        }
        this.deleteActivity(storedActivity.getId());
    }

    public void saveComment(Activity activity, Activity comment) {
        Validate.notNull((Object)activity, (String)"activity must not be null.");
        Validate.notNull((Object)comment.getUserId(), (String)"comment.getUserId() must not be null.");
        Validate.notNull((Object)comment.getTitle(), (String)"comment.getTitle() must not be null.");
        if (comment.getId() != null) {
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        } else {
            comment.setPostedTime(System.currentTimeMillis());
            comment.setUpdatedTimestamp(System.currentTimeMillis());
        }
        comment.setReplyToId("IS_COMMENT");
        Identity ownerStream = this.identityManager.getIdentity(activity.getUserId());
        comment = this.saveActivity(ownerStream, comment);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds == null) {
            rawCommentIds = "";
        }
        rawCommentIds = rawCommentIds + "," + comment.getId();
        activity.setReplyToId(rawCommentIds);
        this.saveActivity(ownerStream, activity);
    }

    public void deleteComment(String activityId, String commentId) {
        Activity activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null && rawCommentIds.contains(commentId)) {
            Activity comment = this.getActivity(commentId);
            if (comment == null) {
                LOG.warn((Object)("can not find comment with id: " + commentId));
                return;
            }
            try {
                this.deleteActivity(commentId);
                commentId = "," + commentId;
                rawCommentIds = rawCommentIds.replace(commentId, "");
                activity.setReplyToId(rawCommentIds);
                Identity user = this.identityManager.getIdentity(activity.getUserId());
                this.saveActivity(user, activity);
            }
            catch (Exception e) {
                LOG.warn((Object)("failed to delete comment with id: " + commentId));
            }
        } else {
            LOG.warn((Object)("can't not find commentId: " + commentId + " in activity with activityId: " + activityId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Activity getActivity(String activityId) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Node activityNode = session.getNodeByUUID(activityId);
            if (activityNode != null) {
                Activity activity = this.load(activityNode);
                return activity;
            }
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage());
        }
        finally {
            this.sessionManager.closeSession();
        }
        return null;
    }

    public Activity load(String activityId) {
        return this.getActivity(activityId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivities(Identity owner, long offset, long limit) {
        Node n = this.getPublishedActivityServiceHome(owner);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        try {
            String path = n.getPath();
            Session session = this.sessionManager.getOrOpenSession();
            List nodes = new QueryBuilder(session).select(ACTIVITY_NODETYPE, offset, limit).like("jcr:path", path + "[%]/%").and().not().equal(REPLY_TO_ID, "IS_COMMENT").orderBy("exo:updatedTimestamp", "DESC").exec();
            for (Node node : nodes) {
                activities.add(this.load(node));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivitiesOfConnections(List<Identity> connectionList, int offset, int limit) {
        ArrayList<Activity> activities = new ArrayList<Activity>();
        if (connectionList.isEmpty()) {
            return activities;
        }
        Node streamLocation = this.getStreamLocation(connectionList.get(0));
        try {
            String path = streamLocation.getParent().getPath();
            Session session = this.sessionManager.getOrOpenSession();
            QueryBuilder queryBuilder = new QueryBuilder(session).select(ACTIVITY_NODETYPE, (long)offset, (long)limit).like("jcr:path", path + "/%").and().not().equal(REPLY_TO_ID, "IS_COMMENT").and().group();
            int length = connectionList.size();
            for (int i = 0; i < length; ++i) {
                Identity id = connectionList.get(i);
                if (i != 0) {
                    queryBuilder.or();
                }
                queryBuilder.equal(USER_ID, id.getId());
            }
            queryBuilder.endGroup().orderBy(POSTED_TIME, "DESC");
            List nodes = queryBuilder.exec();
            for (Node node : nodes) {
                activities.add(this.load(node));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Activity> getActivities(Identity owner) {
        Node publishingNode = this.getPublishedActivityServiceHome(owner);
        ArrayList<Activity> activities = new ArrayList<Activity>();
        Session session = this.sessionManager.getOrOpenSession();
        try {
            String path = publishingNode.getPath();
            List nodes = new QueryBuilder(session).select(ACTIVITY_NODETYPE).like("jcr:path", path + "[%]/%").and().not().equal(REPLY_TO_ID, "IS_COMMENT").exec();
            for (Node node : nodes) {
                activities.add(this.load(node));
            }
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return activities;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getActivitiesCount(Identity owner) {
        int count = 0;
        Node publishingNode = this.getPublishedActivityServiceHome(owner);
        Session session = this.sessionManager.getOrOpenSession();
        try {
            String path = publishingNode.getPath();
            count = (int)new QueryBuilder(session).select(ACTIVITY_NODETYPE).like("jcr:path", path + "[%]/%").and().not().equal(REPLY_TO_ID, "IS_COMMENT").count();
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        finally {
            this.sessionManager.closeSession();
        }
        return count;
    }

    private Node getActivityServiceHome(Session session) {
        String path = this.dataLocation.getSocialActivitiesHome();
        try {
            return session.getRootNode().getNode(path);
        }
        catch (PathNotFoundException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return null;
    }

    private Node getStreamLocation(Identity owner) {
        String type = owner.getProviderId();
        String id = owner.getRemoteId();
        if (type != null && id != null) {
            return this.getStreamsLocationByType(type, id);
        }
        LOG.warn((Object)("attempting to get a stream for non prefixed owner : " + id));
        return this.getStreamsLocationByType("default", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getStreamsLocationByType(String type, String username) {
        Session session = this.sessionManager.getOrOpenSession();
        try {
            Lock lock;
            Node typeHome;
            block20: {
                Node activityHomeNode = this.getActivityServiceHome(session);
                if (activityHomeNode.hasNode(type)) {
                    typeHome = activityHomeNode.getNode(type);
                } else {
                    lock = this.lockManager.getLock("Activity", type);
                    lock.lock();
                    try {
                        if (activityHomeNode.hasNode(type)) {
                            typeHome = activityHomeNode.getNode(type);
                        } else {
                            typeHome = activityHomeNode.addNode(type, NT_UNSTRUCTURED);
                            activityHomeNode.save();
                        }
                    }
                    finally {
                        lock.unlock();
                    }
                }
                if (typeHome.hasNode(username)) {
                    lock = typeHome.getNode(username);
                    return lock;
                }
                lock = this.lockManager.getLock("Activity", username);
                lock.lock();
                try {
                    if (!typeHome.hasNode(username)) break block20;
                    Node node = typeHome.getNode(username);
                    lock.unlock();
                    return node;
                }
                catch (Throwable throwable) {
                    try {
                        lock.unlock();
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("failed to locate stream owner node for " + username), (Throwable)e);
                        Node node = null;
                        return node;
                    }
                }
            }
            Node streamNode = typeHome.addNode(username, NT_UNSTRUCTURED);
            typeHome.save();
            Node node = streamNode;
            lock.unlock();
            return node;
        }
        finally {
            this.sessionManager.closeSession();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node getPublishedActivityServiceHome(Identity owner) {
        Node userActivityHomeNode = this.getStreamLocation(owner);
        try {
            return userActivityHomeNode.getNode(PUBLISHED_NODE);
        }
        catch (PathNotFoundException ex) {
            Lock lock = this.lockManager.getLock("Activity", owner.getRemoteId());
            lock.lock();
            try {
                Node node = userActivityHomeNode.getNode(PUBLISHED_NODE);
                lock.unlock();
                return node;
            }
            catch (PathNotFoundException ex2) {
                try {
                    Node appNode = userActivityHomeNode.addNode(PUBLISHED_NODE, NT_UNSTRUCTURED);
                    appNode.addMixin("mix:referenceable");
                    userActivityHomeNode.save();
                    Node node = appNode;
                    lock.unlock();
                    return node;
                }
                catch (Throwable throwable) {
                    try {
                        lock.unlock();
                        throw throwable;
                    }
                    catch (Exception e) {
                        LOG.error((Object)("Failed to get published activity service location for " + owner), (Throwable)e);
                        return null;
                    }
                }
            }
        }
    }

    private void deleteActivityComments(String activityId) {
        Activity activity = this.getActivity(activityId);
        String rawCommentIds = activity.getReplyToId();
        if (rawCommentIds != null) {
            if (rawCommentIds.equals("IS_COMMENT")) {
                return;
            }
            Object[] commentIds = rawCommentIds.split(",");
            for (Object commentId : commentIds = (String[])ArrayUtils.removeElement((Object[])commentIds, (Object)"")) {
                try {
                    this.deleteActivity((String)commentId);
                }
                catch (Exception ex) {
                    LOG.warn((Object)("Failed to delete comment actvity " + (String)commentId + ": " + ex.getMessage()));
                }
            }
        }
    }

    private void setStreamInfo(Activity activity, Node activityNode) throws Exception {
        try {
            activity.setStreamOwner(activityNode.getParent().getParent().getName());
            activity.setStreamId(activityNode.getParent().getUUID());
        }
        catch (UnsupportedRepositoryOperationException e) {
            activityNode.getParent().addMixin("mix:referenceable");
            activity.setStreamId(activityNode.getParent().getUUID());
        }
    }

    private Activity load(Node activityNode) {
        Activity activity = new Activity();
        try {
            activity.setId(activityNode.getUUID());
            this.setStreamInfo(activity, activityNode);
            PropertyIterator it = activityNode.getProperties(ACTIVITY_PROPERTIES_NAME_PATTERN);
            while (it.hasNext()) {
                Property p = it.nextProperty();
                String propertyName = p.getName();
                if (BODY.equals(propertyName)) {
                    activity.setBody(p.getString());
                    continue;
                }
                if (EXTERNAL_ID.equals(propertyName)) {
                    activity.setExternalId(p.getString());
                    continue;
                }
                if (HIDDEN.equals(propertyName)) {
                    activity.setHidden(p.getBoolean());
                    continue;
                }
                if (POSTED_TIME.equals(propertyName)) {
                    activity.setPostedTime(p.getLong());
                    continue;
                }
                if (PRIORITY.equals(propertyName)) {
                    activity.setPriority((int)p.getLong());
                    continue;
                }
                if (TITLE.equals(propertyName)) {
                    activity.setTitle(p.getString());
                    continue;
                }
                if (TYPE.equals(propertyName)) {
                    activity.setType(p.getString());
                    continue;
                }
                if (REPLY_TO_ID.equals(propertyName)) {
                    activity.setReplyToId(p.getString());
                    continue;
                }
                if (UPDATED_TIMESTAMP.equals(propertyName)) {
                    activity.setUpdatedTimestamp(p.getLong());
                    continue;
                }
                if (URL.equals(propertyName)) {
                    activity.setUrl(p.getString());
                    continue;
                }
                if (USER_ID.equals(propertyName)) {
                    activity.setUserId(p.getString());
                    continue;
                }
                if (LIKE_IDENTITY_IDS.equals(propertyName)) {
                    activity.setLikeIdentityIds(this.convertValuesToStrings(p.getValues()));
                    continue;
                }
                if (PARAMS.equals(propertyName)) {
                    activity.setTemplateParams(this.convertValuesToMap(p.getValues()));
                    continue;
                }
                if (TITLE_TEMPLATE.equals(propertyName)) {
                    activity.setTitleId(p.getString());
                    continue;
                }
                if (!BODY_TEMPLATE.equals(propertyName)) continue;
                activity.setBodyId(p.getString());
            }
        }
        catch (UnsupportedRepositoryOperationException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (RepositoryException e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            LOG.warn((Object)e.getMessage(), (Throwable)e);
        }
        return activity;
    }

    private Map<String, String> convertValuesToMap(Value[] values) {
        if (values == null) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Value value : values) {
            try {
                String val = value.getString();
                int equalIndex = val.indexOf("=");
                if (equalIndex <= 0) continue;
                result.put(val.split("=")[0], val.substring(equalIndex + 1));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }

    private String[] mapToArray(Map<String, String> templateParams) {
        if (templateParams == null) {
            return null;
        }
        Set<String> keys = templateParams.keySet();
        String[] result = new String[keys.size()];
        int i = 0;
        for (String key : keys) {
            result[i++] = key + "=" + templateParams.get(key);
        }
        return result;
    }

    private String[] convertValuesToStrings(Value[] values) throws Exception {
        if (values.length == 1) {
            return new String[]{values[0].getString()};
        }
        String[] Str = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            Str[i] = values[i].getString();
        }
        return Str;
    }

    static {
        StringBuilder buffer = new StringBuilder(256);
        char separator = '|';
        buffer.append(BODY).append(separator);
        buffer.append(EXTERNAL_ID).append(separator);
        buffer.append(HIDDEN).append(separator);
        buffer.append(POSTED_TIME).append(separator);
        buffer.append(PRIORITY).append(separator);
        buffer.append(TITLE).append(separator);
        buffer.append(TYPE).append(separator);
        buffer.append(REPLY_TO_ID).append(separator);
        buffer.append(UPDATED_TIMESTAMP).append(separator);
        buffer.append(URL).append(separator);
        buffer.append(USER_ID).append(separator);
        buffer.append(LIKE_IDENTITY_IDS).append(separator);
        buffer.append(PARAMS).append(separator);
        buffer.append(TITLE_TEMPLATE).append(separator);
        buffer.append(BODY_TEMPLATE);
        ACTIVITY_PROPERTIES_NAME_PATTERN = buffer.toString();
    }
}

