/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.commons.platform.modules;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.exoplatform.commons.platform.modules.Module;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleRegistry {
    private static final Log LOG = ExoLogger.getExoLogger(ModuleRegistry.class);
    private Map<String, Module> modulesByName = new HashMap<String, Module>();

    public Collection<Module> getAvailableModules() {
        return this.modulesByName.values();
    }

    public void registerModule(Module module) {
        this.modulesByName.put(module.getName(), module);
    }

    public void unregisterModule(Module moduleName) {
        this.modulesByName.remove(moduleName);
    }

    public boolean activateModule(String moduleName) {
        Module module = this.modulesByName.get(moduleName);
        if (module == null) {
            LOG.warn((Object)("could not find a registered module named '" + moduleName + "' to activate"));
            return false;
        }
        module.setActive(true);
        return true;
    }

    public void register(ModulePlugin plugin) {
        Module module = new Module(plugin.getName(), plugin.getDescription());
        this.registerModule(module);
    }

    public void activate(ModulePlugin plugin) {
        String name = plugin.getName();
        this.activateModule(name);
    }

    class ModulePlugin
    extends ComponentPlugin {
        ModulePlugin() {
        }
    }
}

