/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.ecm.webui.component.admin.repository;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.ecm.webui.component.admin.UIECMAdminPortlet;
import org.exoplatform.ecm.webui.component.admin.repository.UIPermissionContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryForm;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryFormContainer;
import org.exoplatform.ecm.webui.component.admin.repository.UIRepositoryValueSelect;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep1;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep2;
import org.exoplatform.ecm.webui.component.admin.repository.UIWizardStep3;
import org.exoplatform.ecm.webui.component.admin.repository.UIWorkspaceWizardContainer;
import org.exoplatform.ecm.webui.form.UIFormInputSetWithAction;
import org.exoplatform.ecm.webui.selector.UISelectable;
import org.exoplatform.ecm.webui.utils.Utils;
import org.exoplatform.services.jcr.RepositoryService;
import org.exoplatform.services.jcr.access.AccessControlEntry;
import org.exoplatform.services.jcr.config.CacheEntry;
import org.exoplatform.services.jcr.config.ContainerEntry;
import org.exoplatform.services.jcr.config.LockManagerEntry;
import org.exoplatform.services.jcr.config.LockPersisterEntry;
import org.exoplatform.services.jcr.config.QueryHandlerEntry;
import org.exoplatform.services.jcr.config.SimpleParameterEntry;
import org.exoplatform.services.jcr.config.ValueStorageEntry;
import org.exoplatform.services.jcr.config.ValueStorageFilterEntry;
import org.exoplatform.services.jcr.config.WorkspaceEntry;
import org.exoplatform.services.jcr.core.ExtendedNode;
import org.exoplatform.services.jcr.core.ManageableRepository;
import org.exoplatform.services.jcr.util.StringNumberParser;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.naming.InitialContextInitializer;
import org.exoplatform.web.application.ApplicationMessage;
import org.exoplatform.webui.config.annotation.ComponentConfig;
import org.exoplatform.webui.config.annotation.EventConfig;
import org.exoplatform.webui.core.UIApplication;
import org.exoplatform.webui.core.UIComponent;
import org.exoplatform.webui.core.UIPopupContainer;
import org.exoplatform.webui.core.lifecycle.UIFormLifecycle;
import org.exoplatform.webui.event.Event;
import org.exoplatform.webui.event.EventListener;
import org.exoplatform.webui.form.UIForm;
import org.exoplatform.webui.form.UIFormInputSet;
import org.exoplatform.webui.form.UIFormStringInput;
import org.exoplatform.webui.form.UIFormTabPane;

@ComponentConfig(lifecycle=UIFormLifecycle.class, template="app:/groovy/webui/component/admin/UIWorkspaceWizard.gtmpl", events={@EventConfig(listeners={AddPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectContainerActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectStoreActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={SelectQueryHandlerActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={FinishActionListener.class}), @EventConfig(listeners={NextActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={BackActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewStep1ActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewStep2ActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ViewStep3ActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={CancelActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={EditPermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={RemovePermissionActionListener.class}, phase=Event.Phase.DECODE), @EventConfig(listeners={ChangeTypeStoreActionListener.class}, phase=Event.Phase.DECODE)})
public class UIWorkspaceWizard
extends UIFormTabPane
implements UISelectable {
    private int wizardMaxStep_ = 3;
    private int selectedStep_ = 1;
    private int currentStep_ = 0;
    private String selectedWsName_ = null;
    private Map<Integer, String> chidrenMap_ = new HashMap<Integer, String>();
    public boolean isNewWizard_ = true;
    public boolean isNewRepo_ = true;
    public boolean isCheckValid_ = true;
    public boolean hasCheckDefault_ = false;
    private Map<Integer, String[]> actionMap_ = new HashMap<Integer, String[]>();
    public static final String POPUPID = "UIPopupWindowInWizard";
    public static final String FIELD_STEP1 = "step1";
    public static final String FIELD_STEP2 = "step2";
    public static final String FIELD_STEP3 = "step3";
    public static final String KEY_SWAPDIRECTORY = "swap-directory";
    public static final String KEY_SOURCENAME = "source-name";
    public static final String KEY_DIALECT = "dialect";
    public static final String KEY_MULTIDB = "multi-db";
    public static final String KEY_MAXBUFFER = "max-buffer-size";
    public static final String KEY_PATH = "path";
    public static final String KEY_INDEXDIR = "index-dir";
    public static final String KEY_MAXSIZE = "max-size";
    public static final String KEY_LIVETIME = "live-time";
    public static final String KEY_UPDATESTORE = "update-storage";
    public static final String KEY_CONTAINERTYPE = "org.exoplatform.services.jcr.impl.storage.jdbc.JDBCWorkspaceDataContainer";
    public static final String KEY_STORETYPE = "org.exoplatform.services.jcr.impl.storage.value.fs.SimpleFileValueStorage";
    public static final String KEY_TREE_STORETYPE = "org.exoplatform.services.jcr.impl.storage.value.fs.TreeFileValueStorage";
    public static final String KEY_QUERYHANDLER = "org.exoplatform.services.jcr.impl.core.query.lucene.SearchIndex";
    public static final String KEY_LOCKMANAGER = "org.exoplatform.services.jcr.impl.core.lock.FileSystemLockPersister";
    private static final Log LOG = ExoLogger.getLogger((String)"admin.UIWorkspaceWizard");

    public UIWorkspaceWizard() throws Exception {
        super("UIWorkspaceWizard");
        this.chidrenMap_.put(1, FIELD_STEP1);
        this.chidrenMap_.put(2, FIELD_STEP2);
        this.chidrenMap_.put(3, FIELD_STEP3);
        this.actionMap_.put(1, new String[]{"Next", "Cancel"});
        this.actionMap_.put(2, new String[]{"Back", "Next", "Cancel"});
        this.actionMap_.put(3, new String[]{"Back", "Finish", "Cancel"});
        UIWizardStep1 step1 = new UIWizardStep1(FIELD_STEP1);
        UIWizardStep2 step2 = new UIWizardStep2(FIELD_STEP2);
        UIWizardStep3 step3 = new UIWizardStep3(FIELD_STEP3);
        this.addUIComponentInput((UIComponent)step1);
        this.addUIComponentInput((UIComponent)step2);
        this.addUIComponentInput((UIComponent)step3);
        this.setRenderedChild(this.getCurrentChild());
    }

    protected void removePopup(String id) {
        ((UIWorkspaceWizardContainer)this.getAncestorOfType(UIWorkspaceWizardContainer.class)).removePopup(id);
    }

    protected void lockForm(boolean isLock) {
        UIWizardStep1 wsStep1 = (UIWizardStep1)this.getChildById(FIELD_STEP1);
        wsStep1.lockFields(isLock);
        UIWizardStep2 wsStep2 = (UIWizardStep2)this.getChildById(FIELD_STEP2);
        wsStep2.lockFields(isLock);
        UIWizardStep3 wsStep3 = (UIWizardStep3)this.getChildById(FIELD_STEP3);
        wsStep3.lockFields(isLock);
    }

    public void setCurrentSep(int step) {
        this.currentStep_ = step;
    }

    public int getCurrentStep() {
        return this.currentStep_;
    }

    public void setSelectedStep(int step) {
        this.selectedStep_ = step;
    }

    public int getSelectedStep() {
        return this.selectedStep_;
    }

    public int getMaxStep() {
        return this.wizardMaxStep_;
    }

    public String[] getActions() {
        return this.actionMap_.get(this.selectedStep_);
    }

    public String getCurrentChild() {
        return this.chidrenMap_.get(this.selectedStep_);
    }

    public String[] getCurrentAction() {
        return this.actionMap_.get(this.selectedStep_);
    }

    protected void refresh(WorkspaceEntry workSpace, boolean isAddNewWs) throws Exception {
        this.reset();
        UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)this.getChildById(FIELD_STEP1);
        UIWizardStep2 uiWSFormStep2 = (UIWizardStep2)this.getChildById(FIELD_STEP2);
        UIWizardStep3 uiWSFormStep3 = (UIWizardStep3)this.getChildById(FIELD_STEP3);
        uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setChecked(false);
        uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").setChecked(false);
        UIRepositoryForm uiRepoForm = (UIRepositoryForm)((UIECMAdminPortlet)this.getAncestorOfType(UIECMAdminPortlet.class)).findFirstComponentOfType(UIRepositoryForm.class);
        String repoName = (String)uiRepoForm.getUIStringInput("name").getValue();
        String name = "";
        boolean isDefaultWS = false;
        boolean isDMSSystem = false;
        String lockTime = "0";
        String dbType = null;
        String selectedNodeType = null;
        String permission = null;
        String containerType = "";
        String swapPath = "";
        String sourceName = "";
        boolean isMutil = false;
        String storeType = "";
        String storePath = "";
        String filterType = "";
        String queryHandlerType = "";
        String indexDir = "";
        String maxBuffer = "204800";
        boolean isEnableCache = true;
        String maxCache = "5000";
        String liveTime = "30000";
        if (workSpace != null) {
            CacheEntry cache;
            QueryHandlerEntry queryHandler;
            ArrayList valueStore;
            ContainerEntry container;
            block33: {
                ManageableRepository manageRepository;
                RepositoryService rService = (RepositoryService)((ExoContainer)this.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(RepositoryService.class);
                if (isAddNewWs) {
                    manageRepository = rService.getDefaultRepository();
                } else {
                    try {
                        manageRepository = rService.getRepository(repoName);
                    }
                    catch (RepositoryException e) {
                        manageRepository = rService.getDefaultRepository();
                    }
                }
                if (!this.isNewWizard_) {
                    name = workSpace.getName();
                    isDefaultWS = uiRepoForm.isDefaultWorkspace(name);
                    isDMSSystem = uiRepoForm.isDmsSystemWorkspace(name);
                    try {
                        Session workspaceSession = manageRepository.getSystemSession(workSpace.getName());
                        selectedNodeType = workspaceSession.getRootNode().getPrimaryNodeType().getName();
                        List listEntry = ((ExtendedNode)workspaceSession.getRootNode()).getACL().getPermissionEntries();
                        workspaceSession.logout();
                        Iterator perIter = listEntry.iterator();
                        StringBuilder userPermission = new StringBuilder();
                        while (perIter.hasNext()) {
                            AccessControlEntry accessControlEntry = (AccessControlEntry)perIter.next();
                            userPermission.append(accessControlEntry.getIdentity());
                            userPermission.append(" ");
                            userPermission.append(accessControlEntry.getPermission() + ";");
                        }
                        if (!isAddNewWs) {
                            permission = userPermission.toString();
                        }
                    }
                    catch (RepositoryException e) {
                        selectedNodeType = uiRepoForm.getWorkspaceMapNodeType(repoName);
                        if (isAddNewWs) break block33;
                        permission = uiRepoForm.getWorkspaceMapPermission(repoName);
                    }
                }
            }
            if (permission == null) {
                permission = uiRepoForm.getWorkspaceMapPermission(name);
            }
            if (workSpace.getLockManager() != null) {
                lockTime = String.valueOf(workSpace.getLockManager().getTimeout()) + "ms";
            }
            if ((container = workSpace.getContainer()) != null) {
                containerType = container.getType();
                swapPath = container.getParameterValue(KEY_SWAPDIRECTORY);
                sourceName = container.getParameterValue(KEY_SOURCENAME);
                dbType = container.getParameterValue(KEY_DIALECT);
                isMutil = Boolean.parseBoolean(container.getParameterValue(KEY_MULTIDB));
                maxBuffer = container.getParameterValue(KEY_MAXBUFFER);
            }
            if ((valueStore = container.getValueStorages()) != null && valueStore.size() > 0) {
                storeType = ((ValueStorageEntry)valueStore.get(0)).getType();
                storePath = ((ValueStorageEntry)valueStore.get(0)).getParameterValue(KEY_PATH);
                filterType = ((ValueStorageFilterEntry)((ValueStorageEntry)valueStore.get(0)).getFilters().get(0)).getPropertyType();
            }
            if ((queryHandler = workSpace.getQueryHandler()) != null) {
                queryHandlerType = queryHandler.getType();
                indexDir = queryHandler.getParameterValue(KEY_INDEXDIR);
            }
            if ((cache = workSpace.getCache()) != null) {
                isEnableCache = cache.isEnabled();
                maxCache = cache.getParameterValue(KEY_MAXSIZE);
                liveTime = cache.getParameterValue(KEY_LIVETIME);
            }
            uiWSFormStep1.fillFields(name, selectedNodeType, isDefaultWS, isDMSSystem, permission, lockTime);
            uiWSFormStep2.fillFields(containerType, sourceName, dbType, isMutil, storeType, storePath, filterType, maxBuffer, swapPath);
            uiWSFormStep3.fillFields(queryHandlerType, indexDir, isEnableCache, maxCache, liveTime);
            if (this.isNewWizard_) {
                StringBuilder sb1 = new StringBuilder();
                StringBuilder sb2 = new StringBuilder();
                if (this.isNewRepo_) {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEditable(true);
                    uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").setEditable(true);
                    sb1.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1)).append(repoName).append("/");
                    sb2.append(storePath.substring(0, storePath.lastIndexOf("/") + 1)).append(repoName).append("/");
                } else {
                    sb1.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1));
                    sb2.append(storePath.substring(0, storePath.lastIndexOf("/") + 1));
                }
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)sb1.toString());
                uiWSFormStep2.getUIStringInput("storePath").setValue((Object)sb2.toString());
                uiWSFormStep2.getUIFormSelectBox("filterType").setValue(filterType);
            }
        }
        if (this.isNewRepo_) {
            this.lockForm(false);
            if (isAddNewWs) {
                if (uiRepoForm.defaulWorkspace_ == null) {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEnable(true);
                } else {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEnable(false);
                }
                if (uiRepoForm.dmsSystemWorkspace_ == null) {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").setEnable(true);
                } else {
                    uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").setEnable(false);
                }
            }
        } else if (this.isNewWizard_) {
            this.lockForm(false);
            uiWSFormStep1.getUIFormCheckBoxInput("isDefault").setEnable(false);
            uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").setEnable(false);
        } else {
            this.lockForm(true);
        }
        if (this.isNewWizard_) {
            this.isCheckValid_ = true;
        } else if (this.isNewRepo_) {
            this.isCheckValid_ = true;
            if (workSpace != null) {
                this.selectedWsName_ = workSpace.getName();
            }
        } else {
            this.isCheckValid_ = false;
        }
    }

    private void setPermissionToRoot(ExtendedNode rootNode, String stringPermission) throws Exception {
        String[] items;
        HashMap<String, List<String>> permission = new HashMap<String, List<String>>();
        for (String item : items = stringPermission.split(";")) {
            List<String> type;
            String[] permissionType = item.split(" ");
            if (permission.containsKey(permissionType[0])) {
                type = (List)permission.get(permissionType[0]);
                if (type.contains(permissionType[1])) continue;
                type.add(permissionType[1]);
                permission.put(permissionType[0], type);
                continue;
            }
            type = new ArrayList<String>();
            type.add(permissionType[1]);
            permission.put(permissionType[0], type);
        }
        Iterator iter = permission.keySet().iterator();
        ArrayList<String> listKey = new ArrayList<String>();
        ArrayList<String> listType = new ArrayList<String>();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            listKey.add(key);
            List types = (List)permission.get(key);
            ArrayList<String> listPermission = new ArrayList<String>();
            if (key.equals("*")) {
                key = "any";
            }
            for (String type : types) {
                if (key.equals("any") && !listType.contains(type)) {
                    listType.add(type);
                }
                if (type.equals("read")) {
                    listPermission.add("read");
                    continue;
                }
                if (type.equals("add_node")) {
                    listPermission.add("add_node");
                    continue;
                }
                if (type.equals("set_property")) {
                    listPermission.add("set_property");
                    continue;
                }
                listPermission.add("remove");
            }
            String[] criteria = new String[listPermission.size()];
            rootNode.setPermission(key, listPermission.toArray(criteria));
        }
        if (!listKey.contains("any")) {
            if (!listType.contains("add_node")) {
                rootNode.removePermission("any", "add_node");
            }
            if (!listType.contains("set_property")) {
                rootNode.removePermission("any", "set_property");
            }
            if (!listType.contains("remove")) {
                rootNode.removePermission("any", "remove");
            }
        }
        rootNode.save();
    }

    public String url(String name) throws Exception {
        UIComponent renderedChild = this.getChild(this.currentStep_);
        if (!(renderedChild instanceof UIForm)) {
            return super.event(name);
        }
        org.exoplatform.webui.config.Event event = this.config.getUIComponentEventConfig(name);
        if (event == null) {
            return "??config??";
        }
        UIForm uiForm = (UIForm)renderedChild;
        return uiForm.event(name);
    }

    public int getNumberSteps() {
        return this.wizardMaxStep_;
    }

    public void viewStep(int step) {
        this.selectedStep_ = step;
        this.currentStep_ = step - 1;
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            if (i == this.getCurrentStep()) {
                ((UIComponent)children.get(i)).setRendered(true);
                continue;
            }
            ((UIComponent)children.get(i)).setRendered(false);
        }
    }

    protected boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    protected String autoInitStorePath(String storePath, String repoName, String wsName) {
        StringBuilder sb = new StringBuilder();
        sb.append(storePath.substring(0, storePath.lastIndexOf("/") + 1)).append(repoName).append("/").append(wsName);
        return sb.toString();
    }

    protected String autoInitSwapPath(String swapPath, String repoName, String wsName) {
        StringBuilder sb = new StringBuilder();
        sb.append(swapPath.substring(0, swapPath.lastIndexOf("/") + 1)).append(repoName).append("/").append(wsName);
        return sb.toString();
    }

    public void doSelect(String selectField, Object value) {
        UIFormInputSetWithAction uiFormAction = (UIFormInputSetWithAction)this.getChildById(FIELD_STEP1);
        UIFormStringInput permissionField = uiFormAction.getUIStringInput("permission");
        permissionField.setValue((Object)value.toString());
    }

    protected void showHidden(boolean isChecked) {
        this.getUIStringInput("storePath").setRendered(isChecked);
        this.getUIStringInput("filterType").setRendered(isChecked);
        this.getUIStringInput("storeType").setRendered(isChecked);
        if (isChecked) {
            // empty if block
        }
    }

    private boolean checkLockTimeOut(String lockTimeOut) {
        return lockTimeOut.matches("\\d+") || lockTimeOut.matches("\\d+[smhdw]") || lockTimeOut.matches("\\d+ms");
    }

    public void setContainerName(String value) {
        UIFormInputSet uiWSFormStep2 = (UIFormInputSet)this.getChildById(FIELD_STEP2);
        uiWSFormStep2.getUIStringInput("container").setValue((Object)value);
    }

    public void setStoreTypeName(String value) {
        UIFormInputSet uiWSFormStep2 = (UIFormInputSet)this.getChildById(FIELD_STEP2);
        uiWSFormStep2.getUIStringInput("storeType").setValue((Object)value);
    }

    public void setQueryHandlerName(String value) {
        UIFormInputSet uiWSFormStep3 = (UIFormInputSet)this.getChildById(FIELD_STEP3);
        uiWSFormStep3.getUIStringInput("queryHandler").setValue((Object)value);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeTypeStoreActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIWizardStep2 ws2 = (UIWizardStep2)uiWizard.getChildById(UIWorkspaceWizard.FIELD_STEP2);
            boolean isChecked = ws2.getUIFormCheckBoxInput("externalStore").isChecked();
            uiWizard.showHidden(isChecked);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiWizard);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectQueryHandlerActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIPopupContainer uiPopup = (UIPopupContainer)((UIWorkspaceWizardContainer)uiWizard.getAncestorOfType(UIWorkspaceWizardContainer.class)).getChild(UIPopupContainer.class);
            UIRepositoryValueSelect uiSelect = (UIRepositoryValueSelect)uiPopup.activate(UIRepositoryValueSelect.class, 500);
            uiSelect.isSetQueryHandler_ = true;
            ArrayList<UIRepositoryValueSelect.ClassData> datas = new ArrayList<UIRepositoryValueSelect.ClassData>();
            datas.add(new UIRepositoryValueSelect.ClassData(UIWorkspaceWizard.KEY_QUERYHANDLER));
            uiSelect.updateGrid(datas);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectStoreActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIPopupContainer uiPopup = (UIPopupContainer)((UIWorkspaceWizardContainer)uiWizard.getAncestorOfType(UIWorkspaceWizardContainer.class)).getChild(UIPopupContainer.class);
            UIRepositoryValueSelect uiSelect = (UIRepositoryValueSelect)uiPopup.activate(UIRepositoryValueSelect.class, 500);
            uiSelect.isSetStoreType_ = true;
            ArrayList<UIRepositoryValueSelect.ClassData> datas = new ArrayList<UIRepositoryValueSelect.ClassData>();
            datas.add(new UIRepositoryValueSelect.ClassData(UIWorkspaceWizard.KEY_STORETYPE));
            datas.add(new UIRepositoryValueSelect.ClassData(UIWorkspaceWizard.KEY_TREE_STORETYPE));
            uiSelect.updateGrid(datas);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SelectContainerActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIPopupContainer uiPopup = (UIPopupContainer)((UIWorkspaceWizardContainer)uiWizard.getAncestorOfType(UIWorkspaceWizardContainer.class)).getChild(UIPopupContainer.class);
            UIRepositoryValueSelect uiSelect = (UIRepositoryValueSelect)uiPopup.activate(UIRepositoryValueSelect.class, 500);
            uiSelect.isSetContainer_ = true;
            ArrayList<UIRepositoryValueSelect.ClassData> datas = new ArrayList<UIRepositoryValueSelect.ClassData>();
            datas.add(new UIRepositoryValueSelect.ClassData(UIWorkspaceWizard.KEY_CONTAINERTYPE));
            uiSelect.updateGrid(datas);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiPopup);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CancelActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            uiFormWizard.refresh(null, false);
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiFormWizard.getAncestorOfType(UIPopupContainer.class);
            UIPopupContainer2.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RemovePermissionActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiForm = (UIWorkspaceWizard)((Object)event.getSource());
            UIWizardStep1 ws1 = (UIWizardStep1)uiForm.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            String permName = event.getRequestContext().getRequestParameter("objectId");
            ws1.removePermission(permName);
            ws1.refreshPermissionList();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIWorkspaceWizardContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditPermissionActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiForm = (UIWorkspaceWizard)((Object)event.getSource());
            String permName = event.getRequestContext().getRequestParameter("objectId");
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)((UIWorkspaceWizardContainer)uiForm.getAncestorOfType(UIWorkspaceWizardContainer.class)).getChild(UIPopupContainer.class);
            UIWizardStep1 ws1 = (UIWizardStep1)uiForm.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            UIPermissionContainer uiContainer = (UIPermissionContainer)UIPopupContainer2.activate(UIPermissionContainer.class, 600);
            uiContainer.setValues(permName, ws1.getPermissions().get(permName));
            uiContainer.lockForm(!uiForm.isNewRepo_ && !uiForm.isNewWizard_);
            ws1.refreshPermissionList();
            event.getRequestContext().addUIComponentToUpdateByAjax(uiForm.getAncestorOfType(UIWorkspaceWizardContainer.class));
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AddPermissionActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiWizardForm = (UIWorkspaceWizard)((Object)event.getSource());
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)((UIWorkspaceWizardContainer)uiWizardForm.getAncestorOfType(UIWorkspaceWizardContainer.class)).getChild(UIPopupContainer.class);
            UIPopupContainer2.activate(UIPermissionContainer.class, 600);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BackActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            uiFormWizard.removePopup(UIWorkspaceWizard.POPUPID);
            int step = uiFormWizard.getCurrentStep();
            List children = uiFormWizard.getChildren();
            if (step > 0) {
                uiFormWizard.setCurrentSep(--step);
                for (int i = 0; i < children.size(); ++i) {
                    if (i == step) {
                        ((UIComponent)children.get(i)).setRendered(true);
                        uiFormWizard.setSelectedStep(step + 1);
                        continue;
                    }
                    ((UIComponent)children.get(i)).setRendered(false);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormWizard.getAncestorOfType(UIWorkspaceWizardContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NextActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            uiFormWizard.removePopup(UIWorkspaceWizard.POPUPID);
            UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            String wsName = (String)uiWSFormStep1.getUIStringInput("name").getValue();
            boolean isDefault = uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isChecked();
            boolean isDMSSytemWs = uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isChecked();
            String nodeType = (String)uiWSFormStep1.getUIFormSelectBox("autoInitializedRootNt").getValue();
            String lockTimeOut = (String)uiWSFormStep1.getUIStringInput("setLockTimeOut").getValue();
            UIWizardStep2 uiWSFormStep2 = (UIWizardStep2)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP2);
            String containerName = (String)uiWSFormStep2.getUIStringInput("container").getValue();
            boolean isExternalStoreage = uiWSFormStep2.getUIFormCheckBoxInput("externalStore").isChecked();
            String storeType = null;
            String storePath = null;
            if (isExternalStoreage) {
                storeType = (String)uiWSFormStep2.getUIStringInput("storeType").getValue();
                storePath = (String)uiWSFormStep2.getUIStringInput("storePath").getValue();
            }
            String sourceName = (String)uiWSFormStep2.getUIStringInput("sourceName").getValue();
            String swapPath = (String)uiWSFormStep2.getUIStringInput("swapPath").getValue();
            String maxBuffer = (String)uiWSFormStep2.getUIStringInput("maxBuffer").getValue();
            UIWizardStep3 uiWSFormStep3 = (UIWizardStep3)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP3);
            String indexPath = (String)uiWSFormStep3.getUIStringInput("indexPath").getValue();
            String maxCacheSize = (String)uiWSFormStep3.getUIStringInput("maxSize").getValue();
            UIApplication uiApp = (UIApplication)uiFormWizard.getAncestorOfType(UIApplication.class);
            if (uiFormWizard.isCheckValid_) {
                if (uiWSFormStep1.isRendered()) {
                    UIRepositoryForm uiRepoForm;
                    UIRepositoryFormContainer formContainer;
                    if (uiFormWizard.isEmpty(wsName)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    String[] arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\"", " "};
                    if (!Utils.isNameValid((String)wsName, (String[])arrFilterChar)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-not-allowed", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isNewWizard_) {
                        formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                        uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                        if (uiRepoForm.isExistWorkspace(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                        if (uiFormWizard.selectedWsName_ == null && uiRepoForm.getWorkspaceMap().containsKey(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                        if (!isDefault && uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isEnable()) {
                            uiRepoForm.defaulWorkspace_ = null;
                        }
                        if (!isDMSSytemWs && uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isEnable()) {
                            uiRepoForm.dmsSystemWorkspace_ = null;
                        }
                    } else if (uiFormWizard.isNewRepo_) {
                        formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                        uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                        if (uiRepoForm.isExistWorkspace(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                        if (uiFormWizard.selectedWsName_ == null && uiRepoForm.getWorkspaceMap().containsKey(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                        if (!isDefault && uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isEnable()) {
                            uiRepoForm.defaulWorkspace_ = null;
                        }
                        if (!isDMSSytemWs && uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isEnable()) {
                            uiRepoForm.dmsSystemWorkspace_ = null;
                        }
                    }
                    if (isDefault && !"nt:unstructured".equals(nodeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isDMSSytemWs && !"nt:unstructured".equals(nodeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalidSystemWs", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isNewWizard_ && uiWSFormStep1.isPermissionEmpty()) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.permission-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (Utils.isNameEmpty((String)lockTimeOut)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-required", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (!uiFormWizard.checkLockTimeOut(lockTimeOut)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (uiWSFormStep2.isRendered()) {
                    if (uiFormWizard.isEmpty(containerName)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.containerName-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(sourceName)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.sourceName-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isExternalStoreage && uiFormWizard.isEmpty(storeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.storeType-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(maxBuffer)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.buffer-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(swapPath)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.swapPath-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isExternalStoreage && uiFormWizard.isEmpty(storePath)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.storePath-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (uiWSFormStep3.isRendered() && Utils.isNameEmpty((String)indexPath)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.indexPath-invalid", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            if (uiFormWizard.isNewWizard_) {
                String swapPathAuto = swapPath;
                swapPathAuto = swapPath.substring(0, swapPath.lastIndexOf("/") + 1) + wsName;
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)swapPathAuto);
                String indexPathAuto = indexPath.substring(0, indexPath.lastIndexOf("/") + 1) + wsName;
                uiWSFormStep3.getUIStringInput("indexPath").setValue((Object)indexPathAuto);
                if (isExternalStoreage) {
                    String storePathAuto = storePath;
                    storePathAuto = storePath.substring(0, storePath.lastIndexOf("/") + 1) + wsName;
                    uiWSFormStep2.getUIStringInput("storePath").setValue((Object)storePathAuto);
                }
            }
            int step = uiFormWizard.getCurrentStep();
            List children = uiFormWizard.getChildren();
            if (step < uiFormWizard.getMaxStep()) {
                uiFormWizard.setCurrentSep(++step);
                for (int i = 0; i < children.size(); ++i) {
                    if (i == step) {
                        ((UIComponent)children.get(i)).setRendered(true);
                        uiFormWizard.setSelectedStep(step + 1);
                        continue;
                    }
                    ((UIComponent)children.get(i)).setRendered(false);
                }
            }
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormWizard.getAncestorOfType(UIWorkspaceWizardContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FinishActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            uiFormWizard.removePopup(UIWorkspaceWizard.POPUPID);
            long lockTimeOutValue = 0L;
            UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            String name = ((String)uiWSFormStep1.getUIStringInput("name").getValue()).trim();
            String initNodeType = (String)uiWSFormStep1.getUIFormSelectBox("autoInitializedRootNt").getValue();
            boolean isDefault = uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isChecked();
            boolean isDMSSystemWs = uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isChecked();
            String lockTimeOut = (String)uiWSFormStep1.getUIStringInput("setLockTimeOut").getValue();
            UIWizardStep2 uiWSFormStep2 = (UIWizardStep2)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP2);
            String containerType = (String)uiWSFormStep2.getUIStringInput("container").getValue();
            String sourceName = (String)uiWSFormStep2.getUIStringInput("sourceName").getValue();
            String dbType = (String)uiWSFormStep2.getUIFormSelectBox("dbType").getValue();
            boolean isMulti = uiWSFormStep2.getUIFormCheckBoxInput("isMulti").isChecked();
            String storeType = (String)uiWSFormStep2.getUIStringInput("storeType").getValue();
            String storePath = (String)uiWSFormStep2.getUIStringInput("storePath").getValue();
            String filterType = (String)uiWSFormStep2.getUIStringInput("filterType").getValue();
            String maxBuffer = (String)uiWSFormStep2.getUIStringInput("maxBuffer").getValue();
            String swapPath = (String)uiWSFormStep2.getUIStringInput("swapPath").getValue();
            UIWizardStep3 uiWSFormStep3 = (UIWizardStep3)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP3);
            String queryHandlerType = (String)uiWSFormStep3.getUIStringInput("queryHandler").getValue();
            String indexPath = (String)uiWSFormStep3.getUIStringInput("indexPath").getValue();
            boolean isCache = uiWSFormStep3.getUIFormCheckBoxInput("isCache").isChecked();
            String maxSize = (String)uiWSFormStep3.getUIStringInput("maxSize").getValue();
            String liveTime = (String)uiWSFormStep3.getUIStringInput("liveTime").getValue();
            UIApplication uiApp = (UIApplication)uiFormWizard.getAncestorOfType(UIApplication.class);
            UIRepositoryFormContainer formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
            UIRepositoryForm uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
            String[] arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\"", " "};
            if (!Utils.isNameValid((String)name, (String[])arrFilterChar)) {
                uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-not-allowed", null, 1));
                event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                return;
            }
            if (uiFormWizard.isCheckValid_) {
                if (uiFormWizard.isEmpty(queryHandlerType)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.queryHandlerType-invalid", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (uiFormWizard.isEmpty(indexPath)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.indexPath-invalid", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (isCache) {
                    if (uiFormWizard.isEmpty(maxSize)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.maxSize-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(liveTime)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.liveTime-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (lockTimeOut.endsWith("s") && !lockTimeOut.endsWith("ms")) {
                    lockTimeOut = lockTimeOut.substring(0, lockTimeOut.length() - 1);
                }
                lockTimeOutValue = StringNumberParser.parseTime((String)lockTimeOut);
                if (uiFormWizard.isNewWizard_ && uiRepoForm.isExistWorkspace(name)) {
                    Object[] args = new Object[]{name};
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
            }
            WorkspaceEntry workspaceEntry = new WorkspaceEntry(name, initNodeType);
            StringBuilder permSb = new StringBuilder();
            for (String s : uiWSFormStep1.getPermissions().values()) {
                if (!s.endsWith(";")) {
                    s = s + ";";
                }
                permSb.append(s);
            }
            LockManagerEntry lockEntry = new LockManagerEntry();
            lockEntry.setTimeout(lockTimeOutValue);
            LockPersisterEntry persisterEntry = new LockPersisterEntry();
            String lockPath = "../temp/lock/" + name;
            persisterEntry.setType(UIWorkspaceWizard.KEY_LOCKMANAGER);
            ArrayList<SimpleParameterEntry> lpParams = new ArrayList<SimpleParameterEntry>();
            lpParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_PATH, lockPath));
            persisterEntry.setParameters(lpParams);
            lockEntry.setPersister(persisterEntry);
            workspaceEntry.setLockManager(lockEntry);
            workspaceEntry.setContainer(this.newContainerEntry(containerType, sourceName, dbType, isMulti, storeType, filterType, maxBuffer, swapPath, storePath, true, name));
            workspaceEntry.setCache(this.newCacheEntry(isCache, maxSize, liveTime));
            workspaceEntry.setQueryHandler(this.newQueryHandlerEntry(queryHandlerType, indexPath));
            if (uiRepoForm.isAddnew_) {
                if (isDefault) {
                    uiRepoForm.defaulWorkspace_ = name;
                }
                if (isDMSSystemWs) {
                    uiRepoForm.dmsSystemWorkspace_ = name;
                }
                if (uiFormWizard.isNewWizard_) {
                    uiRepoForm.getWorkspaceMap().put(name, workspaceEntry);
                    uiRepoForm.getWorkspaceMapNodeType().put(name, initNodeType);
                    uiRepoForm.getWorkspaceMapPermission().put(name, permSb.toString());
                } else {
                    uiRepoForm.getWorkspaceMap().remove(uiFormWizard.selectedWsName_);
                    uiRepoForm.getWorkspaceMap().put(name, workspaceEntry);
                    uiRepoForm.getWorkspaceMapNodeType().remove(uiFormWizard.selectedWsName_);
                    uiRepoForm.getWorkspaceMapNodeType().put(name, initNodeType);
                    uiRepoForm.getWorkspaceMapPermission().remove(uiFormWizard.selectedWsName_);
                    uiRepoForm.getWorkspaceMapPermission().put(name, permSb.toString());
                }
                uiRepoForm.refreshWorkspaceList();
            }
            if (!uiRepoForm.isAddnew_ && uiFormWizard.isNewWizard_) {
                InitialContextInitializer ic = (InitialContextInitializer)((ExoContainer)uiFormWizard.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(InitialContextInitializer.class);
                if (ic != null) {
                    ic.recall();
                }
                RepositoryService rService = (RepositoryService)((ExoContainer)uiFormWizard.getApplicationComponent(ExoContainer.class)).getComponentInstanceOfType(RepositoryService.class);
                ManageableRepository manageRepository = rService.getRepository(uiRepoForm.repoName_);
                try {
                    manageRepository.configWorkspace(workspaceEntry);
                    manageRepository.createWorkspace(workspaceEntry.getName());
                    if (rService.getConfig().isRetainable()) {
                        rService.getConfig().retain();
                    }
                    Session systemSession = manageRepository.getSystemSession(name);
                    uiFormWizard.setPermissionToRoot((ExtendedNode)systemSession.getRootNode(), permSb.toString());
                    uiRepoForm.workspaceMap_.clear();
                    for (WorkspaceEntry ws : manageRepository.getConfiguration().getWorkspaceEntries()) {
                        uiRepoForm.workspaceMap_.put(ws.getName(), ws);
                    }
                    uiRepoForm.refreshWorkspaceList();
                    systemSession.logout();
                }
                catch (Exception e) {
                    LOG.error((Object)"Unexpected error", (Throwable)e);
                    return;
                }
            }
            UIPopupContainer UIPopupContainer2 = (UIPopupContainer)uiFormWizard.getAncestorOfType(UIPopupContainer.class);
            UIPopupContainer2.deActivate();
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)UIPopupContainer2);
            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiRepoForm);
        }

        private ContainerEntry newContainerEntry(String containerType, String sourceName, String dbType, boolean isMulti, String storeType, String filterType, String bufferValue, String swapPath, String storePath, boolean isUpdateStore, String valueStorageId) {
            ArrayList<SimpleParameterEntry> containerParams = new ArrayList<SimpleParameterEntry>();
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_SOURCENAME, sourceName));
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_DIALECT, dbType));
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_MULTIDB, String.valueOf(isMulti)));
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_UPDATESTORE, String.valueOf(isUpdateStore)));
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_MAXBUFFER, bufferValue));
            containerParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_SWAPDIRECTORY, swapPath));
            ContainerEntry containerEntry = new ContainerEntry(containerType, containerParams);
            containerEntry.setParameters(containerParams);
            if (storeType != null) {
                ArrayList<ValueStorageFilterEntry> vsparams = new ArrayList<ValueStorageFilterEntry>();
                ValueStorageFilterEntry filterEntry = new ValueStorageFilterEntry();
                filterEntry.setPropertyType(filterType);
                vsparams.add(filterEntry);
                ValueStorageEntry valueStorageEntry = new ValueStorageEntry(storeType, vsparams);
                ArrayList<SimpleParameterEntry> spe = new ArrayList<SimpleParameterEntry>();
                spe.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_PATH, storePath));
                valueStorageEntry.setId(valueStorageId);
                valueStorageEntry.setParameters(spe);
                valueStorageEntry.setFilters(vsparams);
                ArrayList<ValueStorageEntry> list = new ArrayList<ValueStorageEntry>(1);
                list.add(valueStorageEntry);
                containerEntry.setValueStorages(list);
            } else {
                containerEntry.setValueStorages(new ArrayList());
            }
            return containerEntry;
        }

        private ValueStorageEntry newValueStorageEntry(String storeType, String value, String filter) {
            ArrayList vsparams = new ArrayList();
            ValueStorageEntry valueStorageEntry = new ValueStorageEntry(storeType, vsparams);
            return valueStorageEntry;
        }

        private CacheEntry newCacheEntry(boolean isCache, String maxSizeValue, String liveTimeValue) {
            CacheEntry cache = new CacheEntry();
            cache.setEnabled(isCache);
            ArrayList<SimpleParameterEntry> cacheParams = new ArrayList<SimpleParameterEntry>();
            cacheParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_MAXSIZE, maxSizeValue));
            cacheParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_LIVETIME, liveTimeValue));
            cache.setParameters(cacheParams);
            return cache;
        }

        private QueryHandlerEntry newQueryHandlerEntry(String queryHandlerType, String indexPath) {
            ArrayList<SimpleParameterEntry> queryParams = new ArrayList<SimpleParameterEntry>();
            queryParams.add(new SimpleParameterEntry(UIWorkspaceWizard.KEY_INDEXDIR, indexPath));
            QueryHandlerEntry queryHandler = new QueryHandlerEntry(queryHandlerType, queryParams);
            queryHandler.setType(queryHandlerType);
            queryHandler.setParameters(queryParams);
            return queryHandler;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep3ActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIApplication uiApp = (UIApplication)uiFormWizard.getAncestorOfType(UIApplication.class);
            UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            String wsName = (String)uiWSFormStep1.getUIStringInput("name").getValue();
            boolean isDefault = uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isChecked();
            boolean isDMSSystemWs = uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isChecked();
            String nodeType = (String)uiWSFormStep1.getUIFormSelectBox("autoInitializedRootNt").getValue();
            String lockTimeOut = (String)uiWSFormStep1.getUIStringInput("setLockTimeOut").getValue();
            UIFormInputSet uiWSFormStep2 = (UIFormInputSet)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP2);
            UIWizardStep3 uiWSFormStep3 = (UIWizardStep3)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP3);
            String sourceName = (String)uiWSFormStep2.getUIStringInput("sourceName").getValue();
            String containerType = (String)uiWSFormStep2.getUIStringInput("container").getValue();
            String storeType = (String)uiWSFormStep2.getUIStringInput("storeType").getValue();
            String storePath = (String)uiWSFormStep2.getUIStringInput("storePath").getValue();
            String swapPath = (String)uiWSFormStep2.getUIStringInput("swapPath").getValue();
            String maxBuffer = (String)uiWSFormStep2.getUIStringInput("maxBuffer").getValue();
            String indexPath = (String)uiWSFormStep3.getUIStringInput("indexPath").getValue();
            if (uiFormWizard.isCheckValid_) {
                if (uiWSFormStep1.isRendered()) {
                    UIRepositoryForm uiRepoForm;
                    UIRepositoryFormContainer formContainer;
                    if (uiFormWizard.isEmpty(wsName)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    String[] arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\"", " "};
                    if (!Utils.isNameValid((String)wsName, (String[])arrFilterChar)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-not-allowed", null, 1));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isDefault && !"nt:unstructured".equals(nodeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isDMSSystemWs && !"nt:unstructured".equals(nodeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalidSystemWs", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isNewWizard_) {
                        formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                        uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                        if (uiRepoForm.isExistWorkspace(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                    } else if (uiFormWizard.isNewRepo_) {
                        formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                        uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                        if (uiFormWizard.selectedWsName_ == null && uiRepoForm.getWorkspaceMap().containsKey(wsName)) {
                            Object[] args = new Object[]{wsName};
                            uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                            event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                            return;
                        }
                    }
                    if (uiFormWizard.isNewWizard_ && uiWSFormStep1.isPermissionEmpty()) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.permission-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (Utils.isNameEmpty((String)lockTimeOut)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-required", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (!uiFormWizard.checkLockTimeOut(lockTimeOut)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (uiWSFormStep2.isRendered()) {
                    boolean isExternalStoreage = uiWSFormStep2.getUIFormCheckBoxInput("externalStore").isChecked();
                    if (uiFormWizard.isEmpty(containerType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.containerName-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(sourceName)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.sourceName-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isExternalStoreage && uiFormWizard.isEmpty(storeType)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.storeType-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (uiFormWizard.isEmpty(maxBuffer)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.buffer-require", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (Utils.isNameEmpty((String)swapPath)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.swapPath-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                    if (isExternalStoreage && uiFormWizard.isEmpty(storePath)) {
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.storePath-invalid", null));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
            }
            if (uiFormWizard.isNewWizard_) {
                boolean isExternalStoreage = uiWSFormStep2.getUIFormCheckBoxInput("externalStore").isChecked();
                String swapPathAuto = swapPath;
                swapPathAuto = swapPath.substring(0, swapPath.lastIndexOf("/") + 1) + wsName;
                String indexPathAuto = indexPath.substring(0, indexPath.lastIndexOf("/") + 1) + wsName;
                uiWSFormStep3.getUIStringInput("indexPath").setValue((Object)indexPathAuto);
                if (isExternalStoreage) {
                    String storePathAuto = storePath;
                    storePathAuto = storePath.substring(0, storePath.lastIndexOf("/") + 1) + wsName;
                    uiWSFormStep2.getUIStringInput("storePath").setValue((Object)storePathAuto);
                }
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)swapPathAuto);
            }
            uiFormWizard.viewStep(3);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormWizard.getAncestorOfType(UIPopupContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep2ActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            UIWizardStep1 uiWSFormStep1 = (UIWizardStep1)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP1);
            String wsName = (String)uiWSFormStep1.getUIStringInput("name").getValue();
            boolean isDefault = uiWSFormStep1.getUIFormCheckBoxInput("isDefault").isChecked();
            boolean isDMSSystemWs = uiWSFormStep1.getUIFormCheckBoxInput("isDMSSytemWs").isChecked();
            String nodeType = (String)uiWSFormStep1.getUIFormSelectBox("autoInitializedRootNt").getValue();
            String lockTimeOut = (String)uiWSFormStep1.getUIStringInput("setLockTimeOut").getValue();
            UIFormInputSet uiWSFormStep2 = (UIFormInputSet)uiFormWizard.getChildById(UIWorkspaceWizard.FIELD_STEP2);
            boolean isExternalStoreage = uiWSFormStep2.getUIFormCheckBoxInput("externalStore").isChecked();
            String storePath = null;
            if (isExternalStoreage) {
                storePath = (String)uiWSFormStep2.getUIStringInput("storePath").getValue();
            }
            String swapPath = (String)uiWSFormStep2.getUIStringInput("swapPath").getValue();
            UIApplication uiApp = (UIApplication)uiFormWizard.getAncestorOfType(UIApplication.class);
            if (uiFormWizard.isCheckValid_ && uiWSFormStep1.isRendered()) {
                UIRepositoryFormContainer formContainer;
                if (uiFormWizard.isEmpty(wsName)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-require", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                String[] arrFilterChar = new String[]{"&", "$", "@", ":", "]", "[", "*", "%", "!", "+", "(", ")", "'", "#", ";", "}", "{", "/", "|", "\"", " "};
                if (!Utils.isNameValid((String)wsName, (String[])arrFilterChar)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.name-not-allowed", null, 1));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (uiFormWizard.isNewWizard_) {
                    formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                    UIRepositoryForm uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                    if (uiRepoForm.isExistWorkspace(wsName)) {
                        Object[] args = new Object[]{wsName};
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                } else if (uiFormWizard.isNewRepo_) {
                    formContainer = (UIRepositoryFormContainer)uiFormWizard.getAncestorOfType(UIRepositoryFormContainer.class);
                    UIRepositoryForm uiRepoForm = (UIRepositoryForm)formContainer.findFirstComponentOfType(UIRepositoryForm.class);
                    if (uiFormWizard.selectedWsName_ == null && uiRepoForm.getWorkspaceMap().containsKey(wsName)) {
                        Object[] args = new Object[]{wsName};
                        uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.wsname-exist", args));
                        event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                        return;
                    }
                }
                if (isDefault && !"nt:unstructured".equals(nodeType)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalid", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (isDMSSystemWs && !"nt:unstructured".equals(nodeType)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.nodeType-invalidSystemWs", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (uiFormWizard.isNewWizard_ && uiWSFormStep1.isPermissionEmpty()) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.permission-require", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (Utils.isNameEmpty((String)lockTimeOut)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-required", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (!uiFormWizard.checkLockTimeOut(lockTimeOut)) {
                    uiApp.addMessage(new ApplicationMessage("UIWorkspaceWizard.msg.lockTimeOut-invalid", null));
                    event.getRequestContext().addUIComponentToUpdateByAjax((UIComponent)uiApp.getUIPopupMessages());
                    return;
                }
                if (!Utils.isNameEmpty((String)swapPath) && !swapPath.contains(wsName)) {
                    swapPath = swapPath + wsName;
                }
                if (isExternalStoreage && !Utils.isNameEmpty((String)storePath)) {
                    if (!storePath.contains(wsName)) {
                        storePath = storePath + wsName;
                    }
                    uiWSFormStep2.getUIStringInput("storePath").setValue((Object)storePath);
                }
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)swapPath);
            }
            if (uiFormWizard.isNewWizard_) {
                String swapPathAuto = swapPath;
                swapPathAuto = swapPath.substring(0, swapPath.lastIndexOf("/") + 1) + wsName;
                uiWSFormStep2.getUIStringInput("swapPath").setValue((Object)swapPathAuto);
                if (isExternalStoreage) {
                    String storePathAuto = storePath;
                    storePathAuto = storePath.substring(0, storePath.lastIndexOf("/") + 1) + wsName;
                    uiWSFormStep2.getUIStringInput("storePath").setValue((Object)storePathAuto);
                }
            }
            uiFormWizard.viewStep(2);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormWizard.getAncestorOfType(UIPopupContainer.class));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ViewStep1ActionListener
    extends EventListener<UIWorkspaceWizard> {
        public void execute(Event<UIWorkspaceWizard> event) throws Exception {
            UIWorkspaceWizard uiFormWizard = (UIWorkspaceWizard)((Object)event.getSource());
            uiFormWizard.viewStep(1);
            event.getRequestContext().addUIComponentToUpdateByAjax(uiFormWizard.getAncestorOfType(UIPopupContainer.class));
        }
    }
}

