/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.el;

import de.odysseus.el.ObjectValueExpression;
import de.odysseus.el.TreeMethodExpression;
import de.odysseus.el.TreeValueExpression;
import de.odysseus.el.misc.TypeConverter;
import de.odysseus.el.tree.TreeBuilder;
import de.odysseus.el.tree.TreeStore;
import de.odysseus.el.tree.impl.Builder;
import de.odysseus.el.tree.impl.Cache;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.util.EnumSet;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionFactoryImpl
extends ExpressionFactory {
    private final TreeStore store;
    private final TypeConverter converter;

    public ExpressionFactoryImpl() {
        Properties properties = this.loadProperties("el.properties");
        this.store = this.createTreeStore(1000, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(Properties properties) {
        this.store = this.createTreeStore(1000, properties);
        this.converter = this.createTypeConverter(properties);
    }

    public ExpressionFactoryImpl(TreeStore store) {
        this(store, TypeConverter.DEFAULT);
    }

    public ExpressionFactoryImpl(TreeStore store, TypeConverter converter) {
        this.store = store;
        this.converter = converter;
    }

    private Properties loadDefaultProperties() {
        String home = System.getProperty("java.home");
        String path = home + File.separator + "lib" + File.separator + "el.properties";
        File file = new File(path);
        if (file.exists()) {
            Properties properties = new Properties();
            InputStream input = null;
            try {
                input = new FileInputStream(file);
                properties.load(input);
            }
            catch (IOException e) {
                throw new ELException("Cannot read default EL properties", (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
            String clazz = properties.getProperty("javax.el.ExpressionFactory");
            if (((Object)((Object)this)).getClass().getName().equals(clazz)) {
                return properties;
            }
        }
        return null;
    }

    private Properties loadProperties(String path) {
        Properties properties = new Properties(this.loadDefaultProperties());
        InputStream input = null;
        try {
            input = Thread.currentThread().getContextClassLoader().getResourceAsStream(path);
        }
        catch (SecurityException e) {
            input = ClassLoader.getSystemResourceAsStream(path);
        }
        if (input != null) {
            try {
                properties.load(input);
            }
            catch (IOException e) {
                throw new ELException("Cannot read EL properties", (Throwable)e);
            }
            finally {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
        return properties;
    }

    protected TreeStore createTreeStore(int defaultCacheSize, Properties properties) {
        EnumSet<Builder.Feature> features = EnumSet.noneOf(Builder.Feature.class);
        if (properties != null) {
            if (Boolean.valueOf(properties.getProperty("javax.el.methodInvocations")).booleanValue()) {
                features.add(Builder.Feature.METHOD_INVOCATIONS);
            }
            if (Boolean.valueOf(properties.getProperty("javax.el.nullProperties")).booleanValue()) {
                features.add(Builder.Feature.NULL_PROPERTIES);
            }
            if (Boolean.valueOf(properties.getProperty("javax.el.varArgs")).booleanValue()) {
                features.add(Builder.Feature.VARARGS);
            }
        }
        TreeBuilder builder = this.createTreeBuilder(properties, features.toArray(new Builder.Feature[0]));
        int cacheSize = defaultCacheSize;
        if (properties != null && properties.containsKey("javax.el.cacheSize")) {
            try {
                cacheSize = Integer.parseInt(properties.getProperty("javax.el.cacheSize"));
            }
            catch (NumberFormatException e) {
                throw new ELException("Cannot parse EL property javax.el.cacheSize", (Throwable)e);
            }
        }
        Cache cache = cacheSize > 0 ? new Cache(cacheSize) : null;
        return new TreeStore(builder, cache);
    }

    protected TypeConverter createTypeConverter(Properties properties) {
        Class<?> clazz = this.load(TypeConverter.class, properties);
        if (clazz == null) {
            return TypeConverter.DEFAULT;
        }
        try {
            return (TypeConverter)TypeConverter.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new ELException("TypeConverter " + clazz + " could not be instantiated", (Throwable)e);
        }
    }

    protected TreeBuilder createTreeBuilder(Properties properties, Builder.Feature ... features) {
        Class<?> clazz = this.load(TreeBuilder.class, properties);
        if (clazz == null) {
            return new Builder(features);
        }
        try {
            if (Builder.class.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(Builder.Feature[].class);
                if (constructor == null) {
                    if (features == null || features.length == 0) {
                        return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
                    }
                    throw new ELException("Builder " + clazz + " is missing constructor (can't pass features)");
                }
                return (TreeBuilder)TreeBuilder.class.cast(constructor.newInstance(new Object[]{features}));
            }
            return (TreeBuilder)TreeBuilder.class.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new ELException("TreeBuilder " + clazz + " could not be instantiated", (Throwable)e);
        }
    }

    private Class<?> load(Class<?> clazz, Properties properties) {
        String className;
        if (properties != null && (className = properties.getProperty(clazz.getName())) != null) {
            ClassLoader loader;
            try {
                loader = Thread.currentThread().getContextClassLoader();
            }
            catch (Exception e) {
                throw new ELException("Could not get context class loader", (Throwable)e);
            }
            try {
                return loader == null ? Class.forName(className) : loader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ELException("Class " + className + " not found", (Throwable)e);
            }
            catch (Exception e) {
                throw new ELException("Class " + className + " could not be instantiated", (Throwable)e);
            }
        }
        return null;
    }

    public final Object coerceToType(Object obj, Class<?> targetType) {
        return this.converter.convert(obj, targetType);
    }

    public final ObjectValueExpression createValueExpression(Object instance, Class<?> expectedType) {
        return new ObjectValueExpression(this.converter, instance, expectedType);
    }

    public final TreeValueExpression createValueExpression(ELContext context, String expression, Class<?> expectedType) {
        return new TreeValueExpression(this.store, context.getFunctionMapper(), context.getVariableMapper(), this.converter, expression, expectedType);
    }

    public final TreeMethodExpression createMethodExpression(ELContext context, String expression, Class<?> expectedReturnType, Class<?>[] expectedParamTypes) {
        return new TreeMethodExpression(this.store, context.getFunctionMapper(), context.getVariableMapper(), this.converter, expression, expectedReturnType, expectedParamTypes);
    }
}

