/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.search.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.xcmis.search.lucene.index.CompositeTransactionLog;
import org.xcmis.search.lucene.index.IndexException;
import org.xcmis.search.lucene.index.IndexTransaction;
import org.xcmis.search.lucene.index.LoggedIndexTransactionImpl;
import org.xcmis.search.lucene.index.LuceneIndexDataKeeperFactory;
import org.xcmis.search.lucene.index.LuceneIndexDataManager;
import org.xcmis.search.lucene.index.ReducibleInMemoryIndexDataKeeper;
import org.xcmis.search.lucene.index.TransactionLog;
import org.xcmis.search.lucene.index.TransactionLogException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryIndexDataKeeperFactory
extends LuceneIndexDataKeeperFactory {
    private static final Log LOG = ExoLogger.getLogger(InMemoryIndexDataKeeperFactory.class);

    @Override
    public LuceneIndexDataManager createNewIndexDataKeeper(IndexTransaction<Document> changes) throws IndexException {
        if (!(changes instanceof LoggedIndexTransactionImpl)) {
            throw new IndexException("Fail to create in memory storage for not loged transaction");
        }
        return new ReducibleInMemoryIndexDataKeeper((LoggedIndexTransactionImpl)changes);
    }

    @Override
    public LuceneIndexDataManager merge(Collection<LuceneIndexDataManager> chains) throws IndexException {
        ArrayList<TransactionLog> transactionsLogs = new ArrayList<TransactionLog>();
        ArrayList<RAMDirectory> mergeDirectorys = new ArrayList<RAMDirectory>();
        HashMap<String, Document> documentsBuffer = new HashMap<String, Document>();
        HashMap<String, Document> pendingBuffer = new HashMap<String, Document>();
        for (LuceneIndexDataManager indexDataKeeper : chains) {
            ReducibleInMemoryIndexDataKeeper reducibleInMemoryIndexDataKeeper = (ReducibleInMemoryIndexDataKeeper)indexDataKeeper;
            if (reducibleInMemoryIndexDataKeeper.getDocumentCount() <= 0L) continue;
            RAMDirectory directory = (RAMDirectory)reducibleInMemoryIndexDataKeeper.getDirectory();
            if (directory.sizeInBytes() > 0L) {
                mergeDirectorys.add(directory);
            }
            pendingBuffer.putAll(reducibleInMemoryIndexDataKeeper.getPendingDocumentsBuffer());
            documentsBuffer.putAll(reducibleInMemoryIndexDataKeeper.getDocumentsBuffer());
            transactionsLogs.add(reducibleInMemoryIndexDataKeeper.getTransactionLog());
        }
        ReducibleInMemoryIndexDataKeeper reducibleInMemoryIndexDataKeeper = null;
        try {
            RAMDirectory newDirectory = null;
            if (mergeDirectorys.size() > 0) {
                newDirectory = new RAMDirectory();
                IndexWriter newWriter = new IndexWriter((Directory)newDirectory, (Analyzer)new StandardAnalyzer(), IndexWriter.MaxFieldLength.UNLIMITED);
                Directory[] dirsToMerge = new Directory[mergeDirectorys.size()];
                newWriter.addIndexesNoOptimize(mergeDirectorys.toArray(dirsToMerge));
                newWriter.optimize();
                newWriter.close();
            } else {
                newDirectory = new RAMDirectory();
            }
            reducibleInMemoryIndexDataKeeper = new ReducibleInMemoryIndexDataKeeper(newDirectory, documentsBuffer, pendingBuffer, new CompositeTransactionLog(transactionsLogs));
        }
        catch (IOException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        catch (TransactionLogException e) {
            throw new IndexException(e.getLocalizedMessage(), e);
        }
        return reducibleInMemoryIndexDataKeeper;
    }
}

