/*
 * Decompiled with CFR 0.152.
 */
package org.xcmis.restatom.abdera;

import java.math.BigInteger;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Element;
import org.apache.abdera.model.ExtensibleElementWrapper;
import org.xcmis.restatom.AtomCMIS;
import org.xcmis.restatom.abdera.ChoiceElement;
import org.xcmis.spi.model.Choice;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChoiceIntegerElement
extends ChoiceElement<Choice<BigInteger>> {
    public ChoiceIntegerElement(Element internal) {
        super(internal);
    }

    public ChoiceIntegerElement(Factory factory, QName qname) {
        super(factory, qname);
    }

    @Override
    public void build(Choice<BigInteger> choice) {
        if (choice != null) {
            super.build(choice);
            if (choice.getValues() != null && ((BigInteger[])choice.getValues()).length > 0) {
                for (BigInteger v : (BigInteger[])choice.getValues()) {
                    if (v == null) continue;
                    this.addSimpleExtension(AtomCMIS.VALUE, v.toString());
                }
            }
            if (choice.getChoices() != null && choice.getChoices().size() > 0) {
                for (Choice ch : choice.getChoices()) {
                    ExtensibleElementWrapper el = (ExtensibleElementWrapper)this.addExtension(AtomCMIS.CHOICE);
                    new ChoiceIntegerElement((Element)el).build((Choice<BigInteger>)ch);
                }
            }
        }
    }

    @Override
    public Choice<BigInteger> getChoice() {
        List choices;
        Choice result = new Choice();
        List values = this.getExtensions(AtomCMIS.VALUE);
        if (values != null && values.size() > 0) {
            Object[] array = new BigInteger[values.size()];
            int i = 0;
            for (Element element : values) {
                array[i] = new BigInteger(element.getText());
                ++i;
            }
            result.setValues(array);
        }
        if ((choices = this.getExtensions(AtomCMIS.CHOICE)) != null && choices.size() > 0) {
            for (ExtensibleElementWrapper choiceIntegerElement : choices) {
                result.getChoices().add(new ChoiceIntegerElement((Element)choiceIntegerElement).getChoice());
            }
        }
        return result;
    }
}

